/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.api.engine.security.IAuthenticationRoleMapper;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.jdbc.JdbcDaoImpl;
import org.springframework.util.Assert;

public class DefaultRoleJdbcDaoImpl
extends JdbcDaoImpl {
    private GrantedAuthority defaultRole;
    private IAuthenticationRoleMapper roleMapper;
    ITenantedPrincipleNameResolver userNameUtils;

    public DefaultRoleJdbcDaoImpl(ITenantedPrincipleNameResolver userNameUtils) {
        this.userNameUtils = userNameUtils;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return super.loadUserByUsername(this.userNameUtils.getPrincipleName(username));
    }

    protected void addCustomAuthorities(String username, List authorities) {
        if (this.defaultRole != null && !authorities.contains(this.defaultRole)) {
            authorities.add(this.defaultRole);
        }
        if (this.roleMapper != null) {
            ArrayList currentAuthorities = new ArrayList();
            currentAuthorities.addAll(authorities);
            for (GrantedAuthority role : currentAuthorities) {
                GrantedAuthorityImpl mappedRole = new GrantedAuthorityImpl(this.roleMapper.toPentahoRole(role.getAuthority()));
                if (authorities.contains(mappedRole)) continue;
                authorities.add(mappedRole);
            }
        }
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole);
        this.defaultRole = new GrantedAuthorityImpl(defaultRole);
    }

    public void setRoleMapper(IAuthenticationRoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }
}

