/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.acls;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IAclPublisher;
import org.pentaho.platform.api.engine.IAclSolutionFile;
import org.pentaho.platform.api.engine.IPermissionMask;
import org.pentaho.platform.api.engine.IPermissionRecipient;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SimplePermissionMask;
import org.pentaho.platform.engine.security.SimpleRole;
import org.pentaho.platform.engine.security.SimpleUser;
import org.pentaho.platform.engine.security.SpringSecurityPermissionMgr;
import org.pentaho.platform.engine.security.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class AclPublisher
implements IAclPublisher {
    private static final String NOTHING = "NOTHING";
    private static final String ADMINISTRATION = "ADMINISTRATION";
    private static final String EXECUTE = "EXECUTE";
    private static final String EXECUTE_ADMINISTRATION = "EXECUTE_ADMINISTRATION";
    private static final String SUBSCRIBE = "SUBSCRIBE";
    private static final String CREATE = "CREATE";
    private static final String UPDATE = "UPDATE";
    private static final String DELETE = "DELETE";
    private static final String SUBSCRIBE_ADMINISTRATION = "SUBSCRIBE_ADMINISTRATION";
    private static final String EXECUTE_SUBSCRIBE = "EXECUTE_SUBSCRIBE";
    @Deprecated
    private static final String ADMIN_ALL = "ADMIN_ALL";
    private static final String FULL_CONTROL = "FULL_CONTROL";
    private Map<IPermissionRecipient, IPermissionMask> defaultAcls = Collections.EMPTY_MAP;

    public AclPublisher(Map<IPermissionRecipient, IPermissionMask> defAcls) {
        this.defaultAcls = new LinkedHashMap<IPermissionRecipient, IPermissionMask>(defAcls);
    }

    public AclPublisher() {
        ISystemSettings settings = PentahoSystem.getSystemSettings();
        List sysAcls = settings.getSystemSettings("default-acls/*");
        this.defaultAcls = this.aclFromNodeList(sysAcls);
    }

    private Map<IPermissionRecipient, IPermissionMask> aclFromNodeList(List sysAcls) {
        LinkedHashMap<IPermissionRecipient, IPermissionMask> pentahoAclEntries = new LinkedHashMap<IPermissionRecipient, IPermissionMask>();
        for (int i = 0; i < sysAcls.size(); ++i) {
            Object obj = sysAcls.get(i);
            Element defAcl = (Element)obj;
            String aclRole = XmlDom4JHelper.getNodeText("@role", (Node)defAcl, null);
            String aclUser = XmlDom4JHelper.getNodeText("@user", (Node)defAcl, null);
            String aclStr = XmlDom4JHelper.getNodeText("@acl", (Node)defAcl, null);
            if (aclRole == null && aclUser == null) {
                throw new IllegalArgumentException(Messages.getInstance().getErrorString("AclPublisher.ERROR_0001_DEFAULT_ACL_REQUIRES_USER_OR_ROLE"));
            }
            if (aclRole != null && aclUser != null) {
                throw new IllegalArgumentException(Messages.getInstance().getErrorString("AclPublisher.ERROR_0002_DEFAULT_ACL_HAS_BOTH"));
            }
            int aclValue = -1;
            if (aclStr != null) {
                if (NOTHING.equalsIgnoreCase(aclStr)) {
                    aclValue = 0;
                } else if (EXECUTE.equalsIgnoreCase(aclStr)) {
                    aclValue = 1;
                } else if (SUBSCRIBE.equalsIgnoreCase(aclStr)) {
                    aclValue = 2;
                } else if (EXECUTE_SUBSCRIBE.equalsIgnoreCase(aclStr)) {
                    aclValue = 3;
                } else if (CREATE.equalsIgnoreCase(aclStr)) {
                    aclValue = 4;
                } else if (UPDATE.equalsIgnoreCase(aclStr)) {
                    aclValue = 8;
                } else if (DELETE.equalsIgnoreCase(aclStr)) {
                    aclValue = 16;
                } else if (ADMINISTRATION.equalsIgnoreCase(aclStr)) {
                    aclValue = 60;
                } else if (EXECUTE_ADMINISTRATION.equalsIgnoreCase(aclStr)) {
                    aclValue = 61;
                } else if (SUBSCRIBE_ADMINISTRATION.equalsIgnoreCase(aclStr)) {
                    aclValue = 62;
                } else if (ADMIN_ALL.equalsIgnoreCase(aclStr)) {
                    aclValue = 31;
                } else if (FULL_CONTROL.equalsIgnoreCase(aclStr)) {
                    aclValue = -1;
                } else {
                    try {
                        aclValue = Integer.parseInt(aclStr);
                    }
                    catch (Exception ignored) {
                        continue;
                    }
                }
            }
            if (aclUser != null) {
                pentahoAclEntries.put(new SimpleUser(aclUser), new SimplePermissionMask(aclValue));
                continue;
            }
            pentahoAclEntries.put(new SimpleRole(aclRole), new SimplePermissionMask(aclValue));
        }
        return pentahoAclEntries;
    }

    public void publishDefaultAcls(IAclSolutionFile rootFile) {
        this.publishDefaultFolderAcls(rootFile);
        this.publishOverrideAcls(rootFile);
    }

    private void publishDefaultFolderAcls(IAclSolutionFile rootFile) {
        if (rootFile != null && rootFile.isDirectory()) {
            Set kids;
            if (rootFile.getAccessControls().size() == 0) {
                SpringSecurityPermissionMgr.instance().setPermissions(this.defaultAcls, rootFile);
            }
            if ((kids = rootFile.getChildrenFiles()) != null) {
                Iterator it = kids.iterator();
                IAclSolutionFile aChild = null;
                while (it.hasNext()) {
                    aChild = (IAclSolutionFile)it.next();
                    if (!aChild.isDirectory()) continue;
                    this.publishDefaultFolderAcls(aChild);
                }
            }
        }
    }

    private void publishOverrideAcls(IAclSolutionFile rootFile) {
        Map<IPermissionRecipient, IPermissionMask> currentPerms;
        Map<IPermissionRecipient, IPermissionMask> overridePerms = this.getOverrideAclList(rootFile.getFullPath());
        if (overridePerms.size() > 0 && ((currentPerms = SpringSecurityPermissionMgr.instance().getPermissions(rootFile)).size() == 0 || currentPerms.size() == this.defaultAcls.size() && currentPerms.entrySet().containsAll(this.defaultAcls.entrySet()))) {
            SpringSecurityPermissionMgr.instance().setPermissions(overridePerms, rootFile);
        }
        if (rootFile.isDirectory()) {
            Iterator iter = rootFile.getChildrenFiles().iterator();
            while (iter.hasNext()) {
                this.publishOverrideAcls((IAclSolutionFile)iter.next());
            }
        }
    }

    private Map<IPermissionRecipient, IPermissionMask> getOverrideAclList(String fullPath) {
        ISystemSettings settings = PentahoSystem.getSystemSettings();
        return this.aclFromNodeList(settings.getSystemSettings("overrides/file[@path=\"" + fullPath + "\"]/*"));
    }

    public Map<IPermissionRecipient, IPermissionMask> getDefaultAclList() {
        return Collections.unmodifiableMap(this.defaultAcls);
    }
}

