/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.acls;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoAclEntry;
import org.pentaho.platform.engine.security.messages.Messages;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.acl.basic.AbstractBasicAclEntry;

public class PentahoAclEntry
extends AbstractBasicAclEntry
implements IPentahoAclEntry {
    private static final Log logger = LogFactory.getLog(PentahoAclEntry.class);
    private static int[] validPermissions;
    private static final long serialVersionUID = -1123574274303339402L;
    private static final int RECIPIENT_STRING = 0;
    private static final int RECIPIENT_GRANTEDAUTHORITY = 1;
    private static final Map validPermissionsNameMap;
    public int recipientType = 0;
    private int[] lazyPermissionClone;

    private static void initializePermissionsArray() {
        if (null == validPermissions) {
            Field[] fields;
            int maxPower = -1;
            for (Field field : fields = IPentahoAclEntry.class.getDeclaredFields()) {
                if (Integer.TYPE != field.getType() || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !field.getName().startsWith("PERM_")) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Candidate field: " + field.getName()));
                }
                double powerOfTwo = -1.0;
                try {
                    powerOfTwo = Math.log(field.getInt(null)) / Math.log(2.0);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                if (powerOfTwo != (double)((int)powerOfTwo) || !(powerOfTwo > (double)maxPower)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Found new power of two.");
                }
                maxPower = (int)powerOfTwo;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Max power of two: " + maxPower));
            }
            int numberOfPermutations = (int)Math.pow(2.0, maxPower + 1);
            validPermissions = new int[numberOfPermutations + 1];
            for (int i = 0; i < numberOfPermutations; ++i) {
                PentahoAclEntry.validPermissions[i] = i;
            }
            PentahoAclEntry.validPermissions[PentahoAclEntry.validPermissions.length - 1] = -1;
        }
    }

    public PentahoAclEntry() {
    }

    public PentahoAclEntry(Object recipient, int mask) {
        this();
        this.setRecipient(recipient);
        this.setMask(mask);
    }

    protected void setRecipientType(int value) {
        this.recipientType = value;
    }

    protected int getRecipientType() {
        return this.recipientType;
    }

    protected void setRecipientString(String value) {
        if (this.recipientType == 1) {
            this.setRecipient(new GrantedAuthorityImpl(value));
        } else {
            this.setRecipient(value);
        }
    }

    protected String getRecipientString() {
        return this.getRecipient().toString();
    }

    public void setRecipient(Object value) {
        super.setRecipient(value);
        if (value instanceof GrantedAuthority) {
            this.setRecipientType(1);
        } else {
            this.setRecipientType(0);
        }
    }

    public int[] getValidPermissions() {
        if (this.lazyPermissionClone == null) {
            this.lazyPermissionClone = new int[validPermissions.length];
            System.arraycopy(validPermissions, 0, this.lazyPermissionClone, 0, validPermissions.length);
        }
        return this.lazyPermissionClone;
    }

    public static void main(String[] args) {
        PentahoAclEntry e = new PentahoAclEntry();
        System.out.println(Arrays.toString(e.getValidPermissions()));
        System.out.println(Arrays.toString(e.getValidPermissions()));
    }

    public String printPermissionsBlock(int i) {
        StringBuffer sb = new StringBuffer();
        if (this.isPermitted(i, 1)) {
            sb.append('X');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, 2)) {
            sb.append('S');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, 4)) {
            sb.append('C');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, 8)) {
            sb.append('U');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, 16)) {
            sb.append('D');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, 32)) {
            sb.append('P');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static Map getValidPermissionsNameMap() {
        return PentahoAclEntry.getValidPermissionsNameMap("solutions");
    }

    public static Map getValidPermissionsNameMap(String permissionsListType) {
        return (Map)validPermissionsNameMap.get(permissionsListType);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PentahoAclEntry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PentahoAclEntry rhs = (PentahoAclEntry)((Object)obj);
        return new EqualsBuilder().append(this.getRecipient(), rhs.getRecipient()).append(this.getRecipientType(), rhs.getRecipientType()).append((Object)this.getAclObjectIdentity(), (Object)rhs.getAclObjectIdentity()).append((Object)this.getAclObjectParentIdentity(), (Object)rhs.getAclObjectParentIdentity()).append(this.getMask(), rhs.getMask()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(79, 211).append(this.getRecipient()).append(this.getRecipientType()).append((Object)this.getAclObjectIdentity()).append((Object)this.getAclObjectParentIdentity()).append(this.getMask()).toHashCode();
    }

    static {
        validPermissionsNameMap = new HashMap();
        HashMap<String, Integer> solutionPermissionsMap = new HashMap<String, Integer>();
        HashMap<String, Integer> allPermissionsMap = new HashMap<String, Integer>();
        validPermissionsNameMap.put("solutions", Collections.unmodifiableMap(solutionPermissionsMap));
        validPermissionsNameMap.put("all", Collections.unmodifiableMap(allPermissionsMap));
        solutionPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_ADMINISTER"), new Integer(-1));
        solutionPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_MANAGE_PERMS"), new Integer(32));
        solutionPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_UPDATE"), new Integer(8));
        solutionPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_CREATE"), new Integer(4));
        solutionPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_DELETE"), new Integer(16));
        solutionPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_EXECUTE"), new Integer(1));
        solutionPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_SUBSCRIBE"), new Integer(2));
        allPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_NONE"), new Integer(0));
        allPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_EXECUTE"), new Integer(1));
        allPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_SUBSCRIBE"), new Integer(2));
        allPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_CREATE"), new Integer(4));
        allPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_UPDATE"), new Integer(8));
        allPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_DELETE"), new Integer(16));
        allPermissionsMap.put(Messages.getInstance().getString("PentahoAclEntry.USER_ALL"), new Integer(-1));
        PentahoAclEntry.initializePermissionsArray();
    }
}

