/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.audit;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.pentaho.platform.api.engine.AuditException;
import org.pentaho.platform.api.engine.IAuditEntry;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.audit.AuditConnection;
import org.pentaho.platform.util.logging.Logger;

public class AuditSQLEntry
implements IAuditEntry {
    private static AuditConnection audc;
    private static String INSERT_STMT;

    public AuditSQLEntry() {
        this.retrieveParameters();
    }

    private void retrieveParameters() {
        String tmp = PentahoSystem.getSystemSetting("audit_sql.xml", "auditConnection/insertSQL", null);
        INSERT_STMT = tmp != null ? tmp : PentahoSystem.getSystemSetting("auditConnection/insertSQL", Messages.getInstance().getString("AUDSQLENT.CODE_AUDIT_INSERT_STATEMENT"));
    }

    private void setString(PreparedStatement stmt, int num, String val) throws SQLException {
        if (val != null) {
            stmt.setString(num, val);
        } else {
            stmt.setNull(num, 12);
        }
    }

    private void setObject(PreparedStatement stmt, int num, String val) throws SQLException {
        if (val != null) {
            stmt.setObject(num, val);
        } else {
            stmt.setNull(num, 2005);
        }
    }

    private void setBigDec(PreparedStatement stmt, int num, BigDecimal val) throws SQLException {
        if (val != null) {
            stmt.setBigDecimal(num, val);
        } else {
            stmt.setNull(num, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auditAll(String jobId, String instId, String objId, String objType, String actor, String messageType, String messageName, String messageTxtValue, BigDecimal messageNumValue, double duration) throws AuditException {
        Connection con = null;
        try {
            con = audc.getAuditConnection();
            try {
                PreparedStatement stmt = con.prepareStatement(INSERT_STMT);
                try {
                    this.setString(stmt, 1, jobId);
                    this.setString(stmt, 2, instId);
                    this.setString(stmt, 3, objId);
                    this.setString(stmt, 4, objType);
                    this.setString(stmt, 5, actor);
                    this.setString(stmt, 6, messageType);
                    this.setString(stmt, 7, messageName);
                    this.setObject(stmt, 8, messageTxtValue);
                    this.setBigDec(stmt, 9, messageNumValue);
                    this.setBigDec(stmt, 10, new BigDecimal(duration));
                    stmt.setTimestamp(11, new Timestamp(System.currentTimeMillis()));
                    stmt.executeUpdate();
                }
                catch (SQLException ex) {
                    Logger.error(this.getClass().getName(), ex.getMessage(), (Throwable)ex);
                    try {
                        con.rollback();
                    }
                    catch (Exception rollbackExc) {
                        throw new AuditException((Throwable)rollbackExc);
                    }
                    throw new AuditException((Throwable)ex);
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                con.close();
            }
        }
        catch (SQLException ex) {
            throw new AuditException((Throwable)ex);
        }
    }

    static {
        String tmp = PentahoSystem.getSystemSetting("audit_sql.xml", "auditConnection/insertSQL", null);
        INSERT_STMT = tmp != null ? tmp : PentahoSystem.getSystemSetting("auditConnection/insertSQL", Messages.getInstance().getString("AUDSQLENT.CODE_AUDIT_INSERT_STATEMENT"));
        try {
            audc = new AuditConnection();
            audc.initialize();
        }
        catch (Exception ex) {
            Logger.error(AuditHelper.class.getName(), Messages.getInstance().getErrorString("AUDSQLENT.ERROR_0001_INVALID_CONNECTION"), (Throwable)ex);
        }
    }
}

