/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.io.InputStream;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFileMetaProvider;
import org.pentaho.platform.engine.core.solution.FileInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.SequenceDefinition;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class ActionSequenceFileInfo
implements ISolutionFileMetaProvider {
    private ILogger logger;

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public IFileInfo getFileInfo(ISolutionFile solutionFile, InputStream in) {
        try {
            Document actionSequenceDocument = XmlDom4JHelper.getDocFromStream(in);
            if (actionSequenceDocument == null) {
                return null;
            }
            String path = solutionFile.getSolutionPath();
            IActionSequence actionSequence = SequenceDefinition.ActionSequenceFactory(actionSequenceDocument, path, this.logger, PentahoSystem.getApplicationContext(), Logger.getLogLevel());
            if (actionSequence == null) {
                Logger.error(this.getClass().toString(), Messages.getInstance().getErrorString("SolutionRepository.ERROR_0016_FAILED_TO_CREATE_ACTION_SEQUENCE", path));
                return null;
            }
            FileInfo info = new FileInfo();
            info.setAuthor(actionSequence.getAuthor());
            info.setDescription(actionSequence.getDescription());
            info.setDisplayType(actionSequence.getResultType());
            info.setIcon(actionSequence.getIcon());
            info.setTitle(actionSequence.getTitle());
            return info;
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error(this.getClass().toString(), (Throwable)e);
            }
            return null;
        }
    }
}

