/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.io.OutputStream;
import java.security.InvalidParameterException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.solution.BaseContentGenerator;
import org.pentaho.platform.util.UUIDUtil;

public abstract class SimpleContentGenerator
extends BaseContentGenerator {
    private static final long serialVersionUID = -8882315618256741737L;

    @Override
    public void createContent() throws Exception {
        IContentItem contentItem;
        OutputStream out = null;
        if (this.outputHandler == null) {
            this.error(Messages.getInstance().getErrorString("SimpleContentGenerator.ERROR_0001_NO_OUTPUT_HANDLER"));
            throw new InvalidParameterException(Messages.getInstance().getString("SimpleContentGenerator.ERROR_0001_NO_OUTPUT_HANDLER"));
        }
        if (this.instanceId == null) {
            this.setInstanceId(UUIDUtil.getUUIDAsString());
        }
        if ((contentItem = this.outputHandler.getOutputContentItem("response", "content", this.instanceId, this.getMimeType())) == null) {
            this.error(Messages.getInstance().getErrorString("SimpleContentGenerator.ERROR_0002_NO_CONTENT_ITEM"));
            throw new InvalidParameterException(Messages.getInstance().getString("SimpleContentGenerator.ERROR_0002_NO_CONTENT_ITEM"));
        }
        contentItem.setMimeType(this.getMimeType());
        out = contentItem.getOutputStream(this.itemName);
        if (out == null) {
            this.error(Messages.getInstance().getErrorString("SimpleContentGenerator.ERROR_0003_NO_OUTPUT_STREAM"));
            throw new InvalidParameterException(Messages.getInstance().getString("SimpleContentGenerator.ERROR_0003_NO_OUTPUT_STREAM"));
        }
        this.createContent(out);
        try {
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void createContent(OutputStream var1) throws Exception;

    public abstract String getMimeType();
}

