/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultValueDataset;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.uifoundation.chart.AbstractChartComponent;
import org.pentaho.platform.uifoundation.chart.AbstractJFreeChartComponent;
import org.pentaho.platform.uifoundation.chart.DialWidgetDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.messages.Messages;

public class DialChartComponent
extends AbstractJFreeChartComponent {
    private static final long serialVersionUID = -6268840271596447555L;
    public static final String VALUE_NODE_NAME = "dialValue";
    public static final String MAXVALUE_NODE_NAME = "dialMaximum";
    public static final String MINVALUE_NODE_NAME = "dialMinimum";
    public static final int TYPE_DIAL = 1;
    public static final int TYPE_THERMOMETER = 2;
    private Double value = null;

    public DialChartComponent(int chartType, String definitionPath, int width, int height, IPentahoUrlFactory urlFactory, List messages) {
        super(chartType, definitionPath, width, height, urlFactory, messages);
    }

    public DialChartComponent(String definitionPath, IPentahoUrlFactory urlFactory, ArrayList messages) {
        super(definitionPath, urlFactory, messages);
    }

    public DialChartComponent(IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages);
    }

    @Override
    public Dataset createChart(Document doc) {
        Node chartAttributes = doc.selectSingleNode("//chart");
        if (this.actionPath != null) {
            this.values = this.getActionData();
        }
        if (this.values == null) {
            Node valueNode = chartAttributes.selectSingleNode(VALUE_NODE_NAME);
            Node maxValueNode = chartAttributes.selectSingleNode(MAXVALUE_NODE_NAME);
            Node minValueNode = chartAttributes.selectSingleNode(MINVALUE_NODE_NAME);
            double val = 0.0;
            double min = -1.0;
            double max = -1.0;
            if (valueNode != null) {
                try {
                    val = Double.parseDouble(valueNode.getText());
                }
                catch (Exception e) {
                    AbstractChartComponent.logger.error((Object)Messages.getInstance().getErrorString("DIALCHARTCOMPONENT.ERROR_0001_ERROR_PARSING_VALUE", valueNode.getText()), (Throwable)e);
                    val = 0.0;
                }
                if (minValueNode != null && maxValueNode != null) {
                    try {
                        min = Double.parseDouble(minValueNode.getText());
                        max = Double.parseDouble(maxValueNode.getText());
                    }
                    catch (Exception e) {
                        AbstractChartComponent.logger.error((Object)Messages.getInstance().getErrorString("DIALCHARTCOMPONENT.ERROR_0001_ERROR_PARSING_VALUE", minValueNode.getText(), maxValueNode.getText()), (Throwable)e);
                        min = -1.0;
                        max = -1.0;
                    }
                }
                MemoryResultSet set = new MemoryResultSet();
                if (min == -1.0 && max == -1.0) {
                    set.addRow(new Object[]{new Double(val)});
                } else {
                    set.addRow(new Object[]{new Double(val), new Double(min), new Double(max)});
                }
                this.values = set;
            }
        }
        DialWidgetDefinition chartDefinition = new DialWidgetDefinition((IPentahoResultSet)this.values, this.byRow, chartAttributes, this.width, this.height, this.getSession());
        if (this.value != null) {
            chartDefinition.setValue(this.value);
            chartDefinition.deriveMinMax(this.value);
        }
        this.setChartType(0);
        this.setTitle(chartDefinition.getTitle());
        Node urlTemplateNode = chartAttributes.selectSingleNode("url-template");
        if (urlTemplateNode != null) {
            this.setUrlTemplate(urlTemplateNode.getText());
        }
        if (chartDefinition.getWidth() != -1 && this.width == -1) {
            this.setWidth(chartDefinition.getWidth());
        }
        if (chartDefinition.getHeight() != -1 && this.height == -1) {
            this.setHeight(chartDefinition.getHeight());
        }
        return chartDefinition;
    }

    @Override
    public Document getXmlContent() {
        Document result = DocumentHelper.createDocument();
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        this.setXslProperty("baseUrl", requestContext.getContextPath());
        this.setXslProperty("fullyQualifiedServerUrl", PentahoSystem.getApplicationContext().getFullyQualifiedServerURL());
        String mapName = "chart" + AbstractChartComponent.chartCount++;
        Document chartDefinition = this.jcrHelper.getSolutionDocument(this.definitionPath, RepositoryFilePermission.READ);
        if (chartDefinition == null) {
            Element errorElement = result.addElement("error");
            errorElement.addElement("title").setText(Messages.getInstance().getString("ABSTRACTCHARTEXPRESSION.ERROR_0001_ERROR_GENERATING_CHART"));
            String message = Messages.getInstance().getString("CHARTS.ERROR_0001_CHART_DEFINIION_MISSING", this.definitionPath);
            errorElement.addElement("message").setText(message);
            this.error(message);
            return result;
        }
        this.dataDefinition = this.createChart(chartDefinition);
        if (this.dataDefinition == null) {
            Element errorElement = result.addElement("error");
            errorElement.addElement("title").setText(Messages.getInstance().getString("ABSTRACTCHARTEXPRESSION.ERROR_0001_ERROR_GENERATING_CHART"));
            String message = Messages.getInstance().getString("CHARTS.ERROR_0002_CHART_DATA_MISSING", this.actionPath);
            errorElement.addElement("message").setText(message);
            return result;
        }
        PrintWriter printWriter = new PrintWriter(new StringWriter());
        String chartTitle = "";
        try {
            if (this.width == -1) {
                this.width = Integer.parseInt(chartDefinition.selectSingleNode("/chart/width").getText());
            }
            if (this.height == -1) {
                this.height = Integer.parseInt(chartDefinition.selectSingleNode("/chart/height").getText());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (chartDefinition.selectSingleNode("/chart/url-template") != null) {
            this.urlTemplate = chartDefinition.selectSingleNode("/chart/url-template").getText();
        }
        if (chartDefinition.selectSingleNode("/chart/paramName") != null) {
            this.paramName = chartDefinition.selectSingleNode("/chart/paramName").getText();
        }
        Element root = result.addElement("charts");
        DefaultValueDataset chartDataDefinition = (DefaultValueDataset)this.dataDefinition;
        String[] tempFileInfo = this.createTempFile();
        String fileName = tempFileInfo[0];
        String filePathWithoutExtension = tempFileInfo[1];
        ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
        JFreeChartEngine.saveChart((Dataset)chartDataDefinition, chartTitle, "", filePathWithoutExtension, this.width, this.height, 1, printWriter, info, this);
        this.applyOuterURLTemplateParam();
        this.populateInfo(info);
        Element chartElement = root.addElement("chart");
        chartElement.addElement("mapName").setText(mapName);
        chartElement.addElement("width").setText(Integer.toString(this.width));
        chartElement.addElement("height").setText(Integer.toString(this.height));
        String mapString = ImageMapUtilities.getImageMap((String)mapName, (ChartRenderingInfo)info);
        chartElement.addElement("imageMap").setText(mapString);
        chartElement.addElement("image").setText(fileName);
        return result;
    }

    private void populateInfo(ChartRenderingInfo info) {
    }

    @Override
    public boolean validate() {
        return true;
    }

    public void setValue(double value) {
        this.value = new Double(value);
    }
}

