/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JToolBar;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FormulaEditorPanel;
import org.pentaho.openformula.ui.FunctionParameterEditor;
import org.pentaho.openformula.ui.Messages;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class FormulaEditorDialog
extends CommonDialog {
    private FormulaEditorPanel panel;

    public FormulaEditorDialog() {
        this.init();
    }

    public FormulaEditorDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public FormulaEditorDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setDefaultCloseOperation(2);
        this.setTitle(Messages.getInstance().getString("FormulaEditorDialog.Title"));
        this.setModal(true);
        this.setResizable(true);
        this.panel = new FormulaEditorPanel();
        super.init();
    }

    protected String getDialogId() {
        return "LibFormula.FormulaEditor";
    }

    public JToolBar getOperatorPanel() {
        return this.panel.getOperatorPanel();
    }

    protected Component createContentPane() {
        return this.panel;
    }

    public void insertText(String text) {
        this.panel.insertText(text);
    }

    public void setEditor(String function, FunctionParameterEditor editor) {
        this.panel.setEditor(function, editor);
    }

    public FunctionParameterEditor getEditor(String function) {
        return this.panel.getEditor(function);
    }

    @Deprecated
    public String getFormulaText() {
        return this.panel.getFormulaText();
    }

    @Deprecated
    public void setFormulaText(String formulaText) {
        this.panel.setFormulaText(formulaText);
    }

    @Deprecated
    public void setFields(FieldDefinition[] fields) {
        this.panel.setFields(fields);
    }

    public FieldDefinition[] getFields() {
        return this.panel.getFields();
    }

    public String editFormula(String formula, FieldDefinition[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        this.panel.setFields(fields);
        if (StringUtils.isEmpty((String)formula, (boolean)true)) {
            this.panel.setFormulaText("=");
        } else {
            this.panel.setFormulaText(formula);
        }
        if (!super.performEdit()) {
            return null;
        }
        String formulaText = this.panel.getFormulaText();
        if (StringUtils.isEmpty((String)formulaText, (boolean)true) || formulaText.trim().equals("=")) {
            return "";
        }
        return formulaText;
    }

    @Deprecated
    public String editFormulaFragment(String formula, FieldDefinition[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        if (StringUtils.isEmpty((String)formula, (boolean)true)) {
            this.panel.setFormulaText("=");
        } else {
            this.panel.setFormulaText("=" + formula);
        }
        this.panel.setFields(fields);
        this.setVisible(true);
        if (!this.performEdit()) {
            return null;
        }
        String formulaText = this.panel.getFormulaText();
        if (StringUtils.isEmpty((String)formulaText, (boolean)true) || formulaText.trim().equals("=")) {
            return null;
        }
        return FormulaUtil.extractFormula((String)formulaText);
    }
}

