/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.xpath;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.XPathDataFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.ui.datasources.xpath.DataSetQuery;
import org.pentaho.reporting.ui.datasources.xpath.Messages;
import org.pentaho.reporting.ui.datasources.xpath.XPathPreviewWorker;

public class XPathDataSourceEditor
extends CommonDialog {
    private JList queryNameList;
    private JTextField queryNameTextField;
    private JTextField filenameField;
    private JTextArea queryTextArea;
    private Map<String, DataSetQuery> queries;
    private boolean inQueryNameUpdate;
    private boolean inModifyingQueryNameList;
    private Preferences preferences;
    private PreviewAction previewAction;
    private DesignTimeContext designTimeContext;
    private JCheckBox legacyQuery;
    private QueryRemoveActionListener removeQueryAction;

    public XPathDataSourceEditor(DesignTimeContext designTimeContext) {
        this.init(designTimeContext);
    }

    public XPathDataSourceEditor(DesignTimeContext designTimeContext, Dialog owner) {
        super(owner);
        this.init(designTimeContext);
    }

    public XPathDataSourceEditor(DesignTimeContext designTimeContext, Frame owner) {
        super(owner);
        this.init(designTimeContext);
    }

    private void init(DesignTimeContext designTimeContext) {
        if (designTimeContext == null) {
            throw new NullPointerException();
        }
        this.designTimeContext = designTimeContext;
        this.preferences = Preferences.userNodeForPackage(XPathDataSourceEditor.class);
        this.previewAction = new PreviewAction();
        this.setTitle(Messages.getString("XPathDataSourceEditor.Title", new Object[0]));
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.filenameField = new JTextField(null, 0);
        this.filenameField.setColumns(30);
        this.filenameField.getDocument().addDocumentListener(new FilenameDocumentListener());
        this.removeQueryAction = new QueryRemoveActionListener();
        this.queryNameList = new JList();
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.addListSelectionListener(new QueryNameListSelectionListener());
        this.queryNameList.setCellRenderer(new QueryNameListCellRenderer());
        this.queryNameList.addListSelectionListener(this.removeQueryAction);
        this.queryNameTextField = new JTextField(null, 0);
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.getDocument().addDocumentListener(new QueryNameTextFieldDocumentListener());
        this.legacyQuery = new JCheckBox(Messages.getString("XPathDataSourceEditor.LegacyQuery", new Object[0]));
        this.legacyQuery.addChangeListener(new LegacyCheckboxUpdateHandler());
        this.queryTextArea = new JTextArea((String)null);
        this.queryTextArea.setWrapStyleWord(true);
        this.queryTextArea.setLineWrap(true);
        this.queryTextArea.setRows(5);
        this.queryTextArea.getDocument().addDocumentListener(new QueryDocumentListener());
        super.init();
    }

    protected String getDialogId() {
        return "XPathDataSourceEditor";
    }

    private JPanel createQueryNameListPanel() {
        JPanel queryListButtonsPanel = new JPanel(new FlowLayout(2));
        queryListButtonsPanel.add((Component)new BorderlessButton((Action)new QueryAddAction()));
        queryListButtonsPanel.add((Component)new BorderlessButton((Action)this.removeQueryAction));
        JPanel queryListDetailsPanel = new JPanel(new BorderLayout());
        queryListDetailsPanel.add((Component)new JLabel(Messages.getString("XPathDataSourceEditor.QueryDetailsLabel", new Object[0])), "West");
        queryListDetailsPanel.add((Component)queryListButtonsPanel, "East");
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.add("North", queryListDetailsPanel);
        queryListPanel.add("Center", new JScrollPane(this.queryNameList));
        return queryListPanel;
    }

    protected Component createContentPane() {
        JLabel fileLabel = new JLabel(Messages.getString("XPathDataSourceEditor.File", new Object[0]));
        JPanel filePanel = new JPanel(new FlowLayout(0));
        filePanel.add(this.filenameField);
        filePanel.add(new JButton(new BrowseButtonAction()));
        JLabel queryNameStringLabel = new JLabel(Messages.getString("XPathDataSourceEditor.QueryNameStringLabel", new Object[0]));
        queryNameStringLabel.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 0));
        JLabel queryStringLabel = new JLabel(Messages.getString("XPathDataSourceEditor.QueryStringLabel", new Object[0]));
        queryStringLabel.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 0));
        JPanel previewPanel = new JPanel(new FlowLayout(2));
        previewPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        previewPanel.add(new JButton(this.previewAction));
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.setLayout((LayoutManager)new VerticalLayout(5, 3));
        contentPane.add(fileLabel);
        contentPane.add(filePanel);
        contentPane.add(this.createQueryNameListPanel());
        contentPane.add(queryNameStringLabel);
        contentPane.add(this.queryNameTextField);
        contentPane.add(this.legacyQuery);
        contentPane.add(queryStringLabel);
        contentPane.add((Component)new JScrollPane(this.queryTextArea), "Center");
        contentPane.add(previewPanel);
        return contentPane;
    }

    public XPathDataFactory performConfiguration(XPathDataFactory dataFactory, String selectedQuery) {
        this.queries = new TreeMap<String, DataSetQuery>();
        if (dataFactory != null) {
            this.filenameField.setText(dataFactory.getXqueryDataFile());
            String[] queryNames = dataFactory.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String queryName = queryNames[i];
                XPathDataFactory.QueryDefinition query = dataFactory.getQuery(queryName);
                this.queries.put(queryName, new DataSetQuery(queryName, query.getXpathExpression(), query.isLegacyQuery()));
            }
        }
        this.updateComponents();
        this.updateQueryList();
        this.setSelectedQuery(selectedQuery);
        if (!this.performEdit()) {
            return null;
        }
        return this.produceFactory();
    }

    private XPathDataFactory produceFactory() {
        XPathDataFactory returnDataFactory = new XPathDataFactory();
        returnDataFactory.setXqueryDataFile(this.filenameField.getText());
        DataSetQuery[] queries = this.queries.values().toArray(new DataSetQuery[this.queries.size()]);
        for (int i = 0; i < queries.length; ++i) {
            DataSetQuery query = queries[i];
            returnDataFactory.setQuery(query.getQueryName(), query.getQuery(), query.isLegacyQuery());
        }
        return returnDataFactory;
    }

    protected void setSelectedQuery(String aQuery) {
        ListModel theModel = this.queryNameList.getModel();
        for (int i = 0; i < theModel.getSize(); ++i) {
            DataSetQuery theDataSet = (DataSetQuery)theModel.getElementAt(i);
            if (!theDataSet.getQueryName().equals(aQuery)) continue;
            this.queryNameList.setSelectedValue(theDataSet, true);
            break;
        }
    }

    protected void updateQueryList() {
        this.queryNameList.removeAll();
        this.queryNameList.setListData(this.queries.values().toArray(new DataSetQuery[this.queries.size()]));
    }

    protected void updateComponents() {
        boolean querySelected = this.queryNameList.getSelectedIndex() != -1;
        boolean hasQueries = this.queryNameList.getModel().getSize() > 0;
        this.queryNameTextField.setEnabled(querySelected);
        this.queryTextArea.setEnabled(querySelected);
        this.legacyQuery.setEnabled(querySelected);
        this.getConfirmAction().setEnabled(hasQueries && !StringUtils.isEmpty((String)this.filenameField.getText(), (boolean)true));
        this.previewAction.setEnabled(querySelected);
    }

    private class LegacyCheckboxUpdateHandler
    implements ChangeListener {
        private LegacyCheckboxUpdateHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DataSetQuery currentQuery = (DataSetQuery)XPathDataSourceEditor.this.queryNameList.getSelectedValue();
            if (currentQuery == null) {
                return;
            }
            currentQuery.setLegacyQuery(XPathDataSourceEditor.this.legacyQuery.isSelected());
        }
    }

    private class PreviewAction
    extends AbstractAction {
        private PreviewAction() {
            this.putValue("Name", Messages.getString("XPathDataSourceEditor.Preview.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent aEvt) {
            try {
                String query = XPathDataSourceEditor.this.queryNameTextField.getText();
                DataPreviewDialog previewDialog = new DataPreviewDialog((Dialog)((Object)XPathDataSourceEditor.this));
                XPathDataFactory dataFactory = XPathDataSourceEditor.this.produceFactory();
                DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)XPathDataSourceEditor.this.designTimeContext);
                XPathPreviewWorker worker = new XPathPreviewWorker(dataFactory, query);
                previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)XPathDataSourceEditor.this), (String)Messages.getString("XPathDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("XPathDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)factoryException);
                }
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)((Object)XPathDataSourceEditor.this), (String)Messages.getString("XPathDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("XPathDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)e);
            }
        }
    }

    private class FilenameDocumentListener
    implements DocumentListener {
        private FilenameDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            XPathDataSourceEditor.this.updateComponents();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            XPathDataSourceEditor.this.updateComponents();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            XPathDataSourceEditor.this.updateComponents();
        }
    }

    private class QueryNameTextFieldDocumentListener
    implements DocumentListener {
        private QueryNameTextFieldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            DataSetQuery currentQuery;
            if (XPathDataSourceEditor.this.inModifyingQueryNameList) {
                return;
            }
            String queryName = XPathDataSourceEditor.this.queryNameTextField.getText();
            if (queryName.equals((currentQuery = (DataSetQuery)XPathDataSourceEditor.this.queryNameList.getSelectedValue()).getQueryName())) {
                return;
            }
            if (XPathDataSourceEditor.this.queries.containsKey(queryName)) {
                return;
            }
            XPathDataSourceEditor.this.inQueryNameUpdate = true;
            XPathDataSourceEditor.this.queries.remove(currentQuery.getQueryName());
            currentQuery.setQueryName(queryName);
            XPathDataSourceEditor.this.queries.put(currentQuery.getQueryName(), currentQuery);
            XPathDataSourceEditor.this.updateQueryList();
            XPathDataSourceEditor.this.queryNameList.setSelectedValue(currentQuery, true);
            XPathDataSourceEditor.this.inQueryNameUpdate = false;
        }
    }

    private class QueryDocumentListener
    implements DocumentListener {
        private QueryDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            DataSetQuery query = (DataSetQuery)XPathDataSourceEditor.this.queryNameList.getSelectedValue();
            if (query != null) {
                query.setQuery(XPathDataSourceEditor.this.queryTextArea.getText());
            }
        }
    }

    private class QueryRemoveActionListener
    extends AbstractAction
    implements ListSelectionListener {
        private QueryRemoveActionListener() {
            URL resource = XPathDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/xpath/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", "XPathDataSourceEditor.RemoveQuery.Name");
            }
            this.putValue("ShortDescription", "XPathDataSourceEditor.RemoveQuery.Description");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSetQuery query = (DataSetQuery)XPathDataSourceEditor.this.queryNameList.getSelectedValue();
            if (query != null) {
                XPathDataSourceEditor.this.queries.remove(query.getQueryName());
            }
            XPathDataSourceEditor.this.inModifyingQueryNameList = true;
            XPathDataSourceEditor.this.updateQueryList();
            XPathDataSourceEditor.this.queryNameList.clearSelection();
            XPathDataSourceEditor.this.inModifyingQueryNameList = false;
            XPathDataSourceEditor.this.updateComponents();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!XPathDataSourceEditor.this.queryNameList.isSelectionEmpty());
        }
    }

    private class QueryAddAction
    extends AbstractAction {
        private QueryAddAction() {
            URL resource = XPathDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/xpath/resources/Add.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", "XPathDataSourceEditor.AddQuery.Name");
            }
            this.putValue("ShortDescription", "XPathDataSourceEditor.AddQuery.Description");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String queryName = Messages.getString("XPathDataSourceEditor.Query", new Object[0]);
            for (int i = 1; i < 1000; ++i) {
                String newQueryName = Messages.getString("XPathDataSourceEditor.Query", new Object[0]) + " " + i;
                if (XPathDataSourceEditor.this.queries.containsKey(newQueryName)) continue;
                queryName = newQueryName;
                break;
            }
            DataSetQuery newQuery = new DataSetQuery(queryName, "", false);
            XPathDataSourceEditor.this.queries.put(newQuery.getQueryName(), newQuery);
            XPathDataSourceEditor.this.inModifyingQueryNameList = true;
            XPathDataSourceEditor.this.updateQueryList();
            XPathDataSourceEditor.this.queryNameList.setSelectedValue(newQuery, true);
            XPathDataSourceEditor.this.inModifyingQueryNameList = false;
            XPathDataSourceEditor.this.updateComponents();
        }
    }

    private class QueryNameListSelectionListener
    implements ListSelectionListener {
        private QueryNameListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!XPathDataSourceEditor.this.inQueryNameUpdate) {
                DataSetQuery query = (DataSetQuery)XPathDataSourceEditor.this.queryNameList.getSelectedValue();
                if (query != null) {
                    XPathDataSourceEditor.this.queryNameTextField.setText(query.getQueryName());
                    XPathDataSourceEditor.this.queryTextArea.setText(query.getQuery());
                    XPathDataSourceEditor.this.legacyQuery.setSelected(query.isLegacyQuery());
                    XPathDataSourceEditor.this.updateComponents();
                } else {
                    XPathDataSourceEditor.this.queryNameTextField.setText("");
                    XPathDataSourceEditor.this.queryTextArea.setText("");
                    XPathDataSourceEditor.this.legacyQuery.setSelected(false);
                    XPathDataSourceEditor.this.updateComponents();
                }
            }
        }
    }

    private static class QueryNameListCellRenderer
    extends DefaultListCellRenderer {
        private QueryNameListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel listCellRendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                String queryName = ((DataSetQuery)value).getQueryName();
                if (!"".equals(queryName)) {
                    listCellRendererComponent.setText(queryName);
                } else {
                    listCellRendererComponent.setText(" ");
                }
            }
            return listCellRendererComponent;
        }
    }

    private class BrowseButtonAction
    extends AbstractAction {
        private BrowseButtonAction() {
            this.putValue("Name", Messages.getString("XPathDataSourceEditor.Browse.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File reportContextFile = DesignTimeUtil.getContextAsFile((AbstractReportDefinition)XPathDataSourceEditor.this.designTimeContext.getReport());
            String fileName = XPathDataSourceEditor.this.filenameField.getText();
            File initiallySelectedFile = !StringUtils.isEmpty((String)fileName, (boolean)true) ? (reportContextFile == null ? new File(fileName) : new File(reportContextFile.getParentFile(), fileName)) : new File(XPathDataSourceEditor.this.preferences.get("XQueryFile", ""));
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setSelectedFile(initiallySelectedFile);
            int success = fileChooser.showOpenDialog((Component)((Object)XPathDataSourceEditor.this));
            if (success != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String path = reportContextFile != null ? IOUtils.getInstance().createRelativePath(file.getPath(), reportContextFile.getAbsolutePath()) : file.getPath();
            XPathDataSourceEditor.this.filenameField.setText(path);
            XPathDataSourceEditor.this.preferences.put("XQueryFile", fileChooser.getSelectedFile().toString());
        }
    }
}

