/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.ping.broadcast;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class BroadcastPingRequest
extends BroadcastOperationRequest {
    @Nullable
    protected String queryHint;

    BroadcastPingRequest() {
    }

    public BroadcastPingRequest(String ... indices) {
        super(indices);
        this.queryHint = null;
    }

    @Override
    public BroadcastPingRequest operationThreading(BroadcastOperationThreading operationThreading) {
        super.operationThreading(operationThreading);
        return this;
    }

    @Override
    public BroadcastPingRequest listenerThreaded(boolean threadedListener) {
        super.listenerThreaded(threadedListener);
        return this;
    }

    public String queryHint() {
        return this.queryHint;
    }

    public BroadcastPingRequest queryHint(String queryHint) {
        this.queryHint = queryHint;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.queryHint = in.readUTF();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.queryHint == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.queryHint);
        }
    }
}

