/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.concurrent.Future;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardsAllocation;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class RoutingService
extends AbstractLifecycleComponent<RoutingService>
implements ClusterStateListener {
    private static final String CLUSTER_UPDATE_TASK_SOURCE = "routing-table-updater";
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final ShardsAllocation shardsAllocation;
    private final TimeValue schedule;
    private volatile boolean routingTableDirty = false;
    private volatile Future scheduledRoutingTableFuture;

    @Inject
    public RoutingService(Settings settings, ThreadPool threadPool, ClusterService clusterService, ShardsAllocation shardsAllocation) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.shardsAllocation = shardsAllocation;
        this.schedule = this.componentSettings.getAsTime("schedule", TimeValue.timeValueSeconds(10L));
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.clusterService.addPriority(this);
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        if (this.scheduledRoutingTableFuture != null) {
            this.scheduledRoutingTableFuture.cancel(true);
            this.scheduledRoutingTableFuture = null;
        }
        this.clusterService.remove(this);
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.source().equals(CLUSTER_UPDATE_TASK_SOURCE)) {
            return;
        }
        if (event.state().nodes().localNodeMaster()) {
            if (this.scheduledRoutingTableFuture == null) {
                this.routingTableDirty = true;
                this.scheduledRoutingTableFuture = this.threadPool.scheduleWithFixedDelay(new RoutingTableUpdater(), this.schedule);
            }
            if (event.nodesRemoved() || event.routingTableChanged()) {
                this.routingTableDirty = true;
                this.reroute();
            } else if (event.nodesAdded()) {
                this.routingTableDirty = true;
            }
        } else if (this.scheduledRoutingTableFuture != null) {
            this.scheduledRoutingTableFuture.cancel(true);
            this.scheduledRoutingTableFuture = null;
        }
    }

    private void reroute() {
        try {
            if (!this.routingTableDirty) {
                return;
            }
            if (this.lifecycle.stopped()) {
                return;
            }
            this.clusterService.submitStateUpdateTask(CLUSTER_UPDATE_TASK_SOURCE, new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RoutingAllocation.Result routingResult = RoutingService.this.shardsAllocation.reroute(currentState);
                    if (!routingResult.changed()) {
                        return currentState;
                    }
                    return ClusterState.newClusterStateBuilder().state(currentState).routingResult(routingResult).build();
                }
            });
            this.routingTableDirty = false;
        }
        catch (Exception e) {
            this.logger.warn("Failed to reroute routing table", e, new Object[0]);
        }
    }

    private class RoutingTableUpdater
    implements Runnable {
        private RoutingTableUpdater() {
        }

        @Override
        public void run() {
            RoutingService.this.reroute();
        }
    }
}

