/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Set;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.ClusterRebalanceNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.ConcurrentRebalanceNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.NodeAllocation;
import org.elasticsearch.cluster.routing.allocation.RebalanceOnlyWhenActiveNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.ReplicaAfterPrimaryActiveNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.SameShardNodeAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.ThrottlingNodeAllocation;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class NodeAllocations
extends NodeAllocation {
    private final NodeAllocation[] allocations;

    public NodeAllocations(Settings settings) {
        this(settings, (Set<NodeAllocation>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(new SameShardNodeAllocation(settings))).add(new ReplicaAfterPrimaryActiveNodeAllocation(settings))).add(new ThrottlingNodeAllocation(settings))).add(new RebalanceOnlyWhenActiveNodeAllocation(settings))).add(new ClusterRebalanceNodeAllocation(settings))).add(new ConcurrentRebalanceNodeAllocation(settings))).build()));
    }

    @Inject
    public NodeAllocations(Settings settings, Set<NodeAllocation> allocations) {
        super(settings);
        this.allocations = allocations.toArray(new NodeAllocation[allocations.size()]);
    }

    @Override
    public void applyStartedShards(NodeAllocations nodeAllocations, StartedRerouteAllocation allocation) {
        for (NodeAllocation allocation1 : this.allocations) {
            allocation1.applyStartedShards(nodeAllocations, allocation);
        }
    }

    @Override
    public void applyFailedShards(NodeAllocations nodeAllocations, FailedRerouteAllocation allocation) {
        for (NodeAllocation allocation1 : this.allocations) {
            allocation1.applyFailedShards(nodeAllocations, allocation);
        }
    }

    @Override
    public boolean canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        for (NodeAllocation allocation1 : this.allocations) {
            if (allocation1.canRebalance(shardRouting, allocation)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean allocateUnassigned(NodeAllocations nodeAllocations, RoutingAllocation allocation) {
        boolean changed = false;
        for (NodeAllocation allocation1 : this.allocations) {
            changed |= allocation1.allocateUnassigned(nodeAllocations, allocation);
        }
        return changed;
    }

    @Override
    public NodeAllocation.Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        NodeAllocation.Decision ret = NodeAllocation.Decision.YES;
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return NodeAllocation.Decision.NO;
        }
        for (NodeAllocation allocation1 : this.allocations) {
            NodeAllocation.Decision decision = allocation1.canAllocate(shardRouting, node, allocation);
            if (decision == NodeAllocation.Decision.NO) {
                return NodeAllocation.Decision.NO;
            }
            if (decision != NodeAllocation.Decision.THROTTLE) continue;
            ret = NodeAllocation.Decision.THROTTLE;
        }
        return ret;
    }
}

