/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.MatchAllDocsFilter;

public class Queries {
    public static final Query MATCH_ALL_QUERY;
    public static final Filter MATCH_ALL_FILTER;
    private static final Field disjuncts;

    public static List<Query> disMaxClauses(DisjunctionMaxQuery query) {
        try {
            return (List)disjuncts.get(query);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Query optimizeQuery(Query q) {
        return q;
    }

    public static boolean isNegativeQuery(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        List clauses = ((BooleanQuery)q).clauses();
        if (clauses.isEmpty()) {
            return false;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return false;
        }
        return true;
    }

    public static Query fixNegativeQueryIfNeeded(Query q) {
        if (Queries.isNegativeQuery(q)) {
            BooleanQuery newBq = (BooleanQuery)q.clone();
            newBq.add(MATCH_ALL_QUERY, BooleanClause.Occur.MUST);
            return newBq;
        }
        return q;
    }

    public static boolean isMatchAllQuery(Query query) {
        DeletionAwareConstantScoreQuery scoreQuery;
        if (query instanceof MatchAllDocsQuery) {
            return true;
        }
        return query instanceof DeletionAwareConstantScoreQuery && (scoreQuery = (DeletionAwareConstantScoreQuery)query).getFilter() instanceof MatchAllDocsFilter;
    }

    static {
        Field disjunctsX;
        MATCH_ALL_QUERY = new DeletionAwareConstantScoreQuery(new MatchAllDocsFilter());
        MATCH_ALL_FILTER = new MatchAllDocsFilter();
        try {
            disjunctsX = DisjunctionMaxQuery.class.getDeclaredField("disjuncts");
            disjunctsX.setAccessible(true);
        }
        catch (Exception e) {
            disjunctsX = null;
        }
        disjuncts = disjunctsX;
    }
}

