/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.transport.TransportAddress;

public class InetSocketTransportAddress
implements TransportAddress {
    private InetSocketAddress address;

    InetSocketTransportAddress() {
    }

    public InetSocketTransportAddress(String hostname, int port) {
        this(new InetSocketAddress(hostname, port));
    }

    public InetSocketTransportAddress(InetAddress address, int port) {
        this(new InetSocketAddress(address, port));
    }

    public InetSocketTransportAddress(InetSocketAddress address) {
        this.address = address;
    }

    public static InetSocketTransportAddress readInetSocketTransportAddress(StreamInput in) throws IOException {
        InetSocketTransportAddress address = new InetSocketTransportAddress();
        address.readFrom(in);
        return address;
    }

    @Override
    public short uniqueAddressTypeId() {
        return 1;
    }

    public InetSocketAddress address() {
        return this.address;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readByte() == 0) {
            InetAddress inetAddress;
            byte len = in.readByte();
            byte[] a = new byte[len];
            in.readFully(a);
            if (len == 16) {
                int scope_id = in.readInt();
                inetAddress = Inet6Address.getByAddress(null, a, scope_id);
            } else {
                inetAddress = InetAddress.getByAddress(a);
            }
            int port = in.readInt();
            this.address = new InetSocketAddress(inetAddress, port);
        } else {
            this.address = new InetSocketAddress(in.readUTF(), in.readInt());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.address.getAddress() != null) {
            out.writeByte((byte)0);
            byte[] bytes = this.address().getAddress().getAddress();
            out.writeByte((byte)bytes.length);
            out.write(bytes, 0, bytes.length);
            if (this.address().getAddress() instanceof Inet6Address) {
                out.writeInt(((Inet6Address)this.address.getAddress()).getScopeId());
            }
        } else {
            out.writeByte((byte)1);
            out.writeUTF(this.address.getHostName());
        }
        out.writeInt(this.address.getPort());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InetSocketTransportAddress address1 = (InetSocketTransportAddress)o;
        return this.address.equals(address1.address);
    }

    public int hashCode() {
        return this.address != null ? this.address.hashCode() : 0;
    }

    public String toString() {
        return "inet[" + this.address + "]";
    }
}

