/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.compound;

import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractCompoundWordTokenFilterFactory
extends AbstractTokenFilterFactory {
    protected final int minWordSize;
    protected final int minSubwordSize;
    protected final int maxSubwordSize;
    protected final boolean onlyLongestMatch;
    protected final Set<String> wordList;

    @Inject
    public AbstractCompoundWordTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.minWordSize = settings.getAsInt("min_word_size", 5);
        this.minSubwordSize = settings.getAsInt("min_subword_size", 2);
        this.maxSubwordSize = settings.getAsInt("max_subword_size", 15);
        this.onlyLongestMatch = settings.getAsBoolean("only_longest_max", false);
        this.wordList = Analysis.getWordSet(env, settings, "word_list");
        if (this.wordList == null) {
            throw new ElasticSearchIllegalArgumentException("word_list must be provided for [" + name + "], either as a path to a file, or directly");
        }
    }
}

