/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.floats;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class FloatFieldDataMissingComparator
extends NumericFieldDataComparator {
    private final float[] values;
    private float bottom;
    private final float missingValue;

    public FloatFieldDataMissingComparator(int numHits, String fieldName, FieldDataCache fieldDataCache, float missingValue) {
        super(fieldName, fieldDataCache);
        this.values = new float[numHits];
        this.missingValue = missingValue;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.FLOAT;
    }

    public int compare(int slot1, int slot2) {
        float v1 = this.values[slot1];
        float v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    public int compareBottom(int doc) {
        float v2 = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            v2 = this.currentFieldData.floatValue(doc);
        }
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    public void copy(int slot, int doc) {
        float value = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            value = this.currentFieldData.floatValue(doc);
        }
        this.values[slot] = value;
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Float.valueOf(this.values[slot]);
    }
}

