/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

public final class Uid {
    public static final char DELIMITER = '#';
    private final String type;
    private final String id;

    public Uid(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Uid uid = (Uid)o;
        if (this.id != null ? !this.id.equals(uid.id) : uid.id != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(uid.type) : uid.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.type + '#' + this.id;
    }

    public static String typePrefix(String type) {
        return type + '#';
    }

    public static String idFromUid(String uid) {
        int delimiterIndex = uid.indexOf(35);
        return uid.substring(delimiterIndex + 1);
    }

    public static Uid createUid(String uid) {
        int delimiterIndex = uid.indexOf(35);
        return new Uid(uid.substring(0, delimiterIndex), uid.substring(delimiterIndex + 1));
    }

    public static String createUid(String type, String id) {
        return Uid.createUid(new StringBuilder(), type, id);
    }

    public static String createUid(StringBuilder sb, String type, String id) {
        return sb.append(type).append('#').append(id).toString();
    }
}

