/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericIntegerAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.NumberFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapperBuilders;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class ByteFieldMapper
extends NumberFieldMapper<Byte> {
    public static final String CONTENT_TYPE = "byte";
    private Byte nullValue;
    private String nullValueAsString;

    protected ByteFieldMapper(FieldMapper.Names names, int precisionStep, String fuzzyFactor, Field.Index index, Field.Store store, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, Byte nullValue) {
        super(names, precisionStep, fuzzyFactor, index, store, boost, omitNorms, omitTermFreqAndPositions, new NamedAnalyzer("_byte/" + precisionStep, new NumericIntegerAnalyzer(precisionStep)), new NamedAnalyzer("_byte/max", new NumericIntegerAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Byte value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return null;
        }
        return value[0];
    }

    @Override
    public Byte valueFromString(String value) {
        return Byte.valueOf(value);
    }

    @Override
    public String indexedValue(String value) {
        return NumericUtils.intToPrefixCoded((int)Byte.parseByte(value));
    }

    @Override
    public Query fuzzyQuery(String value, String minSim, int prefixLength, int maxExpansions) {
        byte iSim;
        byte iValue = Byte.parseByte(value);
        try {
            iSim = Byte.parseByte(minSim);
        }
        catch (NumberFormatException e) {
            iSim = (byte)Float.parseFloat(minSim);
        }
        return NumericRangeQuery.newIntRange((String)this.names.indexName(), (int)this.precisionStep, (Integer)(iValue - iSim), (Integer)(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query fuzzyQuery(String value, double minSim, int prefixLength, int maxExpansions) {
        byte iValue = Byte.parseByte(value);
        byte iSim = (byte)(minSim * this.dFuzzyFactor);
        return NumericRangeQuery.newIntRange((String)this.names.indexName(), (int)this.precisionStep, (Integer)(iValue - iSim), (Integer)(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeQuery.newIntRange((String)this.names.indexName(), (int)this.precisionStep, (Integer)(lowerTerm == null ? null : Integer.valueOf(Integer.parseInt(lowerTerm))), (Integer)(upperTerm == null ? null : Integer.valueOf(Integer.parseInt(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFilter.newIntRange((String)this.names.indexName(), (int)this.precisionStep, (Integer)(lowerTerm == null ? null : Integer.valueOf(Integer.parseInt(lowerTerm))), (Integer)(upperTerm == null ? null : Integer.valueOf(Integer.parseInt(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFieldDataFilter.newByteRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Byte.valueOf(Byte.parseByte(lowerTerm)), upperTerm == null ? null : Byte.valueOf(Byte.parseByte(upperTerm)), includeLower, includeUpper);
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        byte value;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.nullValue == null) {
                    return null;
                }
                value = this.nullValue;
            } else {
                value = ((Number)externalValue).byteValue();
            }
            if (context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), Byte.toString(value), this.boost);
            }
        } else if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return null;
            }
            value = this.nullValue;
            if (this.nullValueAsString != null && context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), this.nullValueAsString, this.boost);
            }
        } else {
            value = (byte)context.parser().shortValue();
            if (context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), context.parser().text(), this.boost);
            }
        }
        return new CustomByteNumericField((NumberFieldMapper)this, value);
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.BYTE;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((ByteFieldMapper)mergeWith).nullValue;
            this.nullValueAsString = ((ByteFieldMapper)mergeWith).nullValueAsString;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (!this.omitTermFreqAndPositions) {
            builder.field("omit_term_freq_and_positions", this.omitTermFreqAndPositions);
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.fuzzyFactor != Defaults.FUZZY_FACTOR) {
            builder.field("fuzzy_factor", this.fuzzyFactor);
        }
        if (this.nullValue != null) {
            builder.field("null_value", (Object)this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    public static class CustomByteNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final byte number;
        private final NumberFieldMapper mapper;

        public CustomByteNumericField(NumberFieldMapper mapper, byte number) {
            byte[] byArray;
            if (mapper.stored()) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = number;
            } else {
                byArray = null;
            }
            super(mapper, byArray);
            this.mapper = mapper;
            this.number = number;
        }

        public TokenStream tokenStreamValue() {
            if (this.isIndexed) {
                return this.mapper.popCachedStream().setIntValue((int)this.number);
            }
            return null;
        }
    }

    public static class TypeParser
    implements XContentMapper.TypeParser {
        @Override
        public XContentMapper.Builder parse(String name, Map<String, Object> node, XContentMapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = XContentMapperBuilders.byteField(name);
            XContentTypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeByteValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, ByteFieldMapper> {
        protected Byte nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder nullValue(byte nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public ByteFieldMapper build(XContentMapper.BuilderContext context) {
            ByteFieldMapper fieldMapper = new ByteFieldMapper(this.buildNames(context), this.precisionStep, this.fuzzyFactor, this.index, this.store, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final Byte NULL_VALUE = null;
    }
}

