/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.type.child;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.index.query.type.child.ChildCollector;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.internal.SearchContext;

public class HasChildFilter
extends Filter
implements ScopePhase.CollectorPhase {
    private Query query;
    private String scope;
    private String parentType;
    private String childType;
    private final SearchContext searchContext;
    private Map<Object, OpenBitSet> parentDocs;

    public HasChildFilter(Query query, String scope, String childType, String parentType, SearchContext searchContext) {
        this.query = query;
        this.scope = scope;
        this.parentType = parentType;
        this.childType = childType;
        this.searchContext = searchContext;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public boolean requiresProcessing() {
        return this.parentDocs == null;
    }

    @Override
    public Collector collector() {
        return new ChildCollector(this.parentType, this.searchContext);
    }

    @Override
    public void processCollector(Collector collector) {
        this.parentDocs = ((ChildCollector)collector).parentDocs();
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public void clear() {
        this.parentDocs = null;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        return (DocIdSet)this.parentDocs.get(reader.getCoreCacheKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("child_filter[").append(this.childType).append("/").append(this.parentType).append("](").append(this.query).append(')');
        return sb.toString();
    }
}

