/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldDataType;

public class GeoPolygonFilter
extends Filter {
    private final Point[] points;
    private final String fieldName;
    private final FieldDataCache fieldDataCache;

    public GeoPolygonFilter(Point[] points, String fieldName, FieldDataCache fieldDataCache) {
        this.points = points;
        this.fieldName = fieldName;
        this.fieldDataCache = fieldDataCache;
    }

    public Point[] points() {
        return this.points;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final GeoPointFieldData fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.fieldName);
        return new GetDocSet(reader.maxDoc()){

            public boolean isCacheable() {
                return false;
            }

            @Override
            public boolean get(int doc) throws IOException {
                if (!fieldData.hasValue(doc)) {
                    return false;
                }
                if (fieldData.multiValued()) {
                    double[] lats = fieldData.latValues(doc);
                    double[] lons = fieldData.lonValues(doc);
                    for (int i = 0; i < lats.length; ++i) {
                        if (!GeoPolygonFilter.pointInPolygon(GeoPolygonFilter.this.points, lats[i], lons[i])) continue;
                        return true;
                    }
                } else {
                    double lat = fieldData.latValue(doc);
                    double lon = fieldData.lonValue(doc);
                    return GeoPolygonFilter.pointInPolygon(GeoPolygonFilter.this.points, lat, lon);
                }
                return false;
            }
        };
    }

    private static boolean pointInPolygon(Point[] points, double lat, double lon) {
        int j = points.length - 1;
        boolean inPoly = false;
        int i = 0;
        while (i < points.length) {
            if ((points[i].lon < lon && points[j].lon >= lon || points[j].lon < lon && points[i].lon >= lon) && points[i].lat + (lon - points[i].lon) / (points[j].lon - points[i].lon) * (points[j].lat - points[i].lat) < lat) {
                inPoly = !inPoly;
            }
            j = i++;
        }
        return inPoly;
    }

    public static class Point {
        public double lat;
        public double lon;

        public Point() {
        }

        public Point(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }
    }
}

