/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.RafReference;

public class FsStreamSnapshot
implements Translog.Snapshot {
    private final ShardId shardId;
    private final long id;
    private final int totalOperations;
    private final int snapshotOperations;
    private final RafReference raf;
    private final long length;
    private final DataInputStream dis;
    private Translog.Operation lastOperationRead = null;
    private int position = 0;
    private byte[] cachedData;

    public FsStreamSnapshot(ShardId shardId, long id, RafReference raf, long length, int totalOperations, int snapshotOperations) throws FileNotFoundException {
        this.shardId = shardId;
        this.id = id;
        this.raf = raf;
        this.length = length;
        this.totalOperations = totalOperations;
        this.snapshotOperations = snapshotOperations;
        this.dis = new DataInputStream(new FileInputStream(raf.file()));
    }

    @Override
    public long translogId() {
        return this.id;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    public int snapshotOperations() {
        return this.snapshotOperations;
    }

    @Override
    public InputStream stream() throws IOException {
        return this.dis;
    }

    @Override
    public long lengthInBytes() {
        return this.length - (long)this.position;
    }

    @Override
    public boolean hasNext() {
        try {
            if ((long)this.position > this.length) {
                return false;
            }
            int opSize = this.dis.readInt();
            this.position += 4;
            if ((long)(this.position + opSize) > this.length) {
                this.position -= 4;
                return false;
            }
            this.position += opSize;
            if (this.cachedData == null) {
                this.cachedData = new byte[opSize];
            } else if (this.cachedData.length < opSize) {
                this.cachedData = new byte[opSize];
            }
            this.dis.readFully(this.cachedData, 0, opSize);
            this.lastOperationRead = TranslogStreams.readTranslogOperation(new BytesStreamInput(this.cachedData, 0, opSize));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Translog.Operation next() {
        return this.lastOperationRead;
    }

    @Override
    public void seekForward(long length) {
        this.position = (int)((long)this.position + length);
        try {
            this.dis.skip(length);
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to seek forward", (Throwable)e);
        }
    }

    @Override
    public boolean release() throws ElasticSearchException {
        try {
            this.dis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.raf.decreaseRefCount(true);
        return true;
    }
}

