/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsChannelSnapshot;
import org.elasticsearch.index.translog.fs.FsStreamSnapshot;
import org.elasticsearch.index.translog.fs.RafReference;

public class FsTranslog
extends AbstractIndexShardComponent
implements Translog {
    private final File location;
    private final boolean useStream;
    private final Object mutex = new Object();
    private boolean syncOnEachOperation = false;
    private volatile long id = 0L;
    private final AtomicInteger operationCounter = new AtomicInteger();
    private AtomicLong lastPosition = new AtomicLong(0L);
    private AtomicLong lastWrittenPosition = new AtomicLong(0L);
    private RafReference raf;

    @Inject
    public FsTranslog(ShardId shardId, @IndexSettings Settings indexSettings, NodeEnvironment nodeEnv) {
        super(shardId, indexSettings);
        this.location = new File(nodeEnv.shardLocation(shardId), "translog");
        this.location.mkdirs();
        this.useStream = this.componentSettings.getAsBoolean("use_stream", false);
    }

    public FsTranslog(ShardId shardId, @IndexSettings Settings indexSettings, File location) {
        this(shardId, indexSettings, location, false);
    }

    public FsTranslog(ShardId shardId, @IndexSettings Settings indexSettings, File location, boolean useStream) {
        super(shardId, indexSettings);
        this.location = location;
        this.location.mkdirs();
        this.useStream = useStream;
    }

    public File location() {
        return this.location;
    }

    @Override
    public long currentId() {
        return this.id;
    }

    @Override
    public int numberOfOperations() {
        return this.operationCounter.get();
    }

    @Override
    public long memorySizeInBytes() {
        return 0L;
    }

    @Override
    public long translogSizeInBytes() {
        return this.lastWrittenPosition.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearUnreferenced() {
        Object object = this.mutex;
        synchronized (object) {
            File[] files = this.location.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.getName().equals("translog-" + this.id)) continue;
                    try {
                        file.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newTranslog() throws TranslogException {
        Object object = this.mutex;
        synchronized (object) {
            this.operationCounter.set(0);
            this.lastPosition.set(0L);
            this.lastWrittenPosition.set(0L);
            ++this.id;
            if (this.raf != null) {
                this.raf.decreaseRefCount(true);
            }
            try {
                this.raf = new RafReference(new File(this.location, "translog-" + this.id));
                this.raf.raf().setLength(0L);
            }
            catch (IOException e) {
                this.raf = null;
                throw new TranslogException(this.shardId, "translog not found", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newTranslog(long id) throws TranslogException {
        Object object = this.mutex;
        synchronized (object) {
            this.operationCounter.set(0);
            this.lastPosition.set(0L);
            this.lastWrittenPosition.set(0L);
            this.id = id;
            if (this.raf != null) {
                this.raf.decreaseRefCount(true);
            }
            try {
                this.raf = new RafReference(new File(this.location, "translog-" + id));
                this.raf.raf().setLength(0L);
            }
            catch (IOException e) {
                this.raf = null;
                throw new TranslogException(this.shardId, "translog not found", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Translog.Operation operation) throws TranslogException {
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        try {
            BytesStreamOutput out = cachedEntry.cachedBytes();
            out.writeInt(0);
            TranslogStreams.writeTranslogOperation(out, operation);
            out.flush();
            int size = out.size();
            out.seek(0);
            out.writeInt(size - 4);
            long position = this.lastPosition.getAndAdd(size);
            this.raf.channel().write(ByteBuffer.wrap(out.unsafeByteArray(), 0, size), position);
            if (this.syncOnEachOperation) {
                this.raf.channel().force(false);
            }
            Object object = this.mutex;
            synchronized (object) {
                this.lastWrittenPosition.getAndAdd(size);
                this.operationCounter.incrementAndGet();
            }
        }
        catch (Exception e) {
            throw new TranslogException(this.shardId, "Failed to write operation [" + operation + "]", (Throwable)e);
        }
        finally {
            CachedStreamOutput.pushEntry(cachedEntry);
        }
    }

    @Override
    public Translog.Snapshot snapshot() throws TranslogException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.raf.increaseRefCount();
                this.raf.channel().force(true);
                if (this.useStream) {
                    return new FsStreamSnapshot(this.shardId, this.id, this.raf, this.lastWrittenPosition.get(), this.operationCounter.get(), this.operationCounter.get());
                }
                return new FsChannelSnapshot(this.shardId, this.id, this.raf, this.lastWrittenPosition.get(), this.operationCounter.get(), this.operationCounter.get());
            }
            catch (Exception e) {
                throw new TranslogException(this.shardId, "Failed to snapshot", (Throwable)e);
            }
        }
    }

    @Override
    public Translog.Snapshot snapshot(Translog.Snapshot snapshot) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentId() != snapshot.translogId()) {
                return this.snapshot();
            }
            try {
                this.raf.increaseRefCount();
                this.raf.channel().force(true);
                if (this.useStream) {
                    FsStreamSnapshot newSnapshot = new FsStreamSnapshot(this.shardId, this.id, this.raf, this.lastWrittenPosition.get(), this.operationCounter.get(), this.operationCounter.get() - snapshot.totalOperations());
                    newSnapshot.seekForward(snapshot.position());
                    return newSnapshot;
                }
                FsChannelSnapshot newSnapshot = new FsChannelSnapshot(this.shardId, this.id, this.raf, this.lastWrittenPosition.get(), this.operationCounter.get(), this.operationCounter.get() - snapshot.totalOperations());
                newSnapshot.seekForward(snapshot.position());
                return newSnapshot;
            }
            catch (Exception e) {
                throw new TranslogException(this.shardId, "Failed to snapshot", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.raf != null) {
                try {
                    this.raf.channel().force(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncOnEachOperation(boolean syncOnEachOperation) {
        Object object = this.mutex;
        synchronized (object) {
            this.syncOnEachOperation = syncOnEachOperation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean delete) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.raf != null) {
                this.raf.decreaseRefCount(delete);
                this.raf = null;
            }
        }
    }
}

