/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.ping.single;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.ping.single.SinglePingRequest;
import org.elasticsearch.action.admin.cluster.ping.single.SinglePingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestSinglePingAction
extends BaseRestHandler {
    @Inject
    public RestSinglePingAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_ping", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/{index}/{type}/{id}/_ping", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        SinglePingRequest singlePingRequest = new SinglePingRequest(request.param("index"), request.param("type"), request.param("id"));
        singlePingRequest.listenerThreaded(false);
        singlePingRequest.operationThreaded(true);
        this.client.admin().cluster().ping(singlePingRequest, new ActionListener<SinglePingResponse>(){

            @Override
            public void onResponse(SinglePingResponse result) {
                try {
                    XContentBuilder generator = RestXContentBuilder.restContentBuilder(request);
                    generator.startObject().field("ok", true).endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, generator));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestSinglePingAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

