/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.QueryBuilders;
import org.elasticsearch.index.query.xcontent.QueryStringQueryBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class RestSearchAction
extends BaseRestHandler {
    private static final Pattern fieldsPattern = Pattern.compile(",");
    private static final Pattern indicesBoostPattern = Pattern.compile(",");

    @Inject
    public RestSearchAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_search", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        SearchRequest searchRequest;
        try {
            searchRequest = this.parseSearchRequest(request);
            searchRequest.listenerThreaded(false);
            SearchOperationThreading operationThreading = SearchOperationThreading.fromString(request.param("operation_threading"), SearchOperationThreading.SINGLE_THREAD);
            if (operationThreading == SearchOperationThreading.NO_THREADS) {
                operationThreading = SearchOperationThreading.SINGLE_THREAD;
            }
            searchRequest.operationThreading(operationThreading);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("failed to parse search request parameters", e, new Object[0]);
            }
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.search(searchRequest, new ActionListener<SearchResponse>(){

            @Override
            public void onResponse(SearchResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    response.toXContent(builder, request);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    if (RestSearchAction.this.logger.isDebugEnabled()) {
                        RestSearchAction.this.logger.debug("failed to execute search (building response)", e, new Object[0]);
                    }
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestSearchAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    private SearchRequest parseSearchRequest(RestRequest request) {
        String[] indices = RestActions.splitIndices(request.param("index"));
        SearchRequest searchRequest = new SearchRequest(indices);
        if (request.hasContent()) {
            searchRequest.source(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength(), request.contentUnsafe());
        } else {
            String source = request.param("source");
            if (source != null) {
                searchRequest.source(source);
            }
        }
        searchRequest.extraSource(this.parseSearchSource(request));
        searchRequest.searchType(request.param("search_type"));
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchRequest.scroll(new Scroll(TimeValue.parseTimeValue(scroll, null)));
        }
        searchRequest.timeout(request.paramAsTime("timeout", null));
        searchRequest.types(RestActions.splitTypes(request.param("type")));
        searchRequest.queryHint(request.param("query_hint"));
        searchRequest.routing(request.param("routing"));
        searchRequest.preference(request.param("preference"));
        return searchRequest;
    }

    private SearchSourceBuilder parseSearchSource(RestRequest request) {
        String sIndicesBoost;
        String sSorts;
        int size;
        int from;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        String queryString = request.param("q");
        if (queryString != null) {
            QueryStringQueryBuilder queryBuilder = QueryBuilders.queryString(queryString);
            queryBuilder.defaultField(request.param("df"));
            queryBuilder.analyzer(request.param("analyzer"));
            String defaultOperator = request.param("default_operator");
            if (defaultOperator != null) {
                if ("OR".equals(defaultOperator)) {
                    queryBuilder.defaultOperator(QueryStringQueryBuilder.Operator.OR);
                } else if ("AND".equals(defaultOperator)) {
                    queryBuilder.defaultOperator(QueryStringQueryBuilder.Operator.AND);
                } else {
                    throw new ElasticSearchIllegalArgumentException("Unsupported defaultOperator [" + defaultOperator + "], can either be [OR] or [AND]");
                }
            }
            searchSourceBuilder.query(queryBuilder);
        }
        if ((from = request.paramAsInt("from", -1)) != -1) {
            searchSourceBuilder.from(from);
        }
        if ((size = request.paramAsInt("size", -1)) != -1) {
            searchSourceBuilder.size(size);
        }
        searchSourceBuilder.queryParserName(request.param("query_parser_name"));
        searchSourceBuilder.explain(request.paramAsBoolean("explain", null));
        searchSourceBuilder.version(request.paramAsBoolean("version", null));
        String sField = request.param("fields");
        if (sField != null) {
            if (!Strings.hasText(sField)) {
                searchSourceBuilder.noFields();
            } else {
                String[] sFields = fieldsPattern.split(sField);
                if (sFields != null) {
                    for (String field : sFields) {
                        searchSourceBuilder.field(field);
                    }
                }
            }
        }
        if ((sSorts = request.param("sort")) != null) {
            String[] sorts;
            for (String sort : sorts = fieldsPattern.split(sSorts)) {
                int delimiter = sort.lastIndexOf(":");
                if (delimiter != -1) {
                    String sortField = sort.substring(0, delimiter);
                    String reverse = sort.substring(delimiter + 1);
                    if ("asc".equals(reverse)) {
                        searchSourceBuilder.sort(sortField, SortOrder.ASC);
                        continue;
                    }
                    if (!"desc".equals(reverse)) continue;
                    searchSourceBuilder.sort(sortField, SortOrder.DESC);
                    continue;
                }
                searchSourceBuilder.sort(sort);
            }
        }
        if ((sIndicesBoost = request.param("indices_boost")) != null) {
            String[] indicesBoost;
            for (String indexBoost : indicesBoost = indicesBoostPattern.split(sIndicesBoost)) {
                int divisor = indexBoost.indexOf(44);
                if (divisor == -1) {
                    throw new ElasticSearchIllegalArgumentException("Illegal index boost [" + indexBoost + "], no ','");
                }
                String indexName = indexBoost.substring(0, divisor);
                String sBoost = indexBoost.substring(divisor + 1);
                try {
                    searchSourceBuilder.indexBoost(indexName, Float.parseFloat(sBoost));
                }
                catch (NumberFormatException e) {
                    throw new ElasticSearchIllegalArgumentException("Illegal index boost [" + indexBoost + "], boost not a float number");
                }
            }
        }
        return searchSourceBuilder;
    }
}

