/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.time.Chronology;
import org.elasticsearch.common.joda.time.DateTimeField;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.datehistogram.CountDateHistogramFacetCollector;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalDateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.ValueDateHistogramFacetCollector;
import org.elasticsearch.search.facet.datehistogram.ValueScriptDateHistogramFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class DateHistogramFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    private final ImmutableMap<String, DateFieldParser> dateFieldParsers;
    private final TObjectIntHashMap<String> rounding = new TObjectIntHashMap(10, 0.5f, -1);

    @Inject
    public DateHistogramFacetProcessor(Settings settings) {
        super(settings);
        InternalDateHistogramFacet.registerStreams();
        this.dateFieldParsers = MapBuilder.newMapBuilder().put("year", new DateFieldParser.YearOfCentury()).put("1y", new DateFieldParser.YearOfCentury()).put("month", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.MonthOfYear())).put("1m", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.MonthOfYear())).put("week", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.WeekOfWeekyear())).put("1w", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.WeekOfWeekyear())).put("day", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.DayOfMonth())).put("1d", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.DayOfMonth())).put("hour", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.HourOfDay())).put("1h", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.HourOfDay())).put("minute", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.MinuteOfHour())).put("1m", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.MinuteOfHour())).put("second", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.SecondOfMinute())).put("1s", (DateFieldParser.YearOfCentury)((Object)new DateFieldParser.SecondOfMinute())).immutableMap();
        this.rounding.put("floor", 1);
        this.rounding.put("ceiling", 2);
        this.rounding.put("half_even", 5);
        this.rounding.put("halfEven", 5);
        this.rounding.put("half_floor", 3);
        this.rounding.put("halfFloor", 3);
        this.rounding.put("half_ceiling", 4);
        this.rounding.put("halfCeiling", 4);
    }

    @Override
    public String[] types() {
        return new String[]{"date_histogram", "dateHistogram"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        int index;
        XContentParser.Token token;
        String keyField = null;
        String valueField = null;
        String valueScript = null;
        String scriptLang = null;
        Map<String, Object> params = null;
        boolean intervalSet = false;
        long interval = 1L;
        String sInterval = null;
        MutableDateTime dateTime = new MutableDateTime(DateTimeZone.UTC);
        DateHistogramFacet.ComparatorType comparatorType = DateHistogramFacet.ComparatorType.TIME;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(fieldName)) continue;
                params = parser.map();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("key_field".equals(fieldName) || "keyField".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("value_field".equals(fieldName) || "valueField".equals(fieldName)) {
                valueField = parser.text();
                continue;
            }
            if ("interval".equals(fieldName)) {
                intervalSet = true;
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    interval = parser.longValue();
                    continue;
                }
                sInterval = parser.text();
                continue;
            }
            if ("time_zone".equals(fieldName) || "timeZone".equals(fieldName)) {
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    dateTime.setZone(DateTimeZone.forOffsetHours(parser.intValue()));
                    continue;
                }
                String text = parser.text();
                index = text.indexOf(58);
                if (index != -1) {
                    dateTime.setZone(DateTimeZone.forOffsetHoursMinutes(Integer.parseInt(text.substring(0, index)), Integer.parseInt(text.substring(index + 1))));
                    continue;
                }
                dateTime.setZone(DateTimeZone.forID(text));
                continue;
            }
            if ("value_script".equals(fieldName) || "valueScript".equals(fieldName)) {
                valueScript = parser.text();
                continue;
            }
            if ("order".equals(fieldName) || "comparator".equals(fieldName)) {
                comparatorType = DateHistogramFacet.ComparatorType.fromString(parser.text());
                continue;
            }
            if (!"lang".equals(fieldName)) continue;
            scriptLang = parser.text();
        }
        if (keyField == null) {
            throw new FacetPhaseExecutionException(facetName, "key field is required to be set for histogram facet, either using [field] or using [key_field]");
        }
        FieldMapper mapper = context.mapperService().smartNameFieldMapper(keyField);
        if (mapper.fieldDataType() != FieldDataType.DefaultTypes.LONG) {
            throw new FacetPhaseExecutionException(facetName, "(key) field [" + keyField + "] is not of type date");
        }
        if (!intervalSet) {
            throw new FacetPhaseExecutionException(facetName, "[interval] is required to be set for histogram facet");
        }
        if (sInterval != null) {
            index = sInterval.indexOf(58);
            if (index != -1) {
                DateFieldParser fieldParser = this.dateFieldParsers.get(sInterval.substring(0, index));
                if (fieldParser == null) {
                    throw new FacetPhaseExecutionException(facetName, "failed to parse interval [" + sInterval + "] with custom rounding using built in intervals (year/month/...)");
                }
                DateTimeField field = fieldParser.parse(dateTime.getChronology());
                int rounding = this.rounding.get(sInterval.substring(index + 1));
                if (rounding == -1) {
                    throw new FacetPhaseExecutionException(facetName, "failed to parse interval [" + sInterval + "], rounding type [" + sInterval.substring(index + 1) + "] not found");
                }
                dateTime.setRounding(field, rounding);
            } else {
                DateFieldParser fieldParser = this.dateFieldParsers.get(sInterval);
                if (fieldParser != null) {
                    DateTimeField field = fieldParser.parse(dateTime.getChronology());
                    dateTime.setRounding(field, 1);
                } else {
                    try {
                        interval = TimeValue.parseTimeValue(sInterval, null).millis();
                    }
                    catch (Exception e) {
                        throw new FacetPhaseExecutionException(facetName, "failed to parse interval [" + sInterval + "], tried both as built in intervals (year/month/...) and as a time format");
                    }
                }
            }
        }
        if (valueScript != null) {
            return new ValueScriptDateHistogramFacetCollector(facetName, keyField, scriptLang, valueScript, params, dateTime, interval, comparatorType, context);
        }
        if (valueField == null) {
            return new CountDateHistogramFacetCollector(facetName, keyField, dateTime, interval, comparatorType, context);
        }
        return new ValueDateHistogramFacetCollector(facetName, keyField, valueField, dateTime, interval, comparatorType, context);
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        InternalDateHistogramFacet first = (InternalDateHistogramFacet)facets.get(0);
        return first.reduce(name, facets);
    }

    static interface DateFieldParser {
        public DateTimeField parse(Chronology var1);

        public static class SecondOfMinute
        implements DateFieldParser {
            @Override
            public DateTimeField parse(Chronology chronology) {
                return chronology.secondOfMinute();
            }
        }

        public static class MinuteOfHour
        implements DateFieldParser {
            @Override
            public DateTimeField parse(Chronology chronology) {
                return chronology.minuteOfHour();
            }
        }

        public static class HourOfDay
        implements DateFieldParser {
            @Override
            public DateTimeField parse(Chronology chronology) {
                return chronology.hourOfDay();
            }
        }

        public static class DayOfMonth
        implements DateFieldParser {
            @Override
            public DateTimeField parse(Chronology chronology) {
                return chronology.dayOfMonth();
            }
        }

        public static class MonthOfYear
        implements DateFieldParser {
            @Override
            public DateTimeField parse(Chronology chronology) {
                return chronology.monthOfYear();
            }
        }

        public static class YearOfCentury
        implements DateFieldParser {
            @Override
            public DateTimeField parse(Chronology chronology) {
                return chronology.yearOfCentury();
            }
        }

        public static class WeekOfWeekyear
        implements DateFieldParser {
            @Override
            public DateTimeField parse(Chronology chronology) {
                return chronology.weekOfWeekyear();
            }
        }
    }
}

