/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.pentaho.hadoop.hive.jdbc.HadoopConfigurationUtil;
import org.pentaho.hadoop.hive.jdbc.JDBCDriverCallable;

public class HiveDriver
implements Driver {
    private static final String METHOD_GET_JDBC_DRIVER = "getJdbcDriver";
    private static final String METHOD_JDBC_PARAM = "hive2";
    private HadoopConfigurationUtil util;

    public HiveDriver() {
        this(new HadoopConfigurationUtil());
    }

    public HiveDriver(HadoopConfigurationUtil util) {
        if (util == null) {
            throw new NullPointerException();
        }
        this.util = util;
    }

    protected Driver getActiveDriver() throws SQLException {
        Driver driver = null;
        try {
            Object shim = this.util.getActiveHadoopShim();
            Method getHiveJdbcDriver = shim.getClass().getMethod(METHOD_GET_JDBC_DRIVER, String.class);
            driver = (Driver)getHiveJdbcDriver.invoke(shim, METHOD_JDBC_PARAM);
        }
        catch (Exception ex) {
            throw new SQLException("Unable to load Hive Server 2 JDBC driver for the currently active Hadoop configuration", ex);
        }
        if (driver != null && driver.getClass() == this.getClass()) {
            driver = null;
        }
        return driver;
    }

    protected <T> T callWithActiveDriver(JDBCDriverCallable<T> callback) throws SQLException {
        Driver drv = this.getActiveDriver();
        if (drv != null) {
            return callback.callWithDriver(drv);
        }
        throw new SQLException("The active Hadoop configuration does not contain a Hive Server 2 / Impala JDBC driver");
    }

    @Override
    public Connection connect(final String url, final Properties info) throws SQLException {
        if (this.getActiveDriver() == null) {
            return null;
        }
        return this.callWithActiveDriver(new JDBCDriverCallable<Connection>(){

            @Override
            public Connection call() throws Exception {
                return this.driver.connect(url, info);
            }
        });
    }

    @Override
    public boolean acceptsURL(final String url) throws SQLException {
        try {
            boolean accepts = this.callWithActiveDriver(new JDBCDriverCallable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        return this.driver.acceptsURL(url);
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
            });
            return Boolean.TRUE.equals(accepts);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(final String url, final Properties info) throws SQLException {
        return this.callWithActiveDriver(new JDBCDriverCallable<DriverPropertyInfo[]>(){

            @Override
            public DriverPropertyInfo[] call() throws Exception {
                return this.driver.getPropertyInfo(url, info);
            }
        });
    }

    @Override
    public int getMajorVersion() {
        try {
            return this.callWithActiveDriver(new JDBCDriverCallable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return this.driver.getMajorVersion();
                }
            });
        }
        catch (SQLException ex) {
            return -1;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return this.callWithActiveDriver(new JDBCDriverCallable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return this.driver.getMinorVersion();
                }
            });
        }
        catch (SQLException ex) {
            return -1;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return Boolean.TRUE.equals(this.callWithActiveDriver(new JDBCDriverCallable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return this.driver.jdbcCompliant();
                }
            }));
        }
        catch (SQLException ex) {
            return false;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new HiveDriver());
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to register Hive Server 2 JDBC driver", ex);
        }
    }
}

