/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.hive.jdbc;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.concurrent.Callable;

public abstract class JDBCDriverCallable<T>
implements Callable<T> {
    protected Driver driver;

    public T callWithDriver(Driver driver) throws SQLException {
        this.driver = driver;
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(driver.getClass().getClassLoader());
        try {
            Object v = this.call();
            return (T)v;
        }
        catch (Exception ex) {
            if (SQLException.class.isAssignableFrom(ex.getClass())) {
                throw (SQLException)ex;
            }
            throw new SQLException("Error communicating with Hive", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }
}

