/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.dom;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.dom.MatcherContext;
import org.pentaho.reporting.engine.classic.core.dom.NodeMatcher;

public class AttributeMatcher
implements NodeMatcher {
    public String namespace;
    public String name;
    public Object value;

    public AttributeMatcher(String name) {
        this(null, name, null);
    }

    public AttributeMatcher(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public AttributeMatcher(String namespace, String name, Object value) {
        this.namespace = namespace;
        this.name = name;
        this.value = value;
    }

    @Override
    public boolean matches(MatcherContext context, ReportElement node) {
        return this.eval(node);
    }

    private boolean eval(ReportElement node) {
        if (this.namespace == null) {
            Object firstAttribute = node.getAttributes().getFirstAttribute(this.name);
            if (this.value != null) {
                return this.value.equals(firstAttribute);
            }
            return firstAttribute != null;
        }
        Object attribute = node.getAttributes().getAttribute(this.namespace, this.name);
        if (this.value != null) {
            return this.value.equals(attribute);
        }
        return attribute != null;
    }

    public String toString() {
        String prefix = "AttributeMatcher(";
        if (this.namespace != null) {
            prefix = prefix + "'" + this.namespace + "'; ";
        }
        prefix = prefix + this.name;
        if (this.value != null) {
            prefix = prefix + "; " + this.value;
        }
        return prefix + ")";
    }
}

