/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.formula.ErrorValue;

public class AttributeExpressionsEvaluator
extends AbstractElementFormatFunction
implements StructureFunction {
    private static final Log logger = LogFactory.getLog(AttributeExpressionsEvaluator.class);
    private boolean failOnErrors;

    @Override
    public void reportInitialized(ReportEvent event) {
        this.failOnErrors = "true".equals(this.getRuntime().getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.FailOnAttributeExpressionErrors"));
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        super.reportInitialized(event);
        if (!event.getState().isSubReportEvent()) {
            ReportDefinition definition = event.getReport();
            this.evaluateElement(definition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean evaluateElement(ReportElement e) {
        if (e == null) {
            throw new NullPointerException();
        }
        String[] namespaces = e.getAttributeExpressionNamespaces();
        if (namespaces.length == 0) {
            return false;
        }
        ConverterRegistry instance = ConverterRegistry.getInstance();
        ElementMetaData metaData = e.getMetaData();
        boolean retval = false;
        for (int namespaceIdx = 0; namespaceIdx < namespaces.length; ++namespaceIdx) {
            String namespace = namespaces[namespaceIdx];
            String[] names = e.getAttributeExpressionNames(namespace);
            for (int nameIdx = 0; nameIdx < names.length; ++nameIdx) {
                AttributeMetaData attribute;
                String name = names[nameIdx];
                Expression ex = e.getAttributeExpression(namespace, name);
                if (ex == null || (attribute = metaData.getAttributeDescription(namespace, name)) != null && attribute.isDesignTimeValue()) continue;
                retval = true;
                ex.setRuntime(this.getRuntime());
                try {
                    Object value = this.evaluate(ex);
                    if (attribute == null) {
                        e.setAttribute(namespace, name, value);
                        continue;
                    }
                    Class type = attribute.getTargetType();
                    if (value == null || type.isAssignableFrom(value.getClass())) {
                        e.setAttribute(namespace, name, value);
                        continue;
                    }
                    if (value instanceof ErrorValue) {
                        if (this.failOnErrors) {
                            throw new InvalidReportStateException(String.format("Failed to evaluate attribute-expression for attribute %s:%s on element [%s]", namespace, name, FunctionUtilities.computeElementLocation(e)));
                        }
                        e.setAttribute(namespace, name, null);
                        continue;
                    }
                    PropertyEditor propertyEditor = attribute.getEditor();
                    if (propertyEditor != null) {
                        propertyEditor.setAsText(String.valueOf(value));
                        e.setAttribute(namespace, name, propertyEditor.getValue());
                        continue;
                    }
                    ValueConverter valueConverter = instance.getValueConverter(type);
                    if (type.isAssignableFrom(String.class)) {
                        e.setAttribute(namespace, name, value);
                        continue;
                    }
                    if (valueConverter != null) {
                        Object o = ConverterRegistry.toPropertyValue(String.valueOf(value), type);
                        e.setAttribute(namespace, name, o);
                        continue;
                    }
                    e.setAttribute(namespace, name, null);
                    continue;
                }
                catch (InvalidReportStateException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Failed to evaluate attribute-expression for attribute %s:%s on element [%s]", namespace, name, FunctionUtilities.computeElementLocation(e)), (Throwable)exception);
                    }
                    if (this.failOnErrors) {
                        throw new InvalidReportStateException(String.format("Failed to evaluate attribute-expression for attribute %s:%s on element [%s]", namespace, name, FunctionUtilities.computeElementLocation(e)), exception);
                    }
                    e.setAttribute(namespace, name, null);
                    continue;
                }
                finally {
                    ex.setRuntime(null);
                }
            }
        }
        return retval;
    }

    private Object evaluate(Expression ex) throws IOException, SQLException {
        Object retval = ex.getValue();
        if (retval instanceof Clob) {
            return IOUtils.getInstance().readClob((Clob)retval);
        }
        if (retval instanceof Blob) {
            return IOUtils.getInstance().readBlob((Blob)retval);
        }
        return retval;
    }

    @Override
    public int getProcessingPriority() {
        return 2000;
    }
}

