/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.print;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PrintUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PrintingPlugin;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class PrintExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(PrintExportTask.class);
    private Messages messages;
    private MasterReport job;
    private ReportProgressDialog progressListener;
    private StatusListener statusListener;

    public PrintExportTask(MasterReport job, ReportProgressDialog progressListener, SwingGuiContext swingGuiContext) {
        this.job = job;
        this.progressListener = progressListener;
        if (swingGuiContext != null) {
            this.statusListener = swingGuiContext.getStatusListener();
            this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.print.messages.messages", ObjectUtilities.getClassLoader(PrintingPlugin.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            PrintUtil.print(this.job, new OnDemandShowProgressListener(this.progressListener));
        }
        catch (Exception e) {
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("PrintExportTask.USER_EXPORT_FAILED"), e);
            }
            logger.error((Object)"Printing Failed", (Throwable)e);
        }
        finally {
            if (this.progressListener != null) {
                this.progressListener.setVisible(false);
            }
        }
    }

    private static class OnDemandShowProgressListener
    implements ReportProgressListener {
        private ReportProgressDialog dialog;

        private OnDemandShowProgressListener(ReportProgressDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void reportProcessingStarted(ReportProgressEvent event) {
            if (this.dialog != null) {
                this.dialog.setVisibleInEDT(true);
                this.dialog.reportProcessingStarted(event);
            }
        }

        @Override
        public void reportProcessingUpdate(ReportProgressEvent event) {
            if (this.dialog != null) {
                this.dialog.reportProcessingUpdate(event);
            }
        }

        @Override
        public void reportProcessingFinished(ReportProgressEvent event) {
            if (this.dialog != null) {
                this.dialog.reportProcessingFinished(event);
                this.dialog.setVisibleInEDT(false);
            }
        }
    }
}

