/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.ScriptValueConverter;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public final class DataFactoryScriptingSupport
implements Cloneable,
Serializable {
    private static ArrayList<ScriptValueConverter> converters;
    private static final Log logger;
    private String globalScriptLanguage;
    private String globalScript;
    private HashMap<String, QueryCarrier> queryMappings = new HashMap();
    private transient HashMap<String, QueryScriptContext> contextsByQuery = new HashMap();
    private transient ScriptContext globalScriptContext;
    private transient Invocable globalScriptEngine;
    private transient ResourceManager resourceManager;
    private transient ResourceKey contextKey;
    private transient DataFactory dataFactory;
    private transient Configuration configuration;
    private transient ResourceBundleFactory resourceBundleFactory;
    private transient boolean initialized;
    private transient DataFactoryContext dataFactoryContext;

    public Object clone() {
        try {
            DataFactoryScriptingSupport clone = (DataFactoryScriptingSupport)super.clone();
            clone.queryMappings = (HashMap)this.queryMappings.clone();
            clone.globalScriptContext = null;
            clone.contextsByQuery = (HashMap)this.contextsByQuery.clone();
            clone.contextsByQuery.clear();
            clone.dataFactory = null;
            clone.resourceBundleFactory = null;
            clone.resourceManager = null;
            clone.configuration = null;
            clone.contextKey = null;
            clone.initialized = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public void setQuery(String name, String query, String scriptLanguage, String script) {
        this.queryMappings.put(name, new QueryCarrier(query, scriptLanguage, script));
    }

    public String getScriptingLanguage(String name) {
        QueryCarrier queryCarrier = this.queryMappings.get(name);
        if (queryCarrier == null) {
            return null;
        }
        return queryCarrier.getScriptingLanguage();
    }

    protected String computeScriptingLanguage(String name) {
        QueryCarrier queryCarrier = this.queryMappings.get(name);
        if (queryCarrier == null) {
            return null;
        }
        String scriptingLanguage = queryCarrier.getScriptingLanguage();
        if (scriptingLanguage == null) {
            return this.globalScriptLanguage;
        }
        return scriptingLanguage;
    }

    public String getScript(String name) {
        QueryCarrier queryCarrier = this.queryMappings.get(name);
        if (queryCarrier == null) {
            return null;
        }
        return queryCarrier.getScript();
    }

    public String getQuery(String name) {
        QueryCarrier queryCarrier = this.queryMappings.get(name);
        if (queryCarrier == null) {
            return null;
        }
        return queryCarrier.getQuery();
    }

    public String[] getQueryNames() {
        return this.queryMappings.keySet().toArray(new String[this.queryMappings.size()]);
    }

    public String getGlobalScript() {
        return this.globalScript;
    }

    public void setGlobalScript(String globalScript) {
        this.globalScript = globalScript;
    }

    public String getGlobalScriptLanguage() {
        return this.globalScriptLanguage;
    }

    public void setGlobalScriptLanguage(String globalScriptLanguage) {
        this.globalScriptLanguage = globalScriptLanguage;
    }

    public void initialize(DataFactory dataFactory, DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        if (this.globalScriptContext != null) {
            return;
        }
        this.dataFactory = dataFactory;
        this.resourceManager = dataFactoryContext.getResourceManager();
        this.contextKey = dataFactoryContext.getContextKey();
        this.configuration = dataFactoryContext.getConfiguration();
        this.resourceBundleFactory = dataFactoryContext.getResourceBundleFactory();
        this.dataFactoryContext = dataFactoryContext;
        this.globalScriptContext = new SimpleScriptContext();
        this.globalScriptContext.setAttribute("dataFactory", dataFactory, 100);
        this.globalScriptContext.setAttribute("configuration", this.configuration, 100);
        this.globalScriptContext.setAttribute("resourceManager", this.resourceManager, 100);
        this.globalScriptContext.setAttribute("contextKey", this.contextKey, 100);
        this.globalScriptContext.setAttribute("resourceBundleFactory", this.resourceBundleFactory, 100);
        if (StringUtils.isEmpty((String)this.globalScriptLanguage)) {
            return;
        }
        this.globalScriptContext.setAttribute("scriptHelper", new ScriptHelper(this.globalScriptContext, this.globalScriptLanguage, this.resourceManager, this.contextKey), 100);
        ScriptEngine maybeInvocableEngine = new ScriptEngineManager().getEngineByName(this.globalScriptLanguage);
        if (maybeInvocableEngine == null) {
            throw new ReportDataFactoryException(String.format("DataFactoryScriptingSupport: Failed to locate scripting engine for language '%s'.", this.globalScriptLanguage));
        }
        if (!(maybeInvocableEngine instanceof Invocable)) {
            return;
        }
        this.globalScriptEngine = (Invocable)((Object)maybeInvocableEngine);
        maybeInvocableEngine.setContext(this.globalScriptContext);
        try {
            maybeInvocableEngine.eval(this.globalScript);
        }
        catch (ScriptException e) {
            throw new ReportDataFactoryException("DataFactoryScriptingSupport: Failed to execute datafactory init script.", (Throwable)e);
        }
    }

    protected void callGlobalInitialize(DataRow parameter) throws ReportDataFactoryException {
        if (this.initialized) {
            return;
        }
        try {
            this.initialized = true;
            if (this.globalScriptEngine != null) {
                this.globalScriptEngine.invokeFunction("init", parameter);
            }
        }
        catch (ScriptException e) {
            throw new ReportDataFactoryException("DataFactoryScriptingSupport: Failed to invoke global init method.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)"Global script does not contain an 'init' function");
        }
    }

    public String computeQuery(String queryName, DataRow parameter) throws ReportDataFactoryException {
        this.callGlobalInitialize(parameter);
        String queryScriptLanguage = this.computeScriptingLanguage(queryName);
        String queryScript = this.getScript(queryName);
        if (StringUtils.isEmpty((String)queryScriptLanguage) || StringUtils.isEmpty((String)queryScript)) {
            return this.getQuery(queryName);
        }
        QueryScriptContext queryScriptContext = this.contextsByQuery.get(queryName);
        if (queryScriptContext == null) {
            queryScriptContext = new QueryScriptContext();
            queryScriptContext.init(queryName, queryScriptLanguage, queryScript, this.globalScriptContext, this.resourceManager, this.contextKey, this.dataFactory, this.configuration, this.resourceBundleFactory);
            this.contextsByQuery.put(queryName, queryScriptContext);
        }
        return queryScriptContext.computeQuery(this.getQuery(queryName), queryName, parameter);
    }

    public TableModel postProcessResult(String queryName, DataRow parameter, TableModel result) throws ReportDataFactoryException {
        this.callGlobalInitialize(parameter);
        String queryScriptLanguage = this.computeScriptingLanguage(queryName);
        String queryScript = this.getScript(queryName);
        if (StringUtils.isEmpty((String)queryScriptLanguage) || StringUtils.isEmpty((String)queryScript)) {
            return result;
        }
        QueryScriptContext queryScriptContext = this.contextsByQuery.get(queryName);
        if (queryScriptContext == null) {
            queryScriptContext = new QueryScriptContext();
            queryScriptContext.init(queryName, queryScriptLanguage, queryScript, this.globalScriptContext, this.resourceManager, this.contextKey, this.dataFactory, this.configuration, this.resourceBundleFactory);
            this.contextsByQuery.put(queryName, queryScriptContext);
        }
        return queryScriptContext.postProcessResult(this.getQuery(queryName), queryName, parameter, result);
    }

    public String[] computeAdditionalQueryFields(String queryName, DataRow parameter) throws ReportDataFactoryException {
        this.callGlobalInitialize(parameter);
        String queryScriptLanguage = this.computeScriptingLanguage(queryName);
        String queryScript = this.getScript(queryName);
        if (StringUtils.isEmpty((String)queryScriptLanguage) || StringUtils.isEmpty((String)queryScript)) {
            return new String[0];
        }
        QueryScriptContext queryScriptContext = this.contextsByQuery.get(queryName);
        if (queryScriptContext == null) {
            queryScriptContext = new QueryScriptContext();
            queryScriptContext.init(queryName, queryScriptLanguage, queryScript, this.globalScriptContext, this.resourceManager, this.contextKey, this.dataFactory, this.configuration, this.resourceBundleFactory);
            this.contextsByQuery.put(queryName, queryScriptContext);
        }
        return queryScriptContext.computeAdditionalQueryFields(this.getQuery(queryName), queryName);
    }

    public void shutdown() {
        for (Map.Entry<String, QueryScriptContext> entry : this.contextsByQuery.entrySet()) {
            try {
                QueryScriptContext context = entry.getValue();
                context.shutdown();
            }
            catch (ReportDataFactoryException se) {
                logger.warn((Object)("Failed to shut down query script context: " + entry.getKey()));
            }
        }
        if (this.globalScriptEngine != null) {
            try {
                this.globalScriptEngine.invokeFunction("shutdown", new Object[0]);
            }
            catch (ScriptException e) {
                logger.warn((Object)"DataFactoryScriptingSupport: Failed to invoke global shutdown method.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)"Global script does not contain an 'shutdown' function");
            }
        }
        this.globalScriptContext = null;
        this.resourceManager = null;
        this.contextKey = null;
        this.dataFactory = null;
        this.resourceBundleFactory = null;
        this.configuration = null;
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convert(Object object) {
        if (object == null) {
            return null;
        }
        Class<DataFactoryScriptingSupport> clazz = DataFactoryScriptingSupport.class;
        synchronized (DataFactoryScriptingSupport.class) {
            if (converters == null) {
                converters = new ArrayList();
                Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
                Iterator propertyKeys = globalConfig.findPropertyKeys("org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.script-value-converters.");
                while (propertyKeys.hasNext()) {
                    String key = (String)propertyKeys.next();
                    String impl = globalConfig.getConfigProperty(key);
                    ScriptValueConverter converter = (ScriptValueConverter)ObjectUtilities.loadAndInstantiate((String)impl, ScriptValueConverter.class, ScriptValueConverter.class);
                    if (converter == null) continue;
                    converters.add(converter);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (converters.isEmpty()) {
                return object;
            }
            for (ScriptValueConverter converter : converters) {
                Object convert = converter.convert(object);
                if (convert == null) continue;
                return convert;
            }
            return object;
        }
    }

    public boolean containsQuery(String query) {
        return this.queryMappings.containsKey(query);
    }

    public void remove(String name) {
        this.queryMappings.remove(name);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.contextsByQuery = new HashMap();
    }

    static {
        logger = LogFactory.getLog(DataFactoryScriptingSupport.class);
    }

    private static class QueryScriptContext {
        private Invocable invocableEngine;
        private ScriptEngine scriptEngine;
        private ScriptContext context;

        private QueryScriptContext() {
        }

        public void init(String queryName, String scriptLanguage, String script, ScriptContext globalContext, ResourceManager resourceManager, ResourceKey contextKey, DataFactory dataFactory, Configuration configuration, ResourceBundleFactory resourceBundleFactory) throws ReportDataFactoryException {
            this.context = new SimpleScriptContext();
            if (globalContext != null) {
                Bindings bindings = globalContext.getBindings(100);
                this.context.getBindings(100).putAll(bindings);
            } else {
                this.context.setAttribute("dataFactory", dataFactory, 100);
                this.context.setAttribute("configuration", configuration, 100);
                this.context.setAttribute("resourceManager", resourceManager, 100);
                this.context.setAttribute("contextKey", contextKey, 100);
                this.context.setAttribute("resourceBundleFactory", resourceBundleFactory, 100);
            }
            this.context.setAttribute("scriptHelper", new ScriptHelper(this.context, scriptLanguage, resourceManager, contextKey), 100);
            this.scriptEngine = new ScriptEngineManager().getEngineByName(scriptLanguage);
            if (!(this.scriptEngine instanceof Invocable)) {
                throw new ReportDataFactoryException(String.format("Query script language '%s' is not usable.", scriptLanguage));
            }
            this.invocableEngine = (Invocable)((Object)this.scriptEngine);
            this.scriptEngine.setContext(this.context);
            try {
                this.scriptEngine.eval(script);
            }
            catch (ScriptException e) {
                throw new ReportDataFactoryException("DataFactoryScriptingSupport: Failed to initialize local query script: " + queryName, (Throwable)e);
            }
            try {
                this.invocableEngine.invokeFunction("initQuery", new Object[0]);
            }
            catch (ScriptException e) {
                throw new ReportDataFactoryException("DataFactoryScriptingSupport: Failed to invoke local init method: " + queryName, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)"Global script does not contain an 'init' function");
            }
        }

        public String computeQuery(String query, String queryName, DataRow parameter) throws ReportDataFactoryException {
            if (this.invocableEngine == null) {
                return query;
            }
            try {
                Object computeQuery = this.invocableEngine.invokeFunction("computeQuery", query, queryName, parameter);
                Object translated = DataFactoryScriptingSupport.convert(computeQuery);
                if (translated == null) {
                    throw new ReportDataFactoryException("DataFactoryScriptingSupport: computeQuery method did not return a valid query.");
                }
                return String.valueOf(translated);
            }
            catch (ScriptException e) {
                throw new ReportDataFactoryException("DataFactoryScriptingSupport: Failed to invoke computeQuery method.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)"Query script does not contain an 'computeQuery' function");
                return query;
            }
        }

        public TableModel postProcessResult(String query, String queryName, DataRow parameter, TableModel dataSet) throws ReportDataFactoryException {
            if (this.invocableEngine == null) {
                return dataSet;
            }
            try {
                Object computeQuery = this.invocableEngine.invokeFunction("postProcessResult", query, queryName, parameter, dataSet);
                Object translated = DataFactoryScriptingSupport.convert(computeQuery);
                if (!(translated instanceof TableModel)) {
                    throw new ReportDataFactoryException("DataFactoryScriptingSupport: postProcessResult method did not return a valid query.");
                }
                return (TableModel)translated;
            }
            catch (ScriptException e) {
                throw new ReportDataFactoryException("DataFactoryScriptingSupport: Failed to invoke postProcessResult method.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)"Query script does not contain an 'postProcessResult' function");
                return dataSet;
            }
        }

        public void shutdown() throws ReportDataFactoryException {
            if (this.invocableEngine == null) {
                return;
            }
            try {
                this.invocableEngine.invokeFunction("shutdownQuery", new Object[0]);
            }
            catch (ScriptException e) {
                throw new ReportDataFactoryException("DataFactoryScriptingSupport: Failed to invoke query shutdown method.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)"Global script does not contain an 'shutdownQuery' function");
            }
        }

        public String[] computeAdditionalQueryFields(String query, String queryName) throws ReportDataFactoryException {
            if (this.invocableEngine == null) {
                return new String[0];
            }
            try {
                Object[] rawArray;
                Object computeQuery = this.invocableEngine.invokeFunction("computeQueryFields", query, queryName);
                Object translated = DataFactoryScriptingSupport.convert(computeQuery);
                if (translated == null) {
                    return null;
                }
                if (translated instanceof Object[]) {
                    rawArray = (Object[])translated;
                } else if (translated instanceof Collection) {
                    Collection c = (Collection)translated;
                    rawArray = c.toArray();
                } else {
                    rawArray = new Object[]{translated};
                }
                ArrayList<String> retval = new ArrayList<String>();
                for (int i = 0; i < rawArray.length; ++i) {
                    Object o = rawArray[i];
                    if (o == null) continue;
                    retval.add(String.valueOf(o));
                }
                return retval.toArray(new String[retval.size()]);
            }
            catch (ScriptException e) {
                throw new ReportDataFactoryException("DataFactoryScriptingSupport: Failed to invoke computeQueryFields method.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)"Query script does not contain an 'computeQueryFields' function");
                return null;
            }
        }
    }

    public static class ScriptHelper {
        private ScriptContext context;
        private String defaultScriptLanguage;
        private ResourceManager resourceManager;
        private ResourceKey contextKey;

        public ScriptHelper(ScriptContext context, String defaultScriptLanguage, ResourceManager resourceManager, ResourceKey contextKey) {
            this.context = context;
            this.defaultScriptLanguage = defaultScriptLanguage;
            this.resourceManager = resourceManager;
            this.contextKey = contextKey;
        }

        public Object eval(String script) throws ScriptException {
            return this.eval(script, this.defaultScriptLanguage);
        }

        public Object eval(String script, String scriptLanguage) throws ScriptException {
            ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName(scriptLanguage);
            if (scriptEngine == null) {
                throw new ScriptException(String.format("DataFactoryScriptingSupport: Failed to locate scripting engine for language '%s'.", scriptLanguage));
            }
            scriptEngine.setContext(this.context);
            return scriptEngine.eval(script);
        }

        public Object evalFile(String file) throws ScriptException {
            return this.evalFile(file, this.defaultScriptLanguage);
        }

        public Object evalFile(String file, String language) throws ScriptException {
            return this.evalFile(file, language, EncodingRegistry.getPlatformDefaultEncoding());
        }

        public Object evalFile(String file, String defaultScriptLanguage, String encoding) throws ScriptException {
            ResourceKey resourceKey = this.createKeyFromString(this.resourceManager, this.contextKey, file);
            if (resourceKey == null) {
                throw new ScriptException("Unable to load script");
            }
            try {
                ResourceData loadedResource = this.resourceManager.load(resourceKey);
                byte[] resource = loadedResource.getResource(this.resourceManager);
                return this.eval(new String(resource, encoding), defaultScriptLanguage);
            }
            catch (ResourceLoadingException e) {
                throw new ScriptException((Exception)((Object)e));
            }
            catch (UnsupportedEncodingException e) {
                throw new ScriptException(e);
            }
        }

        private ResourceKey createKeyFromString(ResourceManager resourceManager, ResourceKey contextKey, String file) {
            try {
                if (contextKey != null) {
                    return resourceManager.deriveKey(contextKey, file);
                }
            }
            catch (ResourceException re) {
                logger.debug((Object)"Failed to load datasource as derived path: ", (Throwable)re);
            }
            try {
                return resourceManager.createKey((Object)new URL(file));
            }
            catch (ResourceException re) {
                logger.debug((Object)"Failed to load datasource as URL: ", (Throwable)re);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            try {
                return resourceManager.createKey((Object)new File(file));
            }
            catch (ResourceException re) {
                logger.debug((Object)"Failed to load datasource as file: ", (Throwable)re);
                return null;
            }
        }
    }

    private static class QueryCarrier
    implements Serializable {
        private String query;
        private String scriptingLanguage;
        private String script;

        private QueryCarrier(String query, String scriptingLanguage, String script) {
            this.query = query;
            this.scriptingLanguage = scriptingLanguage;
            this.script = script;
        }

        public String getQuery() {
            return this.query;
        }

        public String getScriptingLanguage() {
            return this.scriptingLanguage;
        }

        public String getScript() {
            return this.script;
        }
    }
}

