/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext;

import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.AbstractReportProcessTask;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.PageableTextOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.TextFilePrinterDriver;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class PlainTextReportProcessTask
extends AbstractReportProcessTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isValid()) {
            this.setError(new ReportProcessingException("Error: The task is not configured properly."));
            return;
        }
        this.setError(null);
        try {
            MasterReport masterReport = this.getReport();
            Configuration configuration = masterReport.getConfiguration();
            ContentLocation contentLocation = this.getBodyContentLocation();
            NameGenerator nameGenerator = this.getBodyNameGenerator();
            ContentItem contentItem = contentLocation.createItem(nameGenerator.generateName(null, "text/plain"));
            OutputStream outputStream = contentItem.getOutputStream();
            try {
                String cpiText = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.CharsPerInch");
                String lpiText = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.LinesPerInch");
                TextFilePrinterDriver driver = new TextFilePrinterDriver(outputStream, ParserUtil.parseInt((String)cpiText, (int)10), ParserUtil.parseInt((String)lpiText, (int)6));
                PageableTextOutputProcessor outputProcessor = new PageableTextOutputProcessor(driver, configuration);
                PageableReportProcessor streamReportProcessor = new PageableReportProcessor(masterReport, outputProcessor);
                try {
                    ReportProgressListener[] progressListeners = this.getReportProgressListeners();
                    for (int i = 0; i < progressListeners.length; ++i) {
                        ReportProgressListener listener = progressListeners[i];
                        streamReportProcessor.addReportProgressListener(listener);
                    }
                    streamReportProcessor.processReport();
                }
                finally {
                    streamReportProcessor.close();
                }
            }
            finally {
                outputStream.close();
            }
        }
        catch (Throwable e) {
            this.setError(e);
        }
    }

    @Override
    public String getReportMimeType() {
        return "text/plain";
    }
}

