/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.XmlPageOutputProcessor;

public class XmlPageReportUtil {
    private static final Log logger = LogFactory.getLog(XmlPageReportUtil.class);

    private XmlPageReportUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createXml(MasterReport report, File fileName) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (fileName == null) {
            throw new NullPointerException();
        }
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(fileName));
            XmlPageReportUtil.createXml(report, out);
            out.close();
            out = null;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"Writing XML failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Saving XML failed.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createXml(MasterReport report, OutputStream out) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (out == null) {
            throw new NullPointerException();
        }
        AbstractReportProcessor proc = null;
        try {
            XmlPageOutputProcessor outputProcessor = new XmlPageOutputProcessor(report.getConfiguration(), out);
            proc = new PageableReportProcessor(report, outputProcessor);
            proc.processReport();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"Writing XML failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (proc != null) {
                proc.close();
            }
        }
    }

    public static boolean createXml(MasterReport report, String fileName) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (fileName == null) {
            throw new NullPointerException();
        }
        return XmlPageReportUtil.createXml(report, new File(fileName));
    }
}

