/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.csv;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.StreamCSVOutputProcessor;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public final class CSVReportUtil {
    private CSVReportUtil() {
    }

    public static void createCSV(MasterReport report, OutputStream outputStream, String encoding) throws ReportProcessingException, IOException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        StreamCSVOutputProcessor target = new StreamCSVOutputProcessor(outputStream);
        if (encoding != null) {
            target.setEncoding(encoding);
        }
        StreamReportProcessor reportProcessor = new StreamReportProcessor(report, target);
        reportProcessor.processReport();
        reportProcessor.close();
        outputStream.flush();
    }

    public static void createCSV(MasterReport report, String filename) throws ReportProcessingException, IOException {
        CSVReportUtil.createCSV(report, filename, EncodingRegistry.getPlatformDefaultEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCSV(MasterReport report, String filename, String encoding) throws ReportProcessingException, IOException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (filename == null) {
            throw new NullPointerException();
        }
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(filename));
        try {
            CSVReportUtil.createCSV(report, fout, encoding);
        }
        finally {
            ((OutputStream)fout).close();
        }
    }
}

