/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Image;
import java.awt.Shape;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackgroundProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPrinterBase;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.SheetPropertySource;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class ExcelPrinter
extends ExcelPrinterBase {
    private static final Log logger = LogFactory.getLog(ExcelPrinter.class);
    private OutputStream outputStream;
    private Workbook workbook;
    private Sheet sheet;
    private CellBackgroundProducer cellBackgroundProducer;
    private ExcelTextExtractor textExtractor;
    private ResourceManager resourceManager;

    public ExcelPrinter(OutputStream outputStream, ResourceManager resourceManager) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.resourceManager = resourceManager;
        this.outputStream = outputStream;
    }

    public void init(OutputProcessorMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        super.init(metaData, this.resourceManager);
        this.cellBackgroundProducer = new CellBackgroundProducer(metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE), metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS));
    }

    @Override
    public Sheet getSheet() {
        return this.sheet;
    }

    public void print(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer, boolean incremental) {
        if (this.workbook == null) {
            this.workbook = this.createWorkbook();
            this.initializeStyleProducers(this.workbook);
            this.textExtractor = new ExcelTextExtractor(this.getMetaData(), this.getFontColorProducer(), this.workbook.getCreationHelper(), this.getCellStyleProducer().getFontFactory());
        }
        int startRow = contentProducer.getFinishedRows();
        int finishRow = contentProducer.getFilledRows();
        if (incremental && startRow == finishRow) {
            return;
        }
        if (this.sheet == null) {
            this.sheet = this.openSheet(contentProducer.getSheetName());
            SheetPropertySource excelTableContentProducer = (SheetPropertySource)((Object)contentProducer);
            this.configureSheetProperties(this.sheet, excelTableContentProducer);
            this.configureSheetPaperSize(this.sheet, logicalPage.getPageGrid().getPage(0, 0));
            this.configureSheetColumnWidths(this.sheet, contentProducer.getSheetLayout(), contentProducer.getColumnCount());
        }
        SheetLayout sheetLayout = contentProducer.getSheetLayout();
        int colCount = sheetLayout.getColumnCount();
        for (int row = startRow; row < finishRow; ++row) {
            Row hssfRow = this.getRowAt(row);
            double lastRowHeight = StrictGeomUtility.toExternalValue(sheetLayout.getRowHeight(row));
            hssfRow.setHeightInPoints((float)lastRowHeight);
            for (int col = 0; col < colCount; ++col) {
                CellMarker.SectionType sectionType = contentProducer.getSectionType(row, col);
                RenderBox content = contentProducer.getContent(row, col);
                if (content == null) {
                    RenderBox backgroundBox = contentProducer.getBackground(row, col);
                    CellBackground background = backgroundBox != null ? this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, col, row, 1, 1, true, sectionType, backgroundBox) : this.cellBackgroundProducer.getBackgroundAt(logicalPage, sheetLayout, col, row, true, sectionType);
                    if (background == null) {
                        if (row != 0 || col != 0) continue;
                        this.getCellAt(col, row);
                        continue;
                    }
                    Cell cell = this.getCellAt(col, row);
                    CellStyle style = this.getCellStyleProducer().createCellStyle(null, null, background);
                    if (style == null) continue;
                    cell.setCellStyle(style);
                    continue;
                }
                if (!content.isCommited()) {
                    throw new InvalidReportStateException("Uncommited content encountered");
                }
                long contentOffset = contentProducer.getContentOffset(row, col);
                TableRectangle rectangle = sheetLayout.getTableBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight(), null);
                if (!rectangle.isOrigin(col, row)) continue;
                CellBackground fastBackground = this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, rectangle.getX1(), rectangle.getY1(), rectangle.getColumnSpan(), rectangle.getRowSpan(), false, sectionType, content);
                Cell cell = this.getCellAt(col, row);
                CellStyle style = this.getCellStyleProducer().createCellStyle(content.getInstanceId(), content.getStyleSheet(), fastBackground);
                if (style != null) {
                    cell.setCellStyle(style);
                }
                if (this.applyCellValue(content, cell, sheetLayout, rectangle, contentOffset)) {
                    this.mergeCellRegion(rectangle, row, col, sheetLayout, logicalPage, content, contentProducer);
                }
                content.setFinishedTable(true);
            }
        }
        if (!incremental) {
            this.sheet = null;
        }
    }

    private void mergeCellRegion(TableRectangle rectangle, int row, int col, SheetLayout sheetLayout, LogicalPageBox logicalPage, RenderBox content, TableContentProducer contentProducer) {
        if (content == null) {
            throw new NullPointerException();
        }
        int rowSpan = rectangle.getRowSpan();
        int columnSpan = rectangle.getColumnSpan();
        if (rowSpan <= 1 && columnSpan <= 1) {
            return;
        }
        this.sheet.addMergedRegion(new CellRangeAddress(row, row + rowSpan - 1, col, col + columnSpan - 1));
        int rectX = rectangle.getX1();
        int rectY = rectangle.getY1();
        for (int spannedRow = 0; spannedRow < rowSpan; ++spannedRow) {
            for (int spannedCol = 0; spannedCol < columnSpan; ++spannedCol) {
                CellMarker.SectionType sectionType = contentProducer.getSectionType(row, col);
                CellBackground bg = this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, rectX + spannedCol, rectY + spannedRow, 1, 1, false, sectionType, content);
                Cell regionCell = this.getCellAt(col + spannedCol, row + spannedRow);
                CellStyle spannedStyle = this.getCellStyleProducer().createCellStyle(content.getInstanceId(), content.getStyleSheet(), bg);
                if (spannedStyle == null) continue;
                regionCell.setCellStyle(spannedStyle);
            }
        }
    }

    private boolean applyCellValue(RenderBox content, Cell cell, SheetLayout sheetLayout, TableRectangle rectangle, long contentOffset) {
        Object attr1;
        Object value = this.textExtractor.compute(content);
        if (this.handleImageValues(content, sheetLayout, rectangle, contentOffset, value)) {
            return false;
        }
        String linkTarget = (String)content.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TARGET);
        if (linkTarget != null) {
            String formula = "HYPERLINK(" + ExcelPrinter.splitAndQuoteExcelFormula(linkTarget) + "," + ExcelPrinter.splitAndQuoteExcelFormula(this.textExtractor.getText()) + ")";
            if (formula.length() < 1024) {
                cell.setCellFormula(formula);
                return true;
            }
            logger.warn((Object)"Excel-Cells cannot contain formulas longer than 1023 characters. Converting hyperlink into plain text");
        }
        if ((attr1 = content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "formula")) != null) {
            String formula = String.valueOf(attr1);
            if (formula.length() < 1024) {
                cell.setCellFormula(formula);
                return true;
            }
            logger.warn((Object)"Excel-Cells cannot contain formulas longer than 1023 characters. Converting excel formula into plain text");
        }
        if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            cell.setCellValue(number.doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(Boolean.TRUE.equals(value));
        } else if (value == null) {
            cell.setCellType(3);
        } else {
            cell.setCellValue(String.valueOf(value));
        }
        return true;
    }

    private boolean handleImageValues(RenderBox content, SheetLayout sheetLayout, TableRectangle rectangle, long contentOffset, Object value) {
        if (value instanceof Image) {
            try {
                DefaultImageReference imageContainer = new DefaultImageReference((Image)value);
                StyleSheet rawSource = this.textExtractor.getRawSource().getStyleSheet();
                StrictBounds contentBounds = new StrictBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight());
                this.createImageCell(rawSource, imageContainer, sheetLayout, rectangle, contentBounds);
            }
            catch (IOException ioe) {
                logger.warn((Object)"Failed to process AWT-Image in Excel-Export", (Throwable)ioe);
            }
            return true;
        }
        if (value instanceof ImageContainer) {
            ImageContainer imageContainer = (ImageContainer)value;
            StyleSheet rawSource = this.textExtractor.getRawSource().getStyleSheet();
            StrictBounds contentBounds = new StrictBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight());
            this.createImageCell(rawSource, imageContainer, sheetLayout, rectangle, contentBounds);
            return true;
        }
        if (value instanceof DrawableWrapper) {
            DrawableWrapper drawable = (DrawableWrapper)value;
            RenderNode rawSource = this.textExtractor.getRawSource();
            StrictBounds contentBounds = new StrictBounds(rawSource.getX(), rawSource.getY() + contentOffset, rawSource.getWidth(), rawSource.getHeight());
            ImageContainer imageFromDrawable = RenderUtility.createImageFromDrawable(drawable, contentBounds, content, this.getMetaData());
            this.createImageCell(rawSource.getStyleSheet(), imageFromDrawable, sheetLayout, rectangle, contentBounds);
            return true;
        }
        return value instanceof Shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        long start = System.currentTimeMillis();
        logger.info((Object)"Closing workbook and writing content to disk.");
        if (this.workbook != null) {
            try {
                this.workbook.write(this.outputStream);
                this.sheet = null;
                this.outputStream.flush();
            }
            catch (IOException e) {
                logger.warn((Object)"could not write xls data. Message:", (Throwable)e);
            }
            finally {
                this.workbook = null;
            }
        }
        long end = System.currentTimeMillis();
        logger.info((Object)("Closing workbook finished in " + (float)(end - start) / 1000.0f + "s"));
    }

    @Override
    public Workbook getWorkbook() {
        return this.workbook;
    }
}

