/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import org.pentaho.reporting.engine.classic.core.elementfactory.AbstractContentElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.AbstractElementReadHandler;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractImageElementReadHandler
extends AbstractElementReadHandler {
    private static final String SCALE_ATT = "scale";
    private static final String KEEP_ASPECT_RATIO_ATT = "keepAspectRatio";

    protected AbstractImageElementReadHandler() {
    }

    @Override
    protected void startParsing(PropertyAttributes atts) throws SAXException {
        super.startParsing(atts);
        this.handleScale(atts);
        this.handleKeepAspectRatio(atts);
    }

    protected void handleScale(PropertyAttributes atts) throws ParseException {
        String booleanValue = atts.getValue(this.getUri(), SCALE_ATT);
        AbstractContentElementFactory elementFactory = (AbstractContentElementFactory)this.getElementFactory();
        Boolean scale = ParserUtil.parseBoolean((String)booleanValue, (Locator)this.getLocator());
        elementFactory.setScale(scale);
    }

    protected void handleKeepAspectRatio(PropertyAttributes atts) throws ParseException {
        String booleanValue = atts.getValue(this.getUri(), KEEP_ASPECT_RATIO_ATT);
        AbstractContentElementFactory elementFactory = (AbstractContentElementFactory)this.getElementFactory();
        Boolean keepAspectRatio = ParserUtil.parseBoolean((String)booleanValue, (Locator)this.getLocator());
        elementFactory.setKeepAspectRatio(keepAspectRatio);
    }
}

