/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ModifiableReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;

public class DefaultParameterDefinition
implements ModifiableReportParameterDefinition {
    private ArrayList<ParameterDefinitionEntry> parameters = new ArrayList();
    private ReportParameterValidator validator = new DefaultReportParameterValidator();
    private ReportAttributeMap<String> attributeMap = new ReportAttributeMap();

    @Override
    public void addParameterDefinition(ParameterDefinitionEntry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        this.parameters.add(entry);
    }

    @Override
    public void addParameterDefinition(int index, ParameterDefinitionEntry entry) {
        if (entry == null) {
            throw new NullPointerException();
        }
        this.parameters.add(index, entry);
    }

    @Override
    public void removeParameterDefinition(int index) {
        this.parameters.remove(index);
    }

    @Override
    public void setAttribute(String domain, String name, String value) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.attributeMap.setAttribute(domain, name, value);
    }

    public String getAttribute(String domain, String name) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        return (String)this.attributeMap.getAttribute(domain, name);
    }

    @Override
    public int getParameterCount() {
        return this.parameters.size();
    }

    @Override
    public ParameterDefinitionEntry[] getParameterDefinitions() {
        return this.parameters.toArray(new ParameterDefinitionEntry[this.parameters.size()]);
    }

    @Override
    public ParameterDefinitionEntry getParameterDefinition(int parameter) {
        return this.parameters.get(parameter);
    }

    @Override
    public void setValidator(ReportParameterValidator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        this.validator = validator;
    }

    @Override
    public ReportParameterValidator getValidator() {
        return this.validator;
    }

    @Override
    public Object clone() {
        try {
            DefaultParameterDefinition def = (DefaultParameterDefinition)super.clone();
            def.parameters = (ArrayList)this.parameters.clone();
            def.attributeMap = this.attributeMap.clone();
            return def;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    public void removeParameterDefinition(ParameterDefinitionEntry definitionEntry) {
        this.parameters.remove(definitionEntry);
    }
}

