/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContextWrapper;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;

public class ParameterUtils {
    private ParameterUtils() {
    }

    public static ReportParameterValues initializeDefaultValues(MasterReport report, ParameterContext context) throws ReportDataFactoryException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        ReportParameterDefinition definition = report.getParameterDefinition();
        ReportParameterValues parameters = new ReportParameterValues(report.getParameterValues());
        ParameterContextWrapper wrapper = new ParameterContextWrapper(context, parameters);
        ParameterDefinitionEntry[] entries = definition.getParameterDefinitions();
        for (int i = 0; i < entries.length; ++i) {
            ParameterDefinitionEntry entry = entries[i];
            Object oldValue = parameters.get(entry.getName());
            if (oldValue != null) continue;
            parameters.put(entry.getName(), entry.getDefaultValue(wrapper));
        }
        return parameters;
    }
}

