/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.states.datarow.LevelStorage;

public abstract class ExpressionEventHelper {
    private static final Log logger = LogFactory.getLog(ExpressionEventHelper.class);

    protected void fireReportEvent(ReportEvent event) {
        if ((event.getType() & 2) == 2) {
            this.firePageStartedEvent(event);
        } else if ((event.getType() & 0x400) == 1024) {
            this.firePageFinishedEvent(event);
        } else if ((event.getType() & 0x20) == 32) {
            this.fireItemsAdvancedEvent(event);
        } else if ((event.getType() & 0x40) == 64) {
            this.fireItemsFinishedEvent(event);
        } else if ((event.getType() & 0x10) == 16) {
            this.fireItemsStartedEvent(event);
        } else if ((event.getType() & 0x80) == 128) {
            this.fireGroupFinishedEvent(event);
        } else if ((event.getType() & 8) == 8) {
            this.fireGroupStartedEvent(event);
        } else if ((event.getType() & 1) == 1) {
            this.fireReportInitializedEvent(event);
        } else if ((event.getType() & 0x200) == 512) {
            this.fireReportDoneEvent(event);
        } else if ((event.getType() & 0x100) == 256) {
            this.fireReportFinishedEvent(event);
        } else if ((event.getType() & 4) == 4) {
            this.fireReportStartedEvent(event);
        } else if ((event.getType() & 0x800) == 2048) {
            this.fireSummaryRowEvent(event);
        } else if ((event.getType() & 0x8000) != 32768) {
            throw new IllegalArgumentException();
        }
    }

    protected abstract int getRunLevelCount();

    protected abstract LevelStorage getRunLevel(int var1);

    protected abstract ExpressionRuntime getRuntime();

    protected int getProcessingLevel() {
        return this.getRuntime().getProcessingContext().getProcessingLevel();
    }

    private void fireItemsAdvancedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.itemsAdvanced(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire prepare event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire prepare event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireItemsStartedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.itemsStarted(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire prepare event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire prepare event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireItemsFinishedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.itemsFinished(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire prepare event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire prepare event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireGroupStartedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.groupStarted(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire group-started event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire group-started event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireGroupFinishedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.groupFinished(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire group-finished event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire group-finished event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireSummaryRowEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.summaryRowSelection(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire group-finished event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire group-finished event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireReportStartedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.reportStarted(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire report-started event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire report-started event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireReportDoneEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.reportDone(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire report-done event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire report-done event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireReportFinishedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.reportFinished(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire report-finished event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire report-finished event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void fireReportInitializedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof Function) {
                        Function e = (Function)expression;
                        e.reportInitialized(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire report-initialized event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire report-initialized event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void firePageStartedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof PageEventListener) {
                        PageEventListener e = (PageEventListener)((Object)expression);
                        e.pageStarted(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire page-started event", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire page-started event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    private void firePageFinishedEvent(ReportEvent event) {
        LevelStorage levelData;
        int level;
        boolean deepTraversing = event.isDeepTraversing();
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                try {
                    if (expression instanceof PageEventListener) {
                        PageEventListener e = (PageEventListener)((Object)expression);
                        e.pageFinished(event);
                    }
                    this.evaluateSingleExpression(expression);
                }
                catch (InvalidReportStateException rse) {
                    throw rse;
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)"Failed to fire page-finished event: ", (Throwable)ex);
                    } else {
                        logger.error((Object)("Failed to fire page-finished event: " + ex));
                    }
                    this.evaluateToNull(expression);
                }
                expression.setRuntime(oldRuntime);
            }
        }
    }

    protected void reactivateExpressions(boolean deepTraversing) {
        LevelStorage levelData;
        int level;
        int activeLevel = this.getProcessingLevel();
        ExpressionRuntime runtime = this.getRuntime();
        int runlevelCount = this.getRunLevelCount();
        for (int levelIdx = 0; levelIdx < runlevelCount && (level = (levelData = this.getRunLevel(levelIdx)).getLevelNumber()) >= activeLevel; ++levelIdx) {
            Iterator<Expression> expressions = levelData.getActiveExpressions();
            while (expressions.hasNext()) {
                Expression expression = expressions.next();
                if (deepTraversing && !expression.isDeepTraversing()) continue;
                ExpressionRuntime oldRuntime = expression.getRuntime();
                expression.setRuntime(runtime);
                this.evaluateSingleExpression(expression);
                expression.setRuntime(oldRuntime);
            }
        }
    }

    protected void evaluateSingleExpression(Expression expression) {
        Object value;
        int activeLevel = this.getProcessingLevel();
        String name = expression.getName();
        try {
            value = activeLevel <= expression.getDependencyLevel() ? expression.getValue() : null;
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            logger.info((Object)("Evaluation of expression '" + name + "'failed."), (Throwable)e);
            value = null;
        }
        if (name != null) {
            this.updateMasterDataRow(name, value);
        }
    }

    protected void evaluateToNull(Expression expression) {
        String name = expression.getName();
        if (name != null) {
            this.updateMasterDataRow(name, null);
        }
    }

    protected void updateMasterDataRow(String name, Object value) {
    }
}

