/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcNewInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcNewOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.impl.util.orc.OrcUtils;

public class OrcStorage
extends LoadFunc
implements StoreFuncInterface,
LoadMetadata,
LoadPushDown {
    protected RecordReader in = null;
    protected RecordWriter writer = null;
    private TypeInfo typeInfo = null;
    private ObjectInspector oi = null;
    private OrcSerde serde = new OrcSerde();
    private String signature;
    private Long stripeSize;
    private Integer rowIndexStride;
    private Integer bufferSize;
    private Boolean blockPadding;
    private CompressionKind compress;
    private OrcFile.Version version;
    private static final Options validOptions = new Options();
    private final CommandLineParser parser = new GnuParser();
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean[] mRequiredColumns = null;
    private static final String SchemaSignatureSuffix = "_schema";
    private static final String RequiredColumnsSuffix = "_columns";

    public OrcStorage() {
    }

    public OrcStorage(String options) {
        String[] optsArr = options.split(" ");
        try {
            CommandLine configuredOptions = this.parser.parse(validOptions, optsArr);
            if (configuredOptions.hasOption('s')) {
                this.stripeSize = Long.parseLong(configuredOptions.getOptionValue('s'));
            }
            if (configuredOptions.hasOption('r')) {
                this.rowIndexStride = Integer.parseInt(configuredOptions.getOptionValue('r'));
            }
            if (configuredOptions.hasOption('b')) {
                this.bufferSize = Integer.parseInt(configuredOptions.getOptionValue('b'));
            }
            this.blockPadding = configuredOptions.hasOption('p');
            if (configuredOptions.hasOption('c')) {
                this.compress = CompressionKind.valueOf((String)configuredOptions.getOptionValue('c'));
            }
            if (configuredOptions.hasOption('v')) {
                this.version = OrcFile.Version.byName((String)configuredOptions.getOptionValue('v'));
            }
        }
        catch (ParseException e) {
            this.log.error((Object)"Exception in OrcStorage", (Throwable)e);
            this.log.error((Object)("OrcStorage called with arguments " + options));
            this.warn("ParseException in OrcStorage", PigWarning.UDF_WARNING_1);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("OrcStorage(',', '[options]')", validOptions);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath(location, curDir);
    }

    @Override
    public OutputFormat getOutputFormat() throws IOException {
        return new OrcNewOutputFormat();
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        if (!UDFContext.getUDFContext().isFrontend()) {
            if (this.stripeSize != null) {
                job.getConfiguration().setLong(HiveConf.ConfVars.HIVE_ORC_DEFAULT_STRIPE_SIZE.varname, this.stripeSize.longValue());
            }
            if (this.rowIndexStride != null) {
                job.getConfiguration().setInt(HiveConf.ConfVars.HIVE_ORC_DEFAULT_ROW_INDEX_STRIDE.varname, this.rowIndexStride.intValue());
            }
            if (this.bufferSize != null) {
                job.getConfiguration().setInt(HiveConf.ConfVars.HIVE_ORC_DEFAULT_BUFFER_SIZE.varname, this.bufferSize.intValue());
            }
            if (this.blockPadding != null) {
                job.getConfiguration().setBoolean(HiveConf.ConfVars.HIVE_ORC_DEFAULT_BLOCK_PADDING.varname, this.blockPadding.booleanValue());
            }
            if (this.compress != null) {
                job.getConfiguration().set(HiveConf.ConfVars.HIVE_ORC_DEFAULT_COMPRESS.varname, this.compress.toString());
            }
            if (this.version != null) {
                job.getConfiguration().set(HiveConf.ConfVars.HIVE_ORC_WRITE_FORMAT.varname, this.version.toString());
            }
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
        if (this.typeInfo == null) {
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
            this.typeInfo = (TypeInfo)ObjectSerializer.deserialize(p.getProperty(this.signature + SchemaSignatureSuffix));
        }
        if (this.oi == null) {
            this.oi = OrcUtils.createObjectInspector(this.typeInfo);
        }
    }

    @Override
    public void checkSchema(ResourceSchema rs) throws IOException {
        ResourceSchema.ResourceFieldSchema fs = new ResourceSchema.ResourceFieldSchema();
        fs.setType((byte)110);
        fs.setSchema(rs);
        this.typeInfo = OrcUtils.getTypeInfo(fs);
        Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
        p.setProperty(this.signature + SchemaSignatureSuffix, ObjectSerializer.serialize((Serializable)this.typeInfo));
    }

    @Override
    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
    }

    @Override
    public void putNext(Tuple t) throws IOException {
        try {
            this.writer.write(null, (Object)this.serde.serialize((Object)t, this.oi));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setStoreFuncUDFContextSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl(location, job);
    }

    @Override
    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
        if (!UDFContext.getUDFContext().isFrontend()) {
            this.typeInfo = (TypeInfo)ObjectSerializer.deserialize(p.getProperty(this.signature + SchemaSignatureSuffix));
        }
        if (this.typeInfo != null && this.oi == null) {
            this.oi = OrcStruct.createObjectInspector((TypeInfo)this.typeInfo);
        }
        if (!UDFContext.getUDFContext().isFrontend() && p.getProperty(this.signature + RequiredColumnsSuffix) != null) {
            this.mRequiredColumns = (boolean[])ObjectSerializer.deserialize(p.getProperty(this.signature + RequiredColumnsSuffix));
            job.getConfiguration().setBoolean("hive.io.file.read.all.columns", false);
            job.getConfiguration().set("hive.io.file.readcolumn.ids", OrcStorage.getReqiredColumnIdString(this.mRequiredColumns));
        }
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    private static String getReqiredColumnIdString(boolean[] requiredColumns) {
        String result = "";
        for (int i = 0; i < requiredColumns.length; ++i) {
            if (!requiredColumns[i]) continue;
            result = result + i;
            result = result + ",";
        }
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Override
    public InputFormat getInputFormat() throws IOException {
        return new OrcNewInputFormat();
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.in = reader;
    }

    @Override
    public Tuple getNext() throws IOException {
        try {
            boolean notDone = this.in.nextKeyValue();
            if (!notDone) {
                return null;
            }
            Object value = this.in.getCurrentValue();
            Tuple t = (Tuple)OrcUtils.convertOrcToPig(value, this.oi, this.mRequiredColumns);
            return t;
        }
        catch (InterruptedException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, e);
        }
    }

    private static Path getFirstFile(String location, FileSystem fs) throws IOException {
        String[] locations = OrcStorage.getPathStrings(location);
        Path[] paths = new Path[locations.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = new Path(locations[i]);
        }
        ArrayList<FileStatus> statusList = new ArrayList<FileStatus>();
        for (int i = 0; i < paths.length; ++i) {
            for (FileStatus tempf : fs.globStatus(paths[i])) {
                statusList.add(tempf);
            }
        }
        FileStatus[] statusArray = statusList.toArray(new FileStatus[statusList.size()]);
        Path p = Utils.depthFirstSearchForFile(statusArray, fs);
        return p;
    }

    private static TypeInfo getTypeInfoFromLocation(String location, Job job) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)job.getConfiguration());
        Path path = OrcStorage.getFirstFile(location, fs);
        if (path == null) {
            throw new IOException("Cannot find any ORC files from " + location);
        }
        Reader reader = OrcFile.createReader((FileSystem)fs, (Path)path);
        ObjectInspector oip = reader.getObjectInspector();
        return TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oip);
    }

    @Override
    public ResourceSchema getSchema(String location, Job job) throws IOException {
        if (this.typeInfo == null) {
            this.typeInfo = OrcStorage.getTypeInfoFromLocation(location, job);
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
            p.setProperty(this.signature + SchemaSignatureSuffix, ObjectSerializer.serialize((Serializable)this.typeInfo));
        }
        ResourceSchema.ResourceFieldSchema fs = OrcUtils.getResourceFieldSchema(this.typeInfo);
        return fs.getSchema();
    }

    @Override
    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    @Override
    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        if (requiredFieldList == null) {
            return null;
        }
        if (requiredFieldList.getFields() != null) {
            int schemaSize = ((StructTypeInfo)this.typeInfo).getAllStructFieldTypeInfos().size();
            this.mRequiredColumns = new boolean[schemaSize];
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() == -1) continue;
                this.mRequiredColumns[rf.getIndex()] = true;
            }
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
            try {
                p.setProperty(this.signature + RequiredColumnsSuffix, ObjectSerializer.serialize((Serializable)this.mRequiredColumns));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot serialize mRequiredColumns");
            }
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    static {
        validOptions.addOption("s", "stripeSize", true, "Set the stripe size for the file");
        validOptions.addOption("r", "rowIndexStride", true, "Set the distance between entries in the row index");
        validOptions.addOption("b", "bufferSize", true, "The size of the memory buffers used for compressing and storing the stripe in memory");
        validOptions.addOption("p", "blockPadding", false, "Sets whether the HDFS blocks are padded to prevent stripes from straddling blocks");
        validOptions.addOption("c", "compress", true, "Sets the generic compression that is used to compress the data");
        validOptions.addOption("v", "version", true, "Sets the version of the file that will be written");
    }
}

