/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.Serializable;
import org.apache.pig.FuncSpec;
import org.apache.pig.builtin.PigStorage;

public class FileSpec
implements Serializable {
    private static final long serialVersionUID = 2L;
    String fileName;
    FuncSpec funcSpec;

    public FileSpec(String fileName, FuncSpec funcSpec) {
        this.fileName = fileName;
        this.funcSpec = funcSpec != null ? funcSpec : new FuncSpec(PigStorage.class.getName() + "()");
    }

    public String getFileName() {
        return this.fileName;
    }

    public FuncSpec getFuncSpec() {
        return this.funcSpec;
    }

    public String toString() {
        return this.fileName + ":" + this.funcSpec;
    }

    public String getFuncName() {
        return this.funcSpec.getClassName();
    }

    public int getSize() {
        throw new UnsupportedOperationException("File Size not implemented yet");
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof FileSpec) {
            FileSpec ofs = (FileSpec)other;
            if (!this.fileName.equals(ofs.fileName)) {
                return false;
            }
            return this.funcSpec.equals(ofs.funcSpec);
        }
        return false;
    }

    public int hashCode() {
        return this.getFuncName().hashCode() + this.fileName.hashCode();
    }
}

