/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalPlan;

public class LogicalPlanData {
    private final LogicalPlan lp;

    public LogicalPlanData(LogicalPlan lp) {
        if (lp == null) {
            throw new RuntimeException("LogicalPlan is null.");
        }
        this.lp = lp;
    }

    public List<String> getSources() {
        List<LOLoad> sources = this.getLOLoads();
        if (sources == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (LOLoad load : sources) {
            result.add(load.getFileSpec().getFileName());
        }
        return result;
    }

    public List<String> getSinks() {
        List<LOStore> sinks = this.getLOStores();
        if (sinks == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (LOStore sink : sinks) {
            result.add(sink.getFileSpec().getFileName());
        }
        return result;
    }

    public List<String> getLoadFuncs() {
        List<LOLoad> sources = this.getLOLoads();
        if (sources == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (LOLoad load : sources) {
            result.add(load.getFileSpec().getFuncName());
        }
        return result;
    }

    public List<String> getStoreFuncs() {
        List<LOStore> sinks = this.getLOStores();
        if (sinks == null) {
            return null;
        }
        ArrayList<String> storeFuncs = new ArrayList<String>();
        for (LOStore sink : sinks) {
            storeFuncs.add(sink.getFileSpec().getFuncName());
        }
        return storeFuncs;
    }

    private List<LOLoad> getLOLoads() {
        List<Operator> sources = this.lp.getSources();
        if (sources == null) {
            return null;
        }
        ArrayList<LOLoad> result = new ArrayList<LOLoad>();
        for (Operator source : sources) {
            if (!(source instanceof LOLoad)) continue;
            LOLoad load = (LOLoad)source;
            result.add(load);
        }
        return result;
    }

    private List<LOStore> getLOStores() {
        List<Operator> sinks = this.lp.getSinks();
        if (sinks == null) {
            return null;
        }
        ArrayList<LOStore> result = new ArrayList<LOStore>();
        for (Operator sink : sinks) {
            if (!(sink instanceof LOStore)) continue;
            LOStore store = (LOStore)sink;
            result.add(store);
        }
        return result;
    }
}

