/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.optimizer.AllExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.visitor.ProjExpanderForForeach;
import org.apache.pig.newplan.logical.visitor.ProjExpanderForNonForeach;

public class ProjStarInUdfExpander
extends AllExpressionVisitor {
    public ProjStarInUdfExpander(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    @Override
    protected LogicalExpressionVisitor getVisitor(LogicalExpressionPlan exprPlan) throws FrontendException {
        return new ProjExpanderForNonForeach(exprPlan);
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        LogicalPlan innerPlan = foreach.getInnerPlan();
        PlanWalker newWalker = this.currentWalker.spawnChildWalker(innerPlan);
        this.pushWalker(newWalker);
        this.currentWalker.walk(this);
        this.popWalker();
        List<Operator> feOutputs = innerPlan.getSinks();
        LOGenerate gen = null;
        for (Operator op : feOutputs) {
            if (!(op instanceof LOGenerate)) continue;
            if (gen != null) {
                String msg = "Expected single LOGenerate output in innerplan of foreach";
                throw new VisitorException((Operator)foreach, msg, 2266, 4);
            }
            gen = (LOGenerate)op;
        }
        List<Operator> loGenPreds = innerPlan.getPredecessors(gen);
        if (loGenPreds == null) {
            return;
        }
        HashMap<Integer, LogicalRelationalOperator> oldPos2Rel = new HashMap<Integer, LogicalRelationalOperator>();
        for (int i = 0; i < loGenPreds.size(); ++i) {
            oldPos2Rel.put(i, (LogicalRelationalOperator)loGenPreds.get(i));
        }
        HashMap<ProjectExpression, LogicalRelationalOperator> proj2InpRel = new HashMap<ProjectExpression, LogicalRelationalOperator>();
        ArrayList<LOInnerLoad> expandedInLoads = new ArrayList<LOInnerLoad>();
        for (LogicalExpressionPlan plan : gen.getOutputPlans()) {
            ProjExpanderForForeach projExpander = new ProjExpanderForForeach(plan, gen, oldPos2Rel, proj2InpRel, foreach, expandedInLoads);
            projExpander.visit();
        }
        for (LOInnerLoad inLoad : expandedInLoads) {
            innerPlan.disconnect(inLoad, gen);
            innerPlan.remove(inLoad);
        }
        HashMap<LogicalRelationalOperator, Integer> rel2pos = new HashMap<LogicalRelationalOperator, Integer>();
        List<Operator> newGenPreds = innerPlan.getPredecessors(gen);
        int numNewGenPreds = 0;
        if (newGenPreds != null) {
            numNewGenPreds = newGenPreds.size();
        }
        for (int i = 0; i < numNewGenPreds; ++i) {
            rel2pos.put((LogicalRelationalOperator)newGenPreds.get(i), i);
        }
        for (Map.Entry projAndInp : proj2InpRel.entrySet()) {
            ProjectExpression proj = (ProjectExpression)projAndInp.getKey();
            LogicalRelationalOperator rel = (LogicalRelationalOperator)projAndInp.getValue();
            proj.setInputNum((Integer)rel2pos.get(rel));
        }
    }

    @Override
    public void visit(LOGenerate gen) throws FrontendException {
    }
}

