/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigException;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.HExecutionEngine;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.pen.AugmentBaseDataVisitor;
import org.apache.pig.pen.EquivalenceClasses;
import org.apache.pig.pen.IllustratorAttacher;
import org.apache.pig.pen.LineageTrimmingVisitor;
import org.apache.pig.pen.LocalMapReduceSimulator;
import org.apache.pig.pen.PhysicalPlanResetter;
import org.apache.pig.pen.util.DisplayExamples;
import org.apache.pig.pen.util.LineageTracer;

public class ExampleGenerator {
    LogicalPlan plan;
    LogicalPlan newPlan;
    Map<LOLoad, DataBag> baseData = null;
    PigContext pigContext;
    PhysicalPlan physPlan;
    PhysicalPlanResetter physPlanReseter;
    private HExecutionEngine execEngine;
    private LocalMapReduceSimulator localMRRunner;
    Log log = LogFactory.getLog(this.getClass());
    private int MAX_RECORDS = 10000;
    private Map<org.apache.pig.newplan.Operator, PhysicalOperator> logToPhyMap;
    private Map<PhysicalOperator, org.apache.pig.newplan.Operator> poLoadToLogMap;
    private Map<PhysicalOperator, org.apache.pig.newplan.Operator> poToLogMap;
    private HashMap<PhysicalOperator, Collection<IdentityHashSet<Tuple>>> poToEqclassesMap;
    private LineageTracer lineage;
    private Map<org.apache.pig.newplan.Operator, DataBag> logToDataMap = null;
    private Map<LOForEach, Map<LogicalRelationalOperator, DataBag>> forEachInnerLogToDataMap;
    Map<LOForEach, Map<LogicalRelationalOperator, PhysicalOperator>> forEachInnerLogToPhyMap;
    Map<LOLimit, Long> oriLimitMap = null;
    Map<POLoad, LogicalSchema> poLoadToSchemaMap;

    public ExampleGenerator(LogicalPlan plan, PigContext hadoopPigContext) {
        this.plan = plan;
        this.pigContext = hadoopPigContext;
        FileLocalizer.setInitialized(false);
        try {
            this.pigContext.connect();
        }
        catch (ExecException e) {
            this.log.error((Object)("Error connecting to the cluster " + e.getLocalizedMessage()));
        }
        this.execEngine = new HExecutionEngine(this.pigContext);
        this.localMRRunner = new LocalMapReduceSimulator();
        this.poLoadToSchemaMap = new HashMap<POLoad, LogicalSchema>();
    }

    public LineageTracer getLineage() {
        return this.lineage;
    }

    public Map<org.apache.pig.newplan.Operator, PhysicalOperator> getLogToPhyMap() {
        return this.logToPhyMap;
    }

    public void setMaxRecords(int max) {
        this.MAX_RECORDS = max;
    }

    public Map<org.apache.pig.newplan.Operator, DataBag> getExamples() throws IOException, InterruptedException {
        if (this.pigContext.getProperties().getProperty("pig.usenewlogicalplan", "true").equals("false")) {
            throw new ExecException("ILLUSTRATE must use the new logical plan!");
        }
        this.pigContext.inIllustrator = true;
        this.physPlan = this.compilePlan(this.plan);
        this.physPlanReseter = new PhysicalPlanResetter(this.physPlan);
        List<org.apache.pig.newplan.Operator> loads = this.newPlan.getSources();
        List pRoots = this.physPlan.getRoots();
        if (loads.size() != pRoots.size()) {
            throw new ExecException("Logical and Physical plans have different number of roots");
        }
        this.logToPhyMap = this.execEngine.getLogToPhyMap();
        this.forEachInnerLogToPhyMap = this.execEngine.getForEachInnerLogToPhyMap(this.plan);
        this.poLoadToLogMap = new HashMap<PhysicalOperator, org.apache.pig.newplan.Operator>();
        this.logToDataMap = new HashMap<org.apache.pig.newplan.Operator, DataBag>();
        this.poToLogMap = new HashMap<PhysicalOperator, org.apache.pig.newplan.Operator>();
        this.forEachInnerLogToDataMap = new HashMap<LOForEach, Map<LogicalRelationalOperator, DataBag>>();
        for (Map.Entry<LOForEach, Map<LogicalRelationalOperator, PhysicalOperator>> entry : this.forEachInnerLogToPhyMap.entrySet()) {
            HashMap innerMap = new HashMap();
            this.forEachInnerLogToDataMap.put(entry.getKey(), innerMap);
        }
        for (org.apache.pig.newplan.Operator load : loads) {
            this.poLoadToLogMap.put(this.logToPhyMap.get(load), load);
        }
        boolean hasLimit = false;
        for (org.apache.pig.newplan.Operator lo : this.logToPhyMap.keySet()) {
            this.poToLogMap.put(this.logToPhyMap.get(lo), lo);
            if (hasLimit || !(lo instanceof LOLimit)) continue;
            hasLimit = true;
        }
        try {
            this.readBaseData(loads);
        }
        catch (ExecException e) {
            this.log.error((Object)("Error reading data. " + e.getMessage()));
            throw e;
        }
        catch (FrontendException e) {
            this.log.error((Object)("Error reading data. " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
        Map<org.apache.pig.newplan.Operator, DataBag> derivedData = null;
        LineageTrimmingVisitor trimmer = new LineageTrimmingVisitor(this.newPlan, this.baseData, this, this.logToPhyMap, this.physPlan, this.pigContext);
        trimmer.visit();
        this.baseData = trimmer.getBaseData();
        derivedData = this.getData(this.physPlan);
        AugmentBaseDataVisitor augment = new AugmentBaseDataVisitor(this.newPlan, this.logToPhyMap, this.baseData, derivedData);
        augment.visit();
        this.baseData = augment.getNewBaseData();
        trimmer = new LineageTrimmingVisitor(this.newPlan, this.baseData, this, this.logToPhyMap, this.physPlan, this.pigContext);
        trimmer.visit();
        this.baseData = trimmer.getBaseData();
        derivedData = this.getData(this.physPlan);
        if (hasLimit) {
            augment.setLimit();
            augment.visit();
            this.baseData = augment.getNewBaseData();
            this.oriLimitMap = augment.getOriLimitMap();
            derivedData = this.getData();
        }
        System.out.println(DisplayExamples.printTabular(this.newPlan, derivedData, this.forEachInnerLogToDataMap));
        this.pigContext.inIllustrator = false;
        return derivedData;
    }

    private void readBaseData(List<org.apache.pig.newplan.Operator> loads) throws IOException, InterruptedException, FrontendException, ExecException {
        PhysicalPlan thisPhyPlan = new PhysicalPlan();
        for (org.apache.pig.newplan.Operator op : loads) {
            LogicalSchema schema = ((LOLoad)op).getSchema();
            if (schema == null) {
                throw new ExecException("Example Generator requires a schema. Please provide a schema while loading data.");
            }
            this.poLoadToSchemaMap.put((POLoad)this.logToPhyMap.get(op), schema);
            thisPhyPlan.add((Operator)this.logToPhyMap.get(op));
        }
        this.baseData = null;
        Map<org.apache.pig.newplan.Operator, DataBag> result = this.getData(thisPhyPlan);
        this.baseData = new HashMap<LOLoad, DataBag>();
        for (org.apache.pig.newplan.Operator lo : result.keySet()) {
            if (!(lo instanceof LOLoad)) continue;
            this.baseData.put((LOLoad)lo, result.get(lo));
        }
    }

    PhysicalPlan compilePlan(LogicalPlan plan) throws ExecException, FrontendException {
        PhysicalPlan result = this.execEngine.compile(plan, null);
        this.newPlan = this.execEngine.getNewPlan();
        return result;
    }

    public Map<org.apache.pig.newplan.Operator, DataBag> getData() throws IOException, InterruptedException {
        return this.getData(this.physPlan);
    }

    private Map<org.apache.pig.newplan.Operator, DataBag> getData(PhysicalPlan plan) throws PigException, IOException, InterruptedException {
        this.lineage = new LineageTracer();
        IllustratorAttacher attacher = new IllustratorAttacher(plan, this.lineage, this.MAX_RECORDS, this.poLoadToSchemaMap, this.pigContext);
        attacher.visit();
        if (this.oriLimitMap != null) {
            for (Map.Entry<LOLimit, Long> entry : this.oriLimitMap.entrySet()) {
                this.logToPhyMap.get(entry.getKey()).getIllustrator().setOriginalLimit(entry.getValue());
            }
        }
        this.getLogToDataMap(attacher.getDataMap());
        if (this.baseData != null) {
            this.setLoadDataMap();
            this.physPlanReseter.visit();
        }
        this.localMRRunner.launchPig(plan, this.baseData, this.lineage, attacher, this, this.pigContext);
        if (this.baseData == null) {
            this.poToEqclassesMap = attacher.poToEqclassesMap;
        } else {
            for (Map.Entry<Object, Object> entry : attacher.poToEqclassesMap.entrySet()) {
                if (entry.getKey() instanceof POLoad) continue;
                this.poToEqclassesMap.put((PhysicalOperator)entry.getKey(), (Collection<IdentityHashSet<Tuple>>)entry.getValue());
            }
        }
        if (this.baseData != null) {
            this.phyToMRTransform(plan, attacher.getDataMap());
        }
        return this.logToDataMap;
    }

    public Map<org.apache.pig.newplan.Operator, DataBag> getData(Map<LOLoad, DataBag> newBaseData) throws Exception {
        this.baseData = newBaseData;
        return this.getData(this.physPlan);
    }

    private void phyToMRTransform(PhysicalPlan plan, Map<PhysicalOperator, DataBag> phyToDataMap) {
        Map<PhysicalOperator, PhysicalOperator> phyToMRMap = this.localMRRunner.getPhyToMRMap();
        for (Map.Entry<PhysicalOperator, org.apache.pig.newplan.Operator> entry : this.poToLogMap.entrySet()) {
            if (phyToMRMap.get(entry.getKey()) == null) continue;
            PhysicalOperator poInMR = phyToMRMap.get(entry.getKey());
            this.logToDataMap.put(entry.getValue(), phyToDataMap.get(poInMR));
            this.poToEqclassesMap.put(entry.getKey(), this.poToEqclassesMap.get(poInMR));
        }
    }

    private void getLogToDataMap(Map<PhysicalOperator, DataBag> phyToDataMap) {
        this.logToDataMap.clear();
        for (org.apache.pig.newplan.Operator operator : this.logToPhyMap.keySet()) {
            if (this.logToPhyMap.get(operator) == null) continue;
            this.logToDataMap.put(operator, phyToDataMap.get(this.logToPhyMap.get(operator)));
        }
        for (Map.Entry entry : this.forEachInnerLogToDataMap.entrySet()) {
            ((Map)entry.getValue()).clear();
            for (Map.Entry<LogicalRelationalOperator, PhysicalOperator> innerEntry : this.forEachInnerLogToPhyMap.get(entry.getKey()).entrySet()) {
                ((Map)entry.getValue()).put(innerEntry.getKey(), phyToDataMap.get(innerEntry.getValue()));
            }
        }
    }

    private void setLoadDataMap() {
        if (this.baseData != null) {
            if (this.poToEqclassesMap == null) {
                this.poToEqclassesMap = new HashMap();
            } else {
                this.poToEqclassesMap.clear();
            }
            for (LOLoad lo : this.baseData.keySet()) {
                this.logToDataMap.get(lo).addAll(this.baseData.get(lo));
                LinkedList equivalenceClasses = new LinkedList();
                IdentityHashSet<Tuple> equivalenceClass = new IdentityHashSet<Tuple>();
                equivalenceClasses.add(equivalenceClass);
                for (Tuple t : this.baseData.get(lo)) {
                    this.lineage.insert(t);
                    equivalenceClass.add(t);
                }
                this.poToEqclassesMap.put(this.logToPhyMap.get(lo), equivalenceClasses);
            }
        }
    }

    public Collection<IdentityHashSet<Tuple>> getEqClasses() {
        Map<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> logToEqclassesMap = this.getLoToEqClassMap();
        LinkedList<IdentityHashSet<Tuple>> ret = new LinkedList<IdentityHashSet<Tuple>>();
        for (Map.Entry<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> entry : logToEqclassesMap.entrySet()) {
            if (entry.getValue() == null) continue;
            ret.addAll(entry.getValue());
        }
        return ret;
    }

    public Map<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> getLoToEqClassMap() {
        Map<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> ret = EquivalenceClasses.getLoToEqClassMap(this.physPlan, this.newPlan, this.logToPhyMap, this.logToDataMap, this.forEachInnerLogToPhyMap, this.poToEqclassesMap);
        for (Map.Entry<LogicalRelationalOperator, Collection<IdentityHashSet<Tuple>>> entry : ret.entrySet()) {
            if (!(entry.getKey() instanceof LOSort)) continue;
            Collection<IdentityHashSet<Tuple>> eqClasses = entry.getValue();
            Iterator<IdentityHashSet<Tuple>> it = eqClasses.iterator();
            while (it.hasNext()) {
                Tuple t = null;
                IdentityHashSet<Tuple> eqClass = it.next();
                if (eqClass.size() == 1) {
                    eqClass.clear();
                    continue;
                }
                boolean first = true;
                boolean allIdentical = true;
                Iterator<Tuple> it1 = eqClass.iterator();
                while (it1.hasNext()) {
                    if (first) {
                        first = false;
                        t = it1.next();
                        continue;
                    }
                    if (it1.next().equals(t)) continue;
                    allIdentical = false;
                    break;
                }
                if (!allIdentical) continue;
                eqClass.clear();
            }
        }
        return ret;
    }
}

