/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.deleteresultfilenames;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryDeleteResultFilenames
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryDeleteResultFilenames.class;
    private String foldername = null;
    private boolean specifywildcard = false;
    private String wildcard = null;
    private String wildcardexclude = null;

    public JobEntryDeleteResultFilenames(String n) {
        super(n, "");
    }

    public JobEntryDeleteResultFilenames() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryDeleteResultFilenames je = (JobEntryDeleteResultFilenames)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"foldername", (String)this.foldername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"specify_wildcard", (boolean)this.specifywildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardexclude));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.foldername = XMLHandler.getTagValue((Node)entrynode, (String)"foldername");
            this.specifywildcard = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"specify_wildcard"));
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardexclude = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryDeleteResultFilenames.CanNotLoadFromXML", (String[])new String[]{xe.getMessage()}));
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.foldername = rep.getJobEntryAttributeString(id_jobentry, "foldername");
            this.specifywildcard = rep.getJobEntryAttributeBoolean(id_jobentry, "specify_wildcard");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.wildcardexclude = rep.getJobEntryAttributeString(id_jobentry, "wildcardexclude");
        }
        catch (KettleException dbe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryDeleteResultFilenames.CanNotLoadFromRep", (String[])new String[]{"" + id_jobentry, dbe.getMessage()}));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "foldername", this.foldername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "specify_wildcard", this.specifywildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcardexclude", this.wildcardexclude);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryDeleteResultFilenames.CanNotSaveToRep", (String[])new String[]{"" + id_job, dbe.getMessage()}));
        }
    }

    public void setSpecifyWildcard(boolean specifywildcard) {
        this.specifywildcard = specifywildcard;
    }

    public boolean isSpecifyWildcard() {
        return this.specifywildcard;
    }

    public void setFoldername(String foldername) {
        this.foldername = foldername;
    }

    public String getFoldername() {
        return this.foldername;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardexclude;
    }

    public String getRealWildcard() {
        return this.environmentSubstitute(this.getWildcard());
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardexclude) {
        this.wildcardexclude = wildcardexclude;
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (previousResult != null) {
            try {
                int size = previousResult.getResultFiles().size();
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDeleteResultFilenames.log.FilesFound", (String[])new String[]{"" + size}));
                }
                if (!this.specifywildcard) {
                    previousResult.getResultFiles().clear();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteResultFilenames.log.DeletedFiles", (String[])new String[]{"" + size}));
                    }
                } else {
                    List resultFiles = result.getResultFilesList();
                    if (resultFiles != null && resultFiles.size() > 0) {
                        Iterator it = resultFiles.iterator();
                        while (it.hasNext() && !this.parentJob.isStopped()) {
                            ResultFile resultFile = (ResultFile)it.next();
                            FileObject file = resultFile.getFile();
                            if (file == null || !file.exists() || !this.CheckFileWildcard(file.getName().getBaseName(), this.environmentSubstitute(this.wildcard), true) || this.CheckFileWildcard(file.getName().getBaseName(), this.environmentSubstitute(this.wildcardexclude), false)) continue;
                            result.getResultFiles().remove(resultFile.getFile().toString());
                            if (!this.log.isDetailed()) continue;
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteResultFilenames.log.DeletedFile", (String[])new String[]{file.toString()}));
                        }
                    }
                }
                result.setResult(true);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteResultFilenames.Error", (String[])new String[]{e.toString()}));
            }
        }
        return result;
    }

    private boolean CheckFileWildcard(String selectedfile, String wildcard, boolean include) {
        Pattern pattern = null;
        boolean getIt = include;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
    }
}

