/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftp.MVSFileParser;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryFTP
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFTP.class;
    private String serverName = null;
    private String userName;
    private String password;
    private String ftpDirectory;
    private String targetDirectory;
    private String wildcard;
    private boolean binaryMode;
    private int timeout;
    private boolean remove;
    private boolean onlyGettingNewFiles;
    private boolean activeConnection;
    private String controlEncoding;
    private static String LEGACY_CONTROL_ENCODING = "US-ASCII";
    private static String DEFAULT_CONTROL_ENCODING = "ISO-8859-1";
    private boolean movefiles = false;
    private String movetodirectory = null;
    private boolean adddate = false;
    private boolean addtime = false;
    private boolean SpecifyFormat = false;
    private String date_time_format;
    private boolean AddDateBeforeExtension = false;
    private boolean isaddresult = true;
    private boolean createmovefolder = false;
    private String port = "21";
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String socksProxyHost;
    private String socksProxyPort = "1080";
    private String socksProxyUsername;
    private String socksProxyPassword;
    public int ifFileExistsSkip = 0;
    public String SifFileExistsSkip = "ifFileExistsSkip";
    public int ifFileExistsCreateUniq = 1;
    public String SifFileExistsCreateUniq = "ifFileExistsCreateUniq";
    public int ifFileExistsFail = 2;
    public String SifFileExistsFail = "ifFileExistsFail";
    public int ifFileExists;
    public String SifFileExists;
    public String SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String nr_limit = "10";
    private String success_condition = this.SUCCESS_IF_NO_ERRORS;
    long NrErrors = 0L;
    long NrfilesRetrieved = 0L;
    boolean successConditionBroken = false;
    int limitFiles = 0;
    String targetFilename = null;
    static String FILE_SEPARATOR = "/";

    public JobEntryFTP(String n) {
        super(n, "");
        this.ifFileExists = this.ifFileExistsSkip;
        this.SifFileExists = this.SifFileExistsSkip;
        this.setControlEncoding(DEFAULT_CONTROL_ENCODING);
    }

    public JobEntryFTP() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFTP je = (JobEntryFTP)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ftpdirectory", (String)this.ftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetdirectory", (String)this.targetDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"binary", (boolean)this.binaryMode));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_new", (boolean)this.onlyGettingNewFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        retval.append("      ").append(XMLHandler.addTagValue((String)"control_encoding", (String)this.controlEncoding));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movefiles", (boolean)this.movefiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movetodirectory", (String)this.movetodirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"adddate", (boolean)this.adddate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addtime", (boolean)this.addtime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.AddDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createmovefolder", (boolean)this.createmovefolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_host", (String)this.socksProxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_port", (String)this.socksProxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_username", (String)this.socksProxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"socksproxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.socksProxyPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ifFileExists", (String)this.SifFileExists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_limit", (String)this.nr_limit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.ftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"ftpdirectory");
            this.targetDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"targetdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.binaryMode = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"binary"));
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.onlyGettingNewFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.activeConnection = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"active"));
            this.controlEncoding = XMLHandler.getTagValue((Node)entrynode, (String)"control_encoding");
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
            this.movefiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"movefiles"));
            this.movetodirectory = XMLHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.adddate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addtime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.AddDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            String addresult = XMLHandler.getTagValue((Node)entrynode, (String)"isaddresult");
            this.isaddresult = Const.isEmpty((String)addresult) ? true : "Y".equalsIgnoreCase(addresult);
            this.createmovefolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createmovefolder"));
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"proxy_password"));
            this.socksProxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_host");
            this.socksProxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_port");
            this.socksProxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_username");
            this.socksProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"socksproxy_password"));
            this.SifFileExists = XMLHandler.getTagValue((Node)entrynode, (String)"ifFileExists");
            this.ifFileExists = Const.isEmpty((String)this.SifFileExists) ? this.ifFileExistsSkip : (this.SifFileExists.equals(this.SifFileExistsCreateUniq) ? this.ifFileExistsCreateUniq : (this.SifFileExists.equals(this.SifFileExistsFail) ? this.ifFileExistsFail : this.ifFileExistsSkip));
            this.nr_limit = XMLHandler.getTagValue((Node)entrynode, (String)"nr_limit");
            this.success_condition = Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"success_condition"), (String)this.SUCCESS_IF_NO_ERRORS);
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'ftp' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.ftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "ftpdirectory");
            this.targetDirectory = rep.getJobEntryAttributeString(id_jobentry, "targetdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.binaryMode = rep.getJobEntryAttributeBoolean(id_jobentry, "binary");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            this.onlyGettingNewFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "only_new");
            this.activeConnection = rep.getJobEntryAttributeBoolean(id_jobentry, "active");
            this.controlEncoding = rep.getJobEntryAttributeString(id_jobentry, "control_encoding");
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
            this.movefiles = rep.getJobEntryAttributeBoolean(id_jobentry, "movefiles");
            this.movetodirectory = rep.getJobEntryAttributeString(id_jobentry, "movetodirectory");
            this.adddate = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.addtime = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.AddDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDateBeforeExtension");
            String addToResult = rep.getStepAttributeString(id_jobentry, "add_to_result_filenames");
            this.isaddresult = Const.isEmpty((String)addToResult) ? true : rep.getStepAttributeBoolean(id_jobentry, "add_to_result_filenames");
            this.createmovefolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createmovefolder");
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "proxy_password"));
            this.socksProxyHost = rep.getJobEntryAttributeString(id_jobentry, "socksproxy_host");
            this.socksProxyPort = rep.getJobEntryAttributeString(id_jobentry, "socksproxy_port");
            this.socksProxyUsername = rep.getJobEntryAttributeString(id_jobentry, "socksproxy_username");
            this.socksProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "socksproxy_password"));
            this.SifFileExists = rep.getJobEntryAttributeString(id_jobentry, "ifFileExists");
            this.ifFileExists = Const.isEmpty((String)this.SifFileExists) ? this.ifFileExistsSkip : (this.SifFileExists.equals(this.SifFileExistsCreateUniq) ? this.ifFileExistsCreateUniq : (this.SifFileExists.equals(this.SifFileExistsFail) ? this.ifFileExistsFail : this.ifFileExistsSkip));
            this.nr_limit = rep.getJobEntryAttributeString(id_jobentry, "nr_limit");
            this.success_condition = Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "success_condition"), (String)this.SUCCESS_IF_NO_ERRORS);
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'ftp' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ftpdirectory", this.ftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "targetdirectory", this.targetDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "binary", this.binaryMode);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "remove", this.remove);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "only_new", this.onlyGettingNewFiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "active", this.activeConnection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "control_encoding", this.controlEncoding);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "movefiles", this.movefiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "movetodirectory", this.movetodirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addtime", this.addtime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "adddate", this.adddate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "AddDateBeforeExtension", this.AddDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "isaddresult", this.isaddresult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createmovefolder", this.createmovefolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_host", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_username", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_host", this.socksProxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_port", this.socksProxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_username", this.socksProxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "socksproxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.socksProxyPassword));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ifFileExists", this.SifFileExists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_limit", this.nr_limit);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'ftp' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setLimit(String nr_limitin) {
        this.nr_limit = nr_limitin;
    }

    public String getLimit() {
        return this.nr_limit;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setCreateMoveFolder(boolean createmovefolderin) {
        this.createmovefolder = createmovefolderin;
    }

    public boolean isCreateMoveFolder() {
        return this.createmovefolder;
    }

    public void setAddDateBeforeExtension(boolean AddDateBeforeExtension) {
        this.AddDateBeforeExtension = AddDateBeforeExtension;
    }

    public boolean isAddDateBeforeExtension() {
        return this.AddDateBeforeExtension;
    }

    public void setAddToResult(boolean isaddresultin) {
        this.isaddresult = isaddresultin;
    }

    public boolean isAddToResult() {
        return this.isaddresult;
    }

    public void setDateInFilename(boolean adddate) {
        this.adddate = adddate;
    }

    public boolean isDateInFilename() {
        return this.adddate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addtime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addtime;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public boolean isMoveFiles() {
        return this.movefiles;
    }

    public void setMoveFiles(boolean movefilesin) {
        this.movefiles = movefilesin;
    }

    public String getMoveToDirectory() {
        return this.movetodirectory;
    }

    public void setMoveToDirectory(String movetoin) {
        this.movetodirectory = movetoin;
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public void setFtpDirectory(String directory) {
        this.ftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public boolean isOnlyGettingNewFiles() {
        return this.onlyGettingNewFiles;
    }

    public void setOnlyGettingNewFiles(boolean onlyGettingNewFilesin) {
        this.onlyGettingNewFiles = onlyGettingNewFilesin;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String encoding) {
        this.controlEncoding = encoding;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setSocksProxyPassword(String socksProxyPassword) {
        this.socksProxyPassword = socksProxyPassword;
    }

    public String getSocksProxyPassword() {
        return this.socksProxyPassword;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getSocksProxyUsername() {
        return this.socksProxyUsername;
    }

    public void setSocksProxyUsername(String socksPoxyUsername) {
        this.socksProxyUsername = socksPoxyUsername;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.socksProxyHost = socksProxyHost;
    }

    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.socksProxyPort = socksProxyPort;
    }

    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    protected FTPClient initFTPClient() {
        return new FTPClient();
    }

    protected InetAddress getInetAddress(String realServername) throws UnknownHostException {
        return InetAddress.getByName(realServername);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        boolean exitjobentry;
        Result result;
        block65: {
            FTPClient ftpclient;
            block63: {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"JobEntryFTP.Started", (String[])new String[]{this.serverName}));
                result = previousResult;
                result.setNrErrors(1L);
                result.setResult(false);
                this.NrErrors = 0L;
                this.NrfilesRetrieved = 0L;
                this.successConditionBroken = false;
                exitjobentry = false;
                this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimit()), (int)10);
                if (this.movefiles && Const.isEmpty((String)this.movetodirectory)) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTP.MoveToFolderEmpty", (String[])new String[0]));
                    return result;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.Start", (String[])new String[0]));
                }
                ftpclient = null;
                String realMoveToFolder = null;
                ftpclient = this.initFTPClient();
                String realServername = this.environmentSubstitute(this.serverName);
                String realServerPort = this.environmentSubstitute(this.port);
                ftpclient.setRemoteAddr(this.getInetAddress(realServername));
                if (!Const.isEmpty((String)realServerPort)) {
                    ftpclient.setRemotePort(Const.toInt((String)realServerPort, (int)21));
                }
                if (!Const.isEmpty((String)this.proxyHost)) {
                    int port;
                    String realProxy_host = this.environmentSubstitute(this.proxyHost);
                    ftpclient.setRemoteAddr(InetAddress.getByName(realProxy_host));
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.OpenedProxyConnectionOn", (String[])new String[]{realProxy_host}));
                    }
                    if ((port = Const.toInt((String)this.environmentSubstitute(this.proxyPort), (int)21)) != 0) {
                        ftpclient.setRemotePort(port);
                    }
                } else {
                    ftpclient.setRemoteAddr(this.getInetAddress(realServername));
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.OpenedConnectionTo", (String[])new String[]{realServername}));
                    }
                }
                if (this.activeConnection) {
                    ftpclient.setConnectMode(FTPConnectMode.ACTIVE);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.SetActive", (String[])new String[0]));
                    }
                } else {
                    ftpclient.setConnectMode(FTPConnectMode.PASV);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.SetPassive", (String[])new String[0]));
                    }
                }
                ftpclient.setTimeout(this.timeout);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.SetTimeout", (String[])new String[]{String.valueOf(this.timeout)}));
                }
                ftpclient.setControlEncoding(this.controlEncoding);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.SetEncoding", (String[])new String[]{this.controlEncoding}));
                }
                if (!Const.isEmpty((String)this.socksProxyHost)) {
                    if (Const.isEmpty((String)this.socksProxyPort)) {
                        throw new FTPException(BaseMessages.getString(PKG, (String)"JobEntryFTP.SocksProxy.PortMissingException", (String[])new String[]{this.environmentSubstitute(this.socksProxyHost), this.getName()}));
                    }
                    FTPClient.initSOCKS((String)this.environmentSubstitute(this.socksProxyPort), (String)this.environmentSubstitute(this.socksProxyHost));
                    if (!Const.isEmpty((String)this.socksProxyUsername) && !Const.isEmpty((String)this.socksProxyPassword)) {
                        FTPClient.initSOCKSAuthentication((String)this.environmentSubstitute(this.socksProxyUsername), (String)this.environmentSubstitute(this.socksProxyPassword));
                    } else if (!Const.isEmpty((String)this.socksProxyUsername) && Const.isEmpty((String)this.socksProxyPassword) || Const.isEmpty((String)this.socksProxyUsername) && !Const.isEmpty((String)this.socksProxyPassword)) {
                        throw new FTPException(BaseMessages.getString(PKG, (String)"JobEntryFTP.SocksProxy.IncompleteCredentials", (String[])new String[]{this.environmentSubstitute(this.socksProxyHost), this.getName()}));
                    }
                }
                ftpclient.connect();
                String realUsername = this.environmentSubstitute(this.userName) + (!Const.isEmpty((String)this.proxyHost) ? "@" + realServername : "") + (!Const.isEmpty((String)this.proxyUsername) ? " " + this.environmentSubstitute(this.proxyUsername) : "");
                String realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password)) + (!Const.isEmpty((String)this.proxyPassword) ? " " + Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.proxyPassword)) : "");
                ftpclient.login(realUsername, realPassword);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.LoggedIn", (String[])new String[]{realUsername}));
                }
                this.hookInOtherParsers(ftpclient);
                if (!Const.isEmpty((String)this.ftpDirectory)) {
                    String realFtpDirectory = this.environmentSubstitute(this.ftpDirectory);
                    realFtpDirectory = this.normalizePath(realFtpDirectory);
                    ftpclient.chdir(realFtpDirectory);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.ChangedDir", (String[])new String[]{realFtpDirectory}));
                    }
                }
                if (this.movefiles && !Const.isEmpty((String)this.movetodirectory)) {
                    realMoveToFolder = this.environmentSubstitute(this.movetodirectory);
                    realMoveToFolder = this.normalizePath(realMoveToFolder);
                    boolean folderExist = true;
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.CheckMoveToFolder", (String[])new String[]{realMoveToFolder}));
                    }
                    String originalLocation = ftpclient.pwd();
                    try {
                        ftpclient.chdir(realMoveToFolder);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.CheckMoveToFolderSwitchBack", (String[])new String[]{originalLocation}));
                        }
                        ftpclient.chdir(originalLocation);
                    }
                    catch (Exception e) {
                        folderExist = false;
                    }
                    if (!folderExist) {
                        if (this.createmovefolder) {
                            ftpclient.mkdir(realMoveToFolder);
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.MoveToFolderCreated", (String[])new String[]{realMoveToFolder}));
                            }
                        } else {
                            this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTP.MoveToFolderNotExist", (String[])new String[0]));
                            exitjobentry = true;
                            ++this.NrErrors;
                        }
                    }
                }
                if (!exitjobentry) {
                    String translatedWildcard;
                    FTPFile[] ftpFiles = ftpclient.dirDetails(null);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.FoundNFiles", (String[])new String[]{String.valueOf(ftpFiles.length)}));
                    }
                    if (this.binaryMode) {
                        ftpclient.setType(FTPTransferType.BINARY);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.SetBinary", (String[])new String[0]));
                        }
                    } else {
                        ftpclient.setType(FTPTransferType.ASCII);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.SetAscii", (String[])new String[0]));
                        }
                    }
                    if (ftpFiles.length == 1 && !Const.isEmpty((String)(translatedWildcard = this.environmentSubstitute(this.wildcard))) && ftpFiles[0].getName().startsWith(translatedWildcard)) {
                        throw new FTPException(ftpFiles[0].getName());
                    }
                    Pattern pattern = null;
                    if (!Const.isEmpty((String)this.wildcard)) {
                        String realWildcard = this.environmentSubstitute(this.wildcard);
                        pattern = Pattern.compile(realWildcard);
                    }
                    if (!this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS)) {
                        this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimit()), (int)10);
                    }
                    for (FTPFile ftpFile : ftpFiles) {
                        if (this.parentJob.isStopped()) {
                            exitjobentry = true;
                            throw new Exception(BaseMessages.getString(PKG, (String)"JobEntryFTP.JobStopped", (String[])new String[0]));
                        }
                        if (this.successConditionBroken) {
                            throw new Exception(BaseMessages.getString(PKG, (String)"JobEntryFTP.SuccesConditionBroken", (String[])new String[]{"" + this.NrErrors}));
                        }
                        boolean getIt = true;
                        String filename = ftpFile.getName();
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.AnalysingFile", (String[])new String[]{filename}));
                        }
                        if (ftpFile.isDir()) {
                            getIt = false;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.SkippingNotAFile", (String[])new String[]{filename}));
                            }
                        }
                        if (!getIt) continue;
                        try {
                            if (pattern != null) {
                                Matcher matcher = pattern.matcher(filename);
                                getIt = matcher.matches();
                            }
                            if (!getIt) continue;
                            this.downloadFile(ftpclient, filename, realMoveToFolder, this.parentJob, result);
                        }
                        catch (Exception e) {
                            this.updateErrors();
                            this.logError(BaseMessages.getString(PKG, (String)"JobFTP.UnexpectedError", (String[])new String[]{e.toString()}));
                        }
                    }
                }
                if (ftpclient == null) break block63;
                try {
                    ftpclient.quit();
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTP.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                }
            }
            FTPClient.clearSOCKS();
            break block65;
            catch (Exception e) {
                block64: {
                    try {
                        if (!this.successConditionBroken && !exitjobentry) {
                            this.updateErrors();
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTP.ErrorGetting", (String[])new String[]{e.getMessage()}));
                        if (ftpclient == null) break block64;
                    }
                    catch (Throwable throwable) {
                        if (ftpclient != null) {
                            try {
                                ftpclient.quit();
                            }
                            catch (Exception e2) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTP.ErrorQuitting", (String[])new String[]{e2.getMessage()}));
                            }
                        }
                        FTPClient.clearSOCKS();
                        throw throwable;
                    }
                    try {
                        ftpclient.quit();
                    }
                    catch (Exception e3) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTP.ErrorQuitting", (String[])new String[]{e3.getMessage()}));
                    }
                }
                FTPClient.clearSOCKS();
            }
        }
        result.setNrErrors(this.NrErrors);
        result.setNrFilesRetrieved(this.NrfilesRetrieved);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        if (exitjobentry) {
            result.setResult(false);
        }
        this.displayResults();
        return result;
    }

    private void downloadFile(FTPClient ftpclient, String filename, String realMoveToFolder, Job parentJob, Result result) throws Exception {
        String localFilename = filename;
        this.targetFilename = KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)this.returnTargetFilename(localFilename)));
        if (!this.onlyGettingNewFiles || this.onlyGettingNewFiles && this.needsDownload(this.targetFilename)) {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.GettingFile", (String[])new String[]{filename, this.environmentSubstitute(this.targetDirectory)}));
            }
            ftpclient.get(this.targetFilename, filename);
            this.updateRetrievedFiles();
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.GotFile", (String[])new String[]{filename}));
            }
            this.addFilenameToResultFilenames(result, parentJob, this.targetFilename);
            if (this.remove) {
                ftpclient.delete(filename);
                if (this.isDetailed() && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.DeletedFile", (String[])new String[]{filename}));
                }
            } else if (this.movefiles) {
                ftpclient.rename(filename, realMoveToFolder + FILE_SEPARATOR + filename);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.MovedFile", (String[])new String[]{filename, realMoveToFolder}));
                }
            }
        }
    }

    public String normalizePath(String path) throws Exception {
        String normalizedPath = path.replaceAll("\\\\", FILE_SEPARATOR);
        while (normalizedPath.endsWith("\\") || normalizedPath.endsWith(FILE_SEPARATOR)) {
            normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1);
        }
        return normalizedPath;
    }

    private void addFilenameToResultFilenames(Result result, Job parentJob, String filename) throws KettleException {
        if (this.isaddresult) {
            FileObject targetFile = null;
            try {
                targetFile = KettleVFS.getFileObject((String)filename, (VariableSpace)this);
                ResultFile resultFile = new ResultFile(0, targetFile, parentJob.getJobname(), this.toString());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"JobEntryFTP.Downloaded", (String[])new String[]{this.serverName}));
                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.FileAddedToResult", (String[])new String[]{filename}));
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            finally {
                try {
                    targetFile.close();
                    targetFile = null;
                }
                catch (Exception e) {}
            }
        }
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.Log.Info.FilesInError", (String[])new String[]{"" + this.NrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.Log.Info.FilesRetrieved", (String[])new String[]{"" + this.NrfilesRetrieved}));
            this.logDetailed("=======================================");
        }
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrfilesRetrieved >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED) || this.NrErrors <= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateRetrievedFiles() {
        ++this.NrfilesRetrieved;
    }

    private String returnTargetFilename(String filename) {
        String retval = null;
        if (filename == null) {
            return null;
        }
        retval = filename;
        int lenstring = retval.length();
        int lastindexOfDot = retval.lastIndexOf(".");
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddDateBeforeExtension()) {
            retval = retval.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.SpecifyFormat && !Const.isEmpty((String)this.date_time_format)) {
            daf.applyPattern(this.date_time_format);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.adddate) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.addtime) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            retval = retval + retval.substring(lastindexOfDot, lenstring);
        }
        retval = this.environmentSubstitute(this.targetDirectory) + Const.FILE_SEPARATOR + retval;
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    protected boolean needsDownload(String filename) {
        boolean retval = false;
        File file = new File(filename);
        if (!file.exists()) {
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.LocalFileNotExists", (String[])new String[0]), filename);
            }
            return true;
        }
        if (this.ifFileExists == this.ifFileExistsCreateUniq) {
            if (this.isDebug()) {
                this.logDebug(this.toString(), BaseMessages.getString(PKG, (String)"JobEntryFTP.LocalFileExists", (String[])new String[0]), filename);
            }
            int lenstring = this.targetFilename.length();
            int lastindexOfDot = this.targetFilename.lastIndexOf(46);
            if (lastindexOfDot == -1) {
                lastindexOfDot = lenstring;
            }
            this.targetFilename = this.targetFilename.substring(0, lastindexOfDot) + StringUtil.getFormattedDateTimeNow((boolean)true) + this.targetFilename.substring(lastindexOfDot, lenstring);
            return true;
        }
        if (this.ifFileExists == this.ifFileExistsFail) {
            this.log.logError(BaseMessages.getString(PKG, (String)"JobEntryFTP.LocalFileExists", (String[])new String[0]), new Object[]{filename});
            this.updateErrors();
        } else if (this.isDebug()) {
            this.logDebug(this.toString(), BaseMessages.getString(PKG, (String)"JobEntryFTP.LocalFileExists", (String[])new String[0]), filename);
        }
        return retval;
    }

    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean passive) {
        this.activeConnection = passive;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "targetDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServername = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    protected void hookInOtherParsers(FTPClient ftpClient) throws FTPException, IOException {
        VariableSpace vs;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Hooking.Parsers", (String[])new String[0]));
        }
        String system = ftpClient.system();
        MVSFileParser parser = new MVSFileParser(this.log);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Created.MVS.Parser", (String[])new String[0]));
        }
        FTPFileFactory factory = new FTPFileFactory(system);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Created.Factory", (String[])new String[0]));
        }
        factory.addParser((FTPFileParser)parser);
        ftpClient.setFTPFileFactory(factory);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Get.Variable.Space", (String[])new String[0]));
        }
        if ((vs = this.getVariables()) != null) {
            String otherParserNames;
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Getting.Other.Parsers", (String[])new String[0]));
            }
            if ((otherParserNames = vs.getVariable("ftp.file.parser.class.names")) != null) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Creating.Parsers", (String[])new String[0]));
                }
                String[] parserClasses = otherParserNames.split("|");
                String cName = null;
                Class<?> clazz = null;
                Object parserInstance = null;
                for (int i = 0; i < parserClasses.length; ++i) {
                    cName = parserClasses[i].trim();
                    if (cName.length() <= 0) continue;
                    try {
                        clazz = Class.forName(cName);
                        parserInstance = clazz.newInstance();
                        if (!(parserInstance instanceof FTPFileParser)) continue;
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTP.DEBUG.Created.Other.Parser", (String[])new String[]{cName}));
                        }
                        factory.addParser((FTPFileParser)parserInstance);
                        continue;
                    }
                    catch (Exception ignored) {
                        if (!this.log.isDebug()) continue;
                        ignored.printStackTrace();
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryFTP.ERROR.Creating.Parser", (String[])new String[]{cName}));
                    }
                }
            }
        }
    }
}

