/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.pgpdecryptfiles;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.pgpencryptfiles.GPG;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryPGPDecryptFiles
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryPGPDecryptFiles.class;
    private SimpleDateFormat daf;
    private GPG gpg;
    public boolean arg_from_previous = false;
    public boolean include_subfolders = false;
    public boolean add_result_filesname = false;
    public boolean destination_is_a_file = false;
    public boolean create_destination_folder = false;
    public String[] source_filefolder = null;
    public String[] passphrase = null;
    public String[] destination_filefolder = null;
    public String[] wildcard = null;
    private String nr_errors_less_than = "10";
    private String success_condition = this.SUCCESS_IF_NO_ERRORS;
    public String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private boolean add_date = false;
    private boolean add_time = false;
    private boolean SpecifyFormat = false;
    private String date_time_format = null;
    private boolean AddDateBeforeExtension = false;
    private boolean DoNotKeepFolderStructure = false;
    private String iffileexists = "do_nothing";
    private String destinationFolder = null;
    private String ifmovedfileexists = "do_nothing";
    private String moved_date_time_format = null;
    private boolean AddMovedDateBeforeExtension = false;
    private boolean add_moved_date = false;
    private boolean add_moved_time = false;
    private boolean SpecifyMoveFormat = false;
    public boolean create_move_to_folder = false;
    private String gpglocation = null;
    private int NrErrors = 0;
    private int NrSuccess = 0;
    private boolean successConditionBroken = false;
    private boolean successConditionBrokenExit = false;
    private int limitFiles = 0;

    public JobEntryPGPDecryptFiles(String n) {
        super(n, "");
    }

    public JobEntryPGPDecryptFiles() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryPGPDecryptFiles je = (JobEntryPGPDecryptFiles)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"gpglocation", (String)this.gpglocation));
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.arg_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_result_filesname", (boolean)this.add_result_filesname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination_is_a_file", (boolean)this.destination_is_a_file));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_destination_folder", (boolean)this.create_destination_folder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.add_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.add_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.AddDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"DoNotKeepFolderStructure", (boolean)this.DoNotKeepFolderStructure));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (String)this.iffileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationFolder", (String)this.destinationFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ifmovedfileexists", (String)this.ifmovedfileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"moved_date_time_format", (String)this.moved_date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_move_to_folder", (boolean)this.create_move_to_folder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_moved_date", (boolean)this.add_moved_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_moved_time", (boolean)this.add_moved_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyMoveFormat", (boolean)this.SpecifyMoveFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddMovedDateBeforeExtension", (boolean)this.AddMovedDateBeforeExtension));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"passphrase", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.passphrase[i])));
                retval.append("          ").append(XMLHandler.addTagValue((String)"destination_filefolder", (String)this.destination_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.gpglocation = XMLHandler.getTagValue((Node)entrynode, (String)"gpglocation");
            this.arg_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.add_result_filesname = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.destination_is_a_file = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"destination_is_a_file"));
            this.create_destination_folder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_destination_folder"));
            this.add_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.add_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.AddDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            this.DoNotKeepFolderStructure = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"DoNotKeepFolderStructure"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.iffileexists = XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists");
            this.destinationFolder = XMLHandler.getTagValue((Node)entrynode, (String)"destinationFolder");
            this.ifmovedfileexists = XMLHandler.getTagValue((Node)entrynode, (String)"ifmovedfileexists");
            this.moved_date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"moved_date_time_format");
            this.AddMovedDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddMovedDateBeforeExtension"));
            this.create_move_to_folder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_move_to_folder"));
            this.add_moved_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_moved_date"));
            this.add_moved_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_moved_time"));
            this.SpecifyMoveFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyMoveFormat"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.passphrase = new String[nrFields];
            this.destination_filefolder = new String[nrFields];
            this.wildcard = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.passphrase[i] = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)fnode, (String)"passphrase"));
                this.destination_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"destination_filefolder");
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.gpglocation = rep.getJobEntryAttributeString(id_jobentry, "gpglocation");
            this.arg_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.add_result_filesname = rep.getJobEntryAttributeBoolean(id_jobentry, "add_result_filesname");
            this.destination_is_a_file = rep.getJobEntryAttributeBoolean(id_jobentry, "destination_is_a_file");
            this.create_destination_folder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_destination_folder");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            this.add_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.add_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.AddDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDateBeforeExtension");
            this.DoNotKeepFolderStructure = rep.getJobEntryAttributeBoolean(id_jobentry, "DoNotKeepFolderStructure");
            this.iffileexists = rep.getJobEntryAttributeString(id_jobentry, "iffileexists");
            this.destinationFolder = rep.getJobEntryAttributeString(id_jobentry, "destinationFolder");
            this.ifmovedfileexists = rep.getJobEntryAttributeString(id_jobentry, "ifmovedfileexists");
            this.moved_date_time_format = rep.getJobEntryAttributeString(id_jobentry, "moved_date_time_format");
            this.AddMovedDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddMovedDateBeforeExtension");
            this.create_move_to_folder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_move_to_folder");
            this.add_moved_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_moved_date");
            this.add_moved_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_moved_time");
            this.SpecifyMoveFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyMoveFormat");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.passphrase = new String[argnr];
            this.destination_filefolder = new String[argnr];
            this.wildcard = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.passphrase[a] = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, a, "passphrase"));
                this.destination_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "destination_filefolder");
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.Exception.UnableLoadRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "gpglocation", this.gpglocation);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.arg_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_result_filesname", this.add_result_filesname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destination_is_a_file", this.destination_is_a_file);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_destination_folder", this.create_destination_folder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_date", this.add_date);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_time", this.add_time);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "AddDateBeforeExtension", this.AddDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "DoNotKeepFolderStructure", this.DoNotKeepFolderStructure);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "iffileexists", this.iffileexists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destinationFolder", this.destinationFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ifmovedfileexists", this.ifmovedfileexists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "moved_date_time_format", this.moved_date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_moved_date", this.add_moved_date);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_moved_time", this.add_moved_time);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyMoveFormat", this.SpecifyMoveFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_move_to_folder", this.create_move_to_folder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "AddMovedDateBeforeExtension", this.AddMovedDateBeforeExtension);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "passphrase", Encr.encryptPasswordIfNotUsingVariables((String)this.passphrase[i]));
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "destination_filefolder", this.destination_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "wildcard", this.wildcard[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.Exception.UnableSaveRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        try {
            Result result;
            block50: {
                String[] vwildcard;
                String[] vdestinationfilefolder;
                String[] vpassphrase;
                String[] vsourcefilefolder;
                String MoveToFolder;
                block51: {
                    RowMetaAndData resultRow;
                    List rows;
                    block49: {
                        block48: {
                            result = previousResult;
                            rows = result.getRows();
                            resultRow = null;
                            result.setNrErrors(1L);
                            result.setResult(false);
                            this.NrErrors = 0;
                            this.NrSuccess = 0;
                            this.successConditionBroken = false;
                            this.successConditionBrokenExit = false;
                            this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getNrErrorsLessThan()), (int)10);
                            if (this.include_subfolders && this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.IncludeSubFoldersOn", (String[])new String[0]));
                            }
                            MoveToFolder = this.environmentSubstitute(this.destinationFolder);
                            vsourcefilefolder = this.source_filefolder;
                            vpassphrase = this.passphrase;
                            vdestinationfilefolder = this.destination_filefolder;
                            vwildcard = this.wildcard;
                            if (this.iffileexists.equals("move_file")) {
                                if (Const.isEmpty((String)MoveToFolder)) {
                                    this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.Error.MoveToFolderMissing", (String[])new String[0]));
                                    Result result2 = result;
                                    return result2;
                                }
                                FileObject folder = null;
                                try {
                                    folder = KettleVFS.getFileObject((String)MoveToFolder);
                                    if (!folder.exists()) {
                                        if (this.isDetailed()) {
                                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.Error.FolderMissing", (String[])new String[]{MoveToFolder}));
                                        }
                                        if (!this.create_move_to_folder) {
                                            this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.Error.FolderMissing", (String[])new String[]{MoveToFolder}));
                                            Result result3 = result;
                                            return result3;
                                        }
                                        folder.createFolder();
                                    }
                                    if (!folder.getType().equals(FileType.FOLDER)) {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.Error.NotFolder", (String[])new String[]{MoveToFolder}));
                                        Result result4 = result;
                                        return result4;
                                    }
                                }
                                catch (Exception e) {
                                    this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.Error.GettingMoveToFolder", (String[])new String[]{MoveToFolder, e.getMessage()}));
                                    Result ex = result;
                                    return ex;
                                }
                                finally {
                                    if (folder != null) {
                                        try {
                                            folder.close();
                                        }
                                        catch (IOException ex) {}
                                    }
                                }
                            }
                            this.gpg = new GPG(this.environmentSubstitute(this.gpglocation), this.log);
                            if (this.arg_from_previous && this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
                            }
                            if (!this.arg_from_previous || rows == null) break block48;
                            break block49;
                        }
                        if (vsourcefilefolder == null || vdestinationfilefolder == null) break block50;
                        break block51;
                    }
                    for (int iteration = 0; iteration < rows.size(); ++iteration) {
                        if (this.successConditionBroken) {
                            if (!this.successConditionBrokenExit) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                                this.successConditionBrokenExit = true;
                            }
                            result.setNrErrors((long)this.NrErrors);
                            this.displayResults();
                            Result e = result;
                            return e;
                        }
                        resultRow = (RowMetaAndData)rows.get(iteration);
                        String vsourcefilefolder_previous = resultRow.getString(0, null);
                        String vwildcard_previous = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(resultRow.getString(1, null)));
                        String vpassphrase_previous = resultRow.getString(2, null);
                        String vdestinationfilefolder_previous = resultRow.getString(3, null);
                        if (!Const.isEmpty((String)vsourcefilefolder_previous) && !Const.isEmpty((String)vdestinationfilefolder_previous)) {
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous}));
                            }
                            if (this.ProcessFileFolder(vsourcefilefolder_previous, vpassphrase_previous, vdestinationfilefolder_previous, vwildcard_previous, this.parentJob, result, MoveToFolder)) continue;
                            this.updateErrors();
                            continue;
                        }
                        if (!this.isDetailed()) continue;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.IgnoringRow", (String[])new String[]{vsourcefilefolder[iteration], vdestinationfilefolder[iteration], vwildcard[iteration]}));
                    }
                    break block50;
                }
                for (int i = 0; i < vsourcefilefolder.length && !this.parentJob.isStopped(); ++i) {
                    if (this.successConditionBroken) {
                        if (!this.successConditionBrokenExit) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                            this.successConditionBrokenExit = true;
                        }
                        result.setNrErrors((long)this.NrErrors);
                        this.displayResults();
                        Result result5 = result;
                        return result5;
                    }
                    if (!Const.isEmpty((String)vsourcefilefolder[i]) && !Const.isEmpty((String)vdestinationfilefolder[i])) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]}));
                        }
                        if (this.ProcessFileFolder(vsourcefilefolder[i], Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(vpassphrase[i])), vdestinationfilefolder[i], vwildcard[i], this.parentJob, result, MoveToFolder)) continue;
                        this.updateErrors();
                        continue;
                    }
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.IgnoringRow", (String[])new String[]{vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]}));
                }
            }
            result.setNrErrors((long)this.NrErrors);
            result.setNrLinesWritten((long)this.NrSuccess);
            if (this.getSuccessStatus()) {
                result.setResult(true);
            }
            this.displayResults();
            Result result6 = result;
            return result6;
        }
        finally {
            if (this.source_filefolder != null) {
                this.source_filefolder = null;
            }
            if (this.destination_filefolder != null) {
                this.destination_filefolder = null;
            }
        }
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.Info.FilesInError", (String[])new String[]{"" + this.NrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.Info.FilesInSuccess", (String[])new String[]{"" + this.NrSuccess}));
            this.logDetailed("=======================================");
        }
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.NrErrors <= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ProcessFileFolder(String sourcefilefoldername, String passPhrase, String destinationfilefoldername, String wildcard, Job parentJob, Result result, String MoveToFolder) {
        boolean entrystatus;
        block86: {
            entrystatus = false;
            FileObject sourcefilefolder = null;
            FileObject destinationfilefolder = null;
            FileObject movetofolderfolder = null;
            FileObject Currentfile = null;
            String realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
            String realDestinationFilefoldername = this.environmentSubstitute(destinationfilefoldername);
            String realWildcard = this.environmentSubstitute(wildcard);
            try {
                sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername);
                destinationfilefolder = KettleVFS.getFileObject((String)realDestinationFilefoldername);
                if (!Const.isEmpty((String)MoveToFolder)) {
                    movetofolderfolder = KettleVFS.getFileObject((String)MoveToFolder);
                }
                if (sourcefilefolder.exists()) {
                    if (this.CreateDestinationFolder(destinationfilefolder)) {
                        if (sourcefilefolder.getType().equals(FileType.FOLDER) && this.destination_is_a_file) {
                            this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.Forbidden", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.CanNotMoveFolderToFile", (String[])new String[]{realSourceFilefoldername, realDestinationFilefoldername}));
                            this.updateErrors();
                        } else if (destinationfilefolder.getType().equals(FileType.FOLDER) && sourcefilefolder.getType().equals(FileType.FILE)) {
                            String shortfilename = sourcefilefolder.getName().getBaseName();
                            try {
                                shortfilename = this.getDestinationFilename(sourcefilefolder.getName().getBaseName());
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.GettingFilename", (String[])new String[]{sourcefilefolder.getName().getBaseName(), e.toString()}));
                                boolean bl = entrystatus;
                                if (sourcefilefolder != null) {
                                    try {
                                        sourcefilefolder.close();
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                if (destinationfilefolder != null) {
                                    try {
                                        destinationfilefolder.close();
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                if (Currentfile != null) {
                                    try {
                                        Currentfile.close();
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                if (movetofolderfolder != null) {
                                    try {
                                        movetofolderfolder.close();
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                return bl;
                            }
                            String destinationfilenamefull = destinationfilefolder.toString() + Const.FILE_SEPARATOR + shortfilename;
                            FileObject destinationfile = KettleVFS.getFileObject((String)destinationfilenamefull);
                            entrystatus = this.DecryptFile(shortfilename, sourcefilefolder, passPhrase, destinationfile, movetofolderfolder, parentJob, result);
                        } else if (sourcefilefolder.getType().equals(FileType.FILE) && this.destination_is_a_file) {
                            FileObject destinationfile = KettleVFS.getFileObject((String)realDestinationFilefoldername);
                            String shortfilename = destinationfile.getName().getBaseName();
                            try {
                                shortfilename = this.getDestinationFilename(destinationfile.getName().getBaseName());
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.GettingFilename", (String[])new String[]{sourcefilefolder.getName().getBaseName(), e.toString()}));
                                boolean ex = entrystatus;
                                if (sourcefilefolder != null) {
                                    try {
                                        sourcefilefolder.close();
                                    }
                                    catch (IOException ex2) {
                                        // empty catch block
                                    }
                                }
                                if (destinationfilefolder != null) {
                                    try {
                                        destinationfilefolder.close();
                                    }
                                    catch (IOException ex3) {
                                        // empty catch block
                                    }
                                }
                                if (Currentfile != null) {
                                    try {
                                        Currentfile.close();
                                    }
                                    catch (IOException ex4) {
                                        // empty catch block
                                    }
                                }
                                if (movetofolderfolder != null) {
                                    try {
                                        movetofolderfolder.close();
                                    }
                                    catch (IOException ex5) {
                                        // empty catch block
                                    }
                                }
                                return ex;
                            }
                            String destinationfilenamefull = destinationfilefolder.getParent().toString() + Const.FILE_SEPARATOR + shortfilename;
                            destinationfile = KettleVFS.getFileObject((String)destinationfilenamefull);
                            entrystatus = this.DecryptFile(shortfilename, sourcefilefolder, passPhrase, destinationfile, movetofolderfolder, parentJob, result);
                        } else {
                            FileObject[] fileObjects;
                            if (this.isDetailed()) {
                                this.logDetailed("  ");
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FetchFolder", (String[])new String[]{sourcefilefolder.toString()}));
                            }
                            if ((fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                                public boolean traverseDescendents(FileSelectInfo info) {
                                    return info.getDepth() == 0 || JobEntryPGPDecryptFiles.this.include_subfolders;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public boolean includeFile(FileSelectInfo info) {
                                    FileObject fileObject = info.getFile();
                                    try {
                                        if (fileObject == null) {
                                            boolean bl = false;
                                            return bl;
                                        }
                                    }
                                    catch (Exception ex) {
                                        boolean bl = false;
                                        return bl;
                                    }
                                    finally {
                                        if (fileObject != null) {
                                            try {
                                                fileObject.close();
                                                fileObject = null;
                                            }
                                            catch (IOException ex) {}
                                        }
                                    }
                                    return true;
                                }
                            })) != null) {
                                for (int j = 0; j < fileObjects.length && !parentJob.isStopped(); ++j) {
                                    if (this.successConditionBroken) {
                                        if (!this.successConditionBrokenExit) {
                                            this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                                            this.successConditionBrokenExit = true;
                                        }
                                        boolean bl = false;
                                        return bl;
                                    }
                                    Currentfile = fileObjects[j];
                                    if (this.DecryptOneFile(Currentfile, sourcefilefolder, passPhrase, realDestinationFilefoldername, realWildcard, parentJob, result, movetofolderfolder)) continue;
                                    this.updateErrors();
                                }
                            }
                        }
                        entrystatus = true;
                        break block86;
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.DestinationFolderNotFound", (String[])new String[]{realDestinationFilefoldername}));
                    break block86;
                }
                this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.Exception.MoveProcess", (String[])new String[]{realSourceFilefoldername.toString(), destinationfilefolder.toString(), e.getMessage()}));
                this.updateErrors();
            }
            finally {
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                    }
                    catch (IOException ex) {}
                }
                if (destinationfilefolder != null) {
                    try {
                        destinationfilefolder.close();
                    }
                    catch (IOException ex) {}
                }
                if (Currentfile != null) {
                    try {
                        Currentfile.close();
                    }
                    catch (IOException ex) {}
                }
                if (movetofolderfolder != null) {
                    try {
                        movetofolderfolder.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return entrystatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean DecryptFile(String shortfilename, FileObject sourcefilename, String passPharse, FileObject destinationfilename, FileObject movetofolderfolder, Job parentJob, Result result) {
        boolean retval;
        block51: {
            FileObject destinationfile = null;
            retval = false;
            try {
                String short_filename;
                if (!destinationfilename.exists()) {
                    this.gpg.decryptFile(sourcefilename, passPharse, destinationfilename);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FileDecrypted", (String[])new String[]{sourcefilename.getName().toString(), destinationfilename.getName().toString()}));
                    }
                    if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                        this.addFileToResultFilenames(destinationfilename.toString(), result, parentJob);
                    }
                    this.updateSuccess();
                    break block51;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FileExists", (String[])new String[]{destinationfilename.toString()}));
                }
                if (this.iffileexists.equals("overwrite_file")) {
                    this.gpg.decryptFile(sourcefilename, passPharse, destinationfilename);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FileOverwrite", (String[])new String[]{destinationfilename.getName().toString()}));
                    }
                    if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                        this.addFileToResultFilenames(destinationfilename.toString(), result, parentJob);
                    }
                    this.updateSuccess();
                    break block51;
                }
                if (this.iffileexists.equals("unique_name")) {
                    short_filename = shortfilename;
                    try {
                        short_filename = this.getMoveDestinationFilename(short_filename, "ddMMyyyy_HHmmssSSS");
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.GettingFilename", (String[])new String[]{short_filename}), e);
                        boolean bl = retval;
                        if (destinationfile != null) {
                            try {
                                destinationfile.close();
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                    String movetofilenamefull = destinationfilename.getParent().toString() + Const.FILE_SEPARATOR + short_filename;
                    destinationfile = KettleVFS.getFileObject((String)movetofilenamefull);
                    this.gpg.decryptFile(sourcefilename, passPharse, destinationfile);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FileDecrypted", (String[])new String[]{sourcefilename.getName().toString(), destinationfile.getName().toString()}));
                    }
                    if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                        this.addFileToResultFilenames(destinationfile.toString(), result, parentJob);
                    }
                    this.updateSuccess();
                    break block51;
                }
                if (this.iffileexists.equals("delete_file")) {
                    destinationfilename.delete();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FileDeleted", (String[])new String[]{destinationfilename.getName().toString()}));
                    }
                    break block51;
                }
                if (this.iffileexists.equals("move_file")) {
                    short_filename = shortfilename;
                    try {
                        short_filename = this.getMoveDestinationFilename(short_filename, null);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.GettingFilename", (String[])new String[]{short_filename}), e);
                        boolean bl = retval;
                        if (destinationfile != null) {
                            try {
                                destinationfile.close();
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                    String movetofilenamefull = movetofolderfolder.toString() + Const.FILE_SEPARATOR + short_filename;
                    destinationfile = KettleVFS.getFileObject((String)movetofilenamefull);
                    if (!destinationfile.exists()) {
                        sourcefilename.moveTo(destinationfile);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FileDecrypted", (String[])new String[]{sourcefilename.getName().toString(), destinationfile.getName().toString()}));
                        }
                        if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                            this.addFileToResultFilenames(destinationfile.toString(), result, parentJob);
                        }
                    } else if (this.ifmovedfileexists.equals("overwrite_file")) {
                        sourcefilename.moveTo(destinationfile);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FileOverwrite", (String[])new String[]{destinationfile.getName().toString()}));
                        }
                        if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                            this.addFileToResultFilenames(destinationfile.toString(), result, parentJob);
                        }
                        this.updateSuccess();
                    } else if (this.ifmovedfileexists.equals("unique_name")) {
                        SimpleDateFormat daf = new SimpleDateFormat();
                        Date now = new Date();
                        daf.applyPattern("ddMMyyyy_HHmmssSSS");
                        String dt = daf.format(now);
                        short_filename = short_filename + "_" + dt;
                        String destinationfilenamefull = movetofolderfolder.toString() + Const.FILE_SEPARATOR + short_filename;
                        destinationfile = KettleVFS.getFileObject((String)destinationfilenamefull);
                        sourcefilename.moveTo(destinationfile);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FileDecrypted", (String[])new String[]{destinationfile.getName().toString()}));
                        }
                        if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                            this.addFileToResultFilenames(destinationfile.toString(), result, parentJob);
                        }
                        this.updateSuccess();
                    } else if (this.ifmovedfileexists.equals("fail")) {
                        this.updateErrors();
                    }
                    break block51;
                }
                if (this.iffileexists.equals("fail")) {
                    this.updateErrors();
                }
            }
            catch (Exception e) {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.Exception.MoveProcessError", (String[])new String[]{sourcefilename.toString(), destinationfilename.toString(), e.getMessage()}));
            }
            finally {
                if (destinationfile != null) {
                    try {
                        destinationfile.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean DecryptOneFile(FileObject Currentfile, FileObject sourcefilefolder, String passPhrase, String realDestinationFilefoldername, String realWildcard, Job parentJob, Result result, FileObject movetofolderfolder) {
        boolean entrystatus = false;
        FileObject file_name = null;
        try {
            if (!Currentfile.toString().equals(sourcefilefolder.toString())) {
                String sourceshortfilename;
                String shortfilename = sourceshortfilename = Currentfile.getName().getBaseName();
                try {
                    shortfilename = this.getDestinationFilename(sourceshortfilename);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.GettingFilename", (String[])new String[]{Currentfile.getName().getBaseName(), e.toString()}));
                    boolean bl = entrystatus;
                    if (file_name != null) {
                        try {
                            file_name.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                int lenCurrent = sourceshortfilename.length();
                String short_filename_from_basefolder = shortfilename;
                if (!this.isDoNotKeepFolderStructure()) {
                    short_filename_from_basefolder = Currentfile.toString().substring(sourcefilefolder.toString().length(), Currentfile.toString().length());
                }
                short_filename_from_basefolder = short_filename_from_basefolder.substring(0, short_filename_from_basefolder.length() - lenCurrent) + shortfilename;
                file_name = KettleVFS.getFileObject((String)(realDestinationFilefoldername + Const.FILE_SEPARATOR + short_filename_from_basefolder));
                if (!Currentfile.getParent().toString().equals(sourcefilefolder.toString())) {
                    if (this.include_subfolders && Currentfile.getType() != FileType.FOLDER && this.GetFileWildcard(sourceshortfilename, realWildcard)) {
                        entrystatus = this.DecryptFile(shortfilename, Currentfile, passPhrase, file_name, movetofolderfolder, parentJob, result);
                    }
                } else if (Currentfile.getType() != FileType.FOLDER && this.GetFileWildcard(sourceshortfilename, realWildcard)) {
                    entrystatus = this.DecryptFile(shortfilename, Currentfile, passPhrase, file_name, movetofolderfolder, parentJob, result);
                }
            }
            entrystatus = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.Error", (String[])new String[]{e.toString()}));
        }
        finally {
            if (file_name != null) {
                try {
                    file_name.close();
                }
                catch (IOException ex) {}
            }
        }
        return entrystatus;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateSuccess() {
        ++this.NrSuccess;
    }

    private void addFileToResultFilenames(String fileaddentry, Result result, Job parentJob) {
        try {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileaddentry), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.isDebug()) {
                this.logDebug(" ------ ");
                this.logDebug(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FileAddedToResultFilesName", (String[])new String[]{fileaddentry}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Error.AddingToFilenameResult", (String[])new String[0]), fileaddentry + "" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CreateDestinationFolder(FileObject filefolder) {
        FileObject folder = null;
        try {
            folder = this.destination_is_a_file ? filefolder.getParent() : filefolder;
            if (!folder.exists()) {
                if (this.create_destination_folder) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FolderNotExist", (String[])new String[]{folder.getName().toString()}));
                    }
                    folder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FolderWasCreated", (String[])new String[]{folder.getName().toString()}));
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.FolderNotExist", (String[])new String[]{folder.getName().toString()}));
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobPGPDecryptFiles.Log.CanNotCreateParentFolder", (String[])new String[]{folder.getName().toString()}), e);
        }
        finally {
            if (folder != null) {
                try {
                    folder.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    private String getDestinationFilename(String shortsourcefilename) throws Exception {
        String shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = shortfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename.substring(0, lastindexOfDot);
        }
        if (this.daf == null) {
            this.daf = new SimpleDateFormat();
        }
        Date now = new Date();
        if (this.isSpecifyFormat() && !Const.isEmpty((String)this.getDateTimeFormat())) {
            this.daf.applyPattern(this.getDateTimeFormat());
            String dt = this.daf.format(now);
            shortfilename = shortfilename + dt;
        } else {
            if (this.isAddDate()) {
                this.daf.applyPattern("yyyyMMdd");
                String d = this.daf.format(now);
                shortfilename = shortfilename + "_" + d;
            }
            if (this.isAddTime()) {
                this.daf.applyPattern("HHmmssSSS");
                String t = this.daf.format(now);
                shortfilename = shortfilename + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    private String getMoveDestinationFilename(String shortsourcefilename, String DateFormat2) throws Exception {
        String shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = shortfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddMovedDateBeforeExtension()) {
            shortfilename = shortfilename.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (DateFormat2 != null) {
            daf.applyPattern(DateFormat2);
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else if (this.isSpecifyMoveFormat() && !Const.isEmpty((String)this.getMovedDateTimeFormat())) {
            daf.applyPattern(this.getMovedDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else {
            if (this.isAddMovedDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = shortfilename + "_" + d;
            }
            if (this.isAddMovedTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = shortfilename + "_" + t;
            }
        }
        if (this.isAddMovedDateBeforeExtension()) {
            shortfilename = shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    public void setAddDate(boolean adddate) {
        this.add_date = adddate;
    }

    public boolean isAddDate() {
        return this.add_date;
    }

    public boolean isAddMovedDate() {
        return this.add_moved_date;
    }

    public void setAddMovedDate(boolean add_moved_date) {
        this.add_moved_date = add_moved_date;
    }

    public boolean isAddMovedTime() {
        return this.add_moved_time;
    }

    public void setAddMovedTime(boolean add_moved_time) {
        this.add_moved_time = add_moved_time;
    }

    public void setIfFileExists(String iffileexists) {
        this.iffileexists = iffileexists;
    }

    public String getIfFileExists() {
        return this.iffileexists;
    }

    public void setIfMovedFileExists(String ifmovedfileexists) {
        this.ifmovedfileexists = ifmovedfileexists;
    }

    public String getIfMovedFileExists() {
        return this.ifmovedfileexists;
    }

    public void setAddTime(boolean addtime) {
        this.add_time = addtime;
    }

    public boolean isAddTime() {
        return this.add_time;
    }

    public void setAddDateBeforeExtension(boolean AddDateBeforeExtension) {
        this.AddDateBeforeExtension = AddDateBeforeExtension;
    }

    public void setAddMovedDateBeforeExtension(boolean AddMovedDateBeforeExtension) {
        this.AddMovedDateBeforeExtension = AddMovedDateBeforeExtension;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public void setSpecifyMoveFormat(boolean SpecifyMoveFormat) {
        this.SpecifyMoveFormat = SpecifyMoveFormat;
    }

    public boolean isSpecifyMoveFormat() {
        return this.SpecifyMoveFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public String getMovedDateTimeFormat() {
        return this.moved_date_time_format;
    }

    public void setMovedDateTimeFormat(String moved_date_time_format) {
        this.moved_date_time_format = moved_date_time_format;
    }

    public boolean isAddDateBeforeExtension() {
        return this.AddDateBeforeExtension;
    }

    public boolean isAddMovedDateBeforeExtension() {
        return this.AddMovedDateBeforeExtension;
    }

    public boolean isDoNotKeepFolderStructure() {
        return this.DoNotKeepFolderStructure;
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setGPGPLocation(String gpglocation) {
        this.gpglocation = gpglocation;
    }

    public String getGPGLocation() {
        return this.gpglocation;
    }

    public void setDoNotKeepFolderStructure(boolean DoNotKeepFolderStructure) {
        this.DoNotKeepFolderStructure = DoNotKeepFolderStructure;
    }

    public void setIncludeSubfolders(boolean include_subfoldersin) {
        this.include_subfolders = include_subfoldersin;
    }

    public void setAddresultfilesname(boolean add_result_filesnamein) {
        this.add_result_filesname = add_result_filesnamein;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.arg_from_previous = argfrompreviousin;
    }

    public void setDestinationIsAFile(boolean destination_is_a_file) {
        this.destination_is_a_file = destination_is_a_file;
    }

    public void setCreateDestinationFolder(boolean create_destination_folder) {
        this.create_destination_folder = create_destination_folder;
    }

    public void setCreateMoveToFolder(boolean create_move_to_folder) {
        this.create_move_to_folder = create_move_to_folder;
    }

    public void setNrErrorsLessThan(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrErrorsLessThan() {
        return this.nr_errors_less_than;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }
}

