/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.elasticsearchbulk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.elasticsearchbulk.ElasticSearchBulk;
import org.pentaho.di.trans.steps.elasticsearchbulk.ElasticSearchBulkData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class ElasticSearchBulkMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ElasticSearchBulkMeta.class;
    public static final int DEFAULT_BATCH_SIZE = 50000;
    public static final Long DEFAULT_TIMEOUT = 10L;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    public static final int DEFAULT_PORT = 9300;
    private String index = null;
    private String type = null;
    private boolean isJsonInsert = false;
    private String jsonField = null;
    private String idInField = null;
    private boolean overWriteIfSameId = false;
    private String idOutField = null;
    private boolean useOutput = false;
    private boolean stopOnError = true;
    private String batchSize;
    private String timeout;
    private TimeUnit timeoutUnit;
    private List<InetSocketTransportAddress> servers = new ArrayList<InetSocketTransportAddress>();
    private Map<String, String> fields = new HashMap<String, String>();
    private Map<String, String> settings = new HashMap<String, String>();

    public String getJsonField() {
        return this.jsonField;
    }

    public void setJsonField(String jsonField) {
        this.jsonField = StringUtils.isBlank((String)jsonField) ? null : jsonField;
    }

    public String getIdOutField() {
        return this.idOutField;
    }

    public void setIdOutField(String idField) {
        this.idOutField = StringUtils.isBlank((String)idField) ? null : idField;
    }

    public boolean isJsonInsert() {
        return this.isJsonInsert;
    }

    public void setJsonInsert(boolean isJsonInsert) {
        this.isJsonInsert = isJsonInsert;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIdInField(String idInField) {
        this.idInField = idInField;
    }

    public String getIdInField() {
        return this.idInField;
    }

    public void setOverWriteIfSameId(boolean overWriteIfSameId) {
        this.overWriteIfSameId = overWriteIfSameId;
    }

    public boolean isOverWriteIfSameId() {
        return this.overWriteIfSameId;
    }

    public boolean isUseOutput() {
        return this.useOutput;
    }

    public void setUseOutput(boolean value) {
        this.useOutput = value;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, String> fields) {
        this.fields = fields;
    }

    public void clearFields() {
        this.fields.clear();
    }

    public void addField(String inputName, String nameInJson) {
        this.fields.put(inputName, StringUtils.isBlank((String)nameInJson) ? inputName : nameInJson);
    }

    public InetSocketTransportAddress[] getServers() {
        return this.servers.toArray(new InetSocketTransportAddress[this.servers.size()]);
    }

    public void clearServers() {
        this.servers.clear();
    }

    public void addServer(String addr, int port) {
        this.servers.add(new InetSocketTransportAddress(addr, port));
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public void clearSettings() {
        this.settings.clear();
    }

    public void addSetting(String property, String value) {
        if (StringUtils.isNotBlank((String)property)) {
            this.settings.put(property, value);
        }
    }

    public void setBatchSize(String value) {
        this.batchSize = value;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public int getBatchSizeInt(VariableSpace vars) {
        return Const.toInt((String)vars.environmentSubstitute(this.batchSize), (int)50000);
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public void setTimeOut(String TimeOut) {
        this.timeout = TimeOut;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit != null ? this.timeoutUnit : DEFAULT_TIMEOUT_UNIT;
    }

    public void setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
    }

    @Override
    public Object clone() {
        ElasticSearchBulkMeta retval = (ElasticSearchBulkMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.batchSize = "50000";
        this.timeoutUnit = DEFAULT_TIMEOUT_UNIT;
        this.index = "twitter";
        this.type = "tweet";
        this.isJsonInsert = false;
        this.jsonField = null;
        this.idOutField = null;
        this.useOutput = false;
        this.stopOnError = true;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (StringUtils.isNotBlank((String)this.getIdOutField())) {
            ValueMeta valueMeta = new ValueMeta(space.environmentSubstitute(this.getIdOutField()), 2);
            valueMeta.setOrigin(name);
            if (!r.exists((ValueMetaInterface)valueMeta)) {
                r.addValueMeta((ValueMetaInterface)valueMeta);
            }
        }
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            Node general = XMLHandler.getSubNode((Node)stepnode, (String)"general");
            this.batchSize = XMLHandler.getTagValue((Node)general, (String)"batchSize");
            this.timeout = XMLHandler.getTagValue((Node)general, (String)"timeout");
            String timeoutStr = XMLHandler.getTagValue((Node)general, (String)"timeoutUnit");
            try {
                this.timeoutUnit = TimeUnit.valueOf(timeoutStr);
            }
            catch (Exception e) {
                this.timeoutUnit = DEFAULT_TIMEOUT_UNIT;
            }
            this.setIndex(XMLHandler.getTagValue((Node)general, (String)"index"));
            this.setType(XMLHandler.getTagValue((Node)general, (String)"type"));
            this.setJsonInsert(ElasticSearchBulkMeta.parseBool(XMLHandler.getTagValue((Node)general, (String)"isJson")));
            this.setJsonField(XMLHandler.getTagValue((Node)general, (String)"jsonField"));
            this.setIdInField(XMLHandler.getTagValue((Node)general, (String)"idField"));
            this.setOverWriteIfSameId(ElasticSearchBulkMeta.parseBool(XMLHandler.getTagValue((Node)general, (String)"overwriteIfExists")));
            this.setIdOutField(XMLHandler.getTagValue((Node)general, (String)"idOutputField"));
            this.setUseOutput(ElasticSearchBulkMeta.parseBool(XMLHandler.getTagValue((Node)general, (String)"useOutput")));
            this.setStopOnError(ElasticSearchBulkMeta.parseBool(XMLHandler.getTagValue((Node)general, (String)"stopOnError")));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.clearFields();
            for (int i = 0; i < nrFields; ++i) {
                Node fNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                String colName = XMLHandler.getTagValue((Node)fNode, (String)"columnName");
                String targetName = XMLHandler.getTagValue((Node)fNode, (String)"targetName");
                this.addField(colName, targetName);
            }
            Node servers = XMLHandler.getSubNode((Node)stepnode, (String)"servers");
            int nrServers = XMLHandler.countNodes((Node)servers, (String)"server");
            this.clearServers();
            for (int i = 0; i < nrServers; ++i) {
                Node sNode = XMLHandler.getSubNodeByNr((Node)servers, (String)"server", (int)i);
                String addr = XMLHandler.getTagValue((Node)sNode, (String)"address");
                String portStr = XMLHandler.getTagValue((Node)sNode, (String)"port");
                int port = 9300;
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                this.addServer(addr, port);
            }
            Node settings = XMLHandler.getSubNode((Node)stepnode, (String)"settings");
            int nrSettings = XMLHandler.countNodes((Node)settings, (String)"setting");
            this.clearSettings();
            for (int i = 0; i < nrSettings; ++i) {
                Node sNode = XMLHandler.getSubNodeByNr((Node)settings, (String)"setting", (int)i);
                String name = XMLHandler.getTagValue((Node)sNode, (String)"name");
                String value = XMLHandler.getTagValue((Node)sNode, (String)"value");
                this.addSetting(name, value);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    private static boolean parseBool(String val) {
        return "Y".equals(val);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        Indentation indent = new Indentation();
        indent.incr().incr();
        retval.append(indent.toString()).append(XMLHandler.openTag((String)"general")).append(Const.CR);
        indent.incr();
        retval.append(indent.toString() + XMLHandler.addTagValue((String)"index", (String)this.getIndex()));
        retval.append(indent.toString() + XMLHandler.addTagValue((String)"type", (String)this.getType()));
        retval.append(indent.toString() + XMLHandler.addTagValue((String)"batchSize", (String)this.batchSize));
        retval.append(indent.toString() + XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append(indent.toString()).append(XMLHandler.addTagValue((String)"timeoutUnit", (String)this.timeoutUnit.toString()));
        retval.append(indent.toString() + XMLHandler.addTagValue((String)"isJson", (boolean)this.isJsonInsert()));
        if (this.getJsonField() != null) {
            retval.append(indent.toString() + XMLHandler.addTagValue((String)"jsonField", (String)this.getJsonField()));
        }
        if (this.getIdOutField() != null) {
            retval.append(indent.toString() + XMLHandler.addTagValue((String)"idOutputField", (String)this.getIdOutField()));
        }
        if (this.getIdInField() != null) {
            retval.append(indent.toString() + XMLHandler.addTagValue((String)"idField", (String)this.getIdInField()));
        }
        retval.append(indent.toString() + XMLHandler.addTagValue((String)"overwriteIfExists", (boolean)this.isOverWriteIfSameId()));
        retval.append(indent.toString() + XMLHandler.addTagValue((String)"useOutput", (boolean)this.useOutput));
        retval.append(indent.toString() + XMLHandler.addTagValue((String)"stopOnError", (boolean)this.stopOnError));
        indent.decr();
        retval.append(indent.toString()).append(XMLHandler.closeTag((String)"general")).append(Const.CR);
        retval.append(indent.toString()).append(XMLHandler.openTag((String)"fields")).append(Const.CR);
        indent.incr();
        for (String colName : this.getFields().keySet()) {
            String targetName = this.getFields().get(colName);
            retval.append(indent.toString()).append(XMLHandler.openTag((String)"field")).append(Const.CR);
            indent.incr();
            retval.append(indent.toString()).append(XMLHandler.addTagValue((String)"columnName", (String)colName));
            retval.append(indent.toString()).append(XMLHandler.addTagValue((String)"targetName", (String)targetName));
            indent.decr();
            retval.append(indent.toString()).append(XMLHandler.closeTag((String)"field")).append(Const.CR);
        }
        indent.decr();
        retval.append(indent.toString()).append(XMLHandler.closeTag((String)"fields")).append(Const.CR);
        retval.append(indent.toString()).append(XMLHandler.openTag((String)"servers")).append(Const.CR);
        indent.incr();
        for (InetSocketTransportAddress istAddr : this.getServers()) {
            String address = istAddr.address().getAddress().getHostAddress();
            int port = istAddr.address().getPort();
            retval.append(indent.toString()).append(XMLHandler.openTag((String)"server")).append(Const.CR);
            indent.incr();
            retval.append(indent.toString()).append(XMLHandler.addTagValue((String)"address", (String)address));
            retval.append(indent.toString()).append(XMLHandler.addTagValue((String)"port", (int)port));
            indent.decr();
            retval.append(indent.toString()).append(XMLHandler.closeTag((String)"server")).append(Const.CR);
        }
        indent.decr();
        retval.append(indent.toString()).append(XMLHandler.closeTag((String)"servers")).append(Const.CR);
        retval.append(indent.toString()).append(XMLHandler.openTag((String)"settings")).append(Const.CR);
        indent.incr();
        for (String settingName : this.getSettings().keySet()) {
            String settingValue = this.getSettings().get(settingName);
            retval.append(indent.toString()).append(XMLHandler.openTag((String)"setting")).append(Const.CR);
            indent.incr();
            retval.append(indent.toString()).append(XMLHandler.addTagValue((String)"name", (String)settingName));
            retval.append(indent.toString()).append(XMLHandler.addTagValue((String)"value", (String)settingValue));
            indent.decr();
            retval.append(indent.toString()).append(XMLHandler.closeTag((String)"setting")).append(Const.CR);
        }
        indent.decr();
        retval.append(indent.toString()).append(XMLHandler.closeTag((String)"settings")).append(Const.CR);
        return retval.toString();
    }

    private static String joinRepAttr(String ... args) {
        return StringUtils.join((Object[])args, (String)"_");
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.setIndex(rep.getStepAttributeString(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "index")));
            this.setType(rep.getStepAttributeString(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "type")));
            this.setBatchSize(rep.getStepAttributeString(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "batchSize")));
            this.setTimeOut(rep.getStepAttributeString(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "timeout")));
            String timeoutStr = rep.getStepAttributeString(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "timeoutUnit"));
            try {
                this.timeoutUnit = TimeUnit.valueOf(timeoutStr);
            }
            catch (Exception e) {
                this.timeoutUnit = DEFAULT_TIMEOUT_UNIT;
            }
            this.setJsonInsert(rep.getStepAttributeBoolean(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "isJson")));
            this.setJsonField(rep.getStepAttributeString(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "jsonField")));
            this.setIdInField(rep.getStepAttributeString(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "idField")));
            this.setOverWriteIfSameId(rep.getStepAttributeBoolean(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "overwriteIfExists")));
            this.setIdOutField(rep.getStepAttributeString(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "idOutputField")));
            this.setUseOutput(rep.getStepAttributeBoolean(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "useOutput")));
            this.setStopOnError(rep.getStepAttributeBoolean(id_step, ElasticSearchBulkMeta.joinRepAttr("general", "stopOnError")));
            this.clearFields();
            int fieldsNr = rep.countNrStepAttributes(id_step, ElasticSearchBulkMeta.joinRepAttr("field", "columnName"));
            for (int i = 0; i < fieldsNr; ++i) {
                String name = rep.getStepAttributeString(id_step, i, ElasticSearchBulkMeta.joinRepAttr("field", "columnName"));
                String target = rep.getStepAttributeString(id_step, i, ElasticSearchBulkMeta.joinRepAttr("field", "targetName"));
                this.addField(name, target);
            }
            this.clearServers();
            int serversNr = rep.countNrStepAttributes(id_step, ElasticSearchBulkMeta.joinRepAttr("server", "address"));
            for (int i = 0; i < serversNr; ++i) {
                String addr = rep.getStepAttributeString(id_step, i, ElasticSearchBulkMeta.joinRepAttr("server", "address"));
                int port = (int)rep.getStepAttributeInteger(id_step, i, ElasticSearchBulkMeta.joinRepAttr("server", "port"));
                this.addServer(addr, port);
            }
            this.clearSettings();
            int settingsNr = rep.countNrStepAttributes(id_step, ElasticSearchBulkMeta.joinRepAttr("setting", "name"));
            for (int i = 0; i < settingsNr; ++i) {
                String name = rep.getStepAttributeString(id_step, i, ElasticSearchBulkMeta.joinRepAttr("setting", "name"));
                String value = rep.getStepAttributeString(id_step, i, ElasticSearchBulkMeta.joinRepAttr("setting", "value"));
                this.addSetting(name, value);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ElasticSearchBulkMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "index"), this.getIndex());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "type"), this.getType());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "batchSize"), this.batchSize);
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "timeout"), this.getTimeOut());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "timeoutUnit"), this.getTimeoutUnit().toString());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "isJson"), this.isJsonInsert());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "jsonField"), this.getJsonField());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "idField"), this.getIdInField());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "overwriteIfExists"), this.isOverWriteIfSameId());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "idOutputField"), this.getIdOutField());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "useOutput"), this.isUseOutput());
            rep.saveStepAttribute(id_transformation, id_step, ElasticSearchBulkMeta.joinRepAttr("general", "stopOnError"), this.isStopOnError());
            String[] fieldNames = this.getFields().keySet().toArray(new String[this.getFields().keySet().size()]);
            for (i = 0; i < fieldNames.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, ElasticSearchBulkMeta.joinRepAttr("field", "columnName"), fieldNames[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, ElasticSearchBulkMeta.joinRepAttr("field", "targetName"), this.getFields().get(fieldNames[i]));
            }
            for (i = 0; i < this.getServers().length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, ElasticSearchBulkMeta.joinRepAttr("server", "address"), this.getServers()[i].address().getAddress().getHostAddress());
                rep.saveStepAttribute(id_transformation, id_step, i, ElasticSearchBulkMeta.joinRepAttr("server", "port"), this.getServers()[i].address().getPort());
            }
            String[] settingNames = this.getSettings().keySet().toArray(new String[this.getSettings().keySet().size()]);
            for (int i2 = 0; i2 < settingNames.length; ++i2) {
                rep.saveStepAttribute(id_transformation, id_step, i2, ElasticSearchBulkMeta.joinRepAttr("setting", "name"), settingNames[i2]);
                rep.saveStepAttribute(id_transformation, id_step, i2, ElasticSearchBulkMeta.joinRepAttr("setting", "value"), this.getSettings().get(settingNames[i2]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ElasticSearchBulkMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        this.checkBasicRequiredFields(remarks, stepMeta);
        this.checkInputFields(remarks, prev, stepMeta);
    }

    private void checkBasicRequiredFields(List<CheckResultInterface> remarks, StepMeta stepMeta) {
        this.checkRequiredString(remarks, stepMeta, this.getIndex(), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Index.Label", (String[])new String[0]));
        this.checkRequiredString(remarks, stepMeta, this.getType(), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Type.Label", (String[])new String[0]));
        this.checkRequiredString(remarks, stepMeta, this.getBatchSize(), BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.BatchSize.Label", (String[])new String[0]));
    }

    private void checkRequiredString(List<CheckResultInterface> remarks, StepMeta stepMeta, String value, String fieldName) {
        if (StringUtils.isBlank((String)value)) {
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"ElasticSearchBulkMeta.CheckResult.MissingRequired", (String[])new String[]{fieldName}), (CheckResultSourceInterface)stepMeta));
        } else {
            remarks.add((CheckResultInterface)new CheckResult(1, BaseMessages.getString(PKG, (String)"ElasticSearchBulkMeta.CheckResult.RequiredOK", (String[])new String[]{fieldName, value}), (CheckResultSourceInterface)stepMeta));
        }
    }

    private void checkInputFields(List<CheckResultInterface> remarks, RowMetaInterface prev, StepMeta stepMeta) {
        if (prev != null && prev.size() > 0) {
            if (this.isJsonInsert()) {
                if (StringUtils.isBlank((String)this.getJsonField())) {
                    String jsonFieldLabel = BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.JsonField.Label", (String[])new String[0]);
                    String isJsonLabel = BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.IsJson.Label", (String[])new String[0]);
                    remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"ElasticSearchBulkMeta.CheckResult.MissingRequiredDependent", (String[])new String[]{jsonFieldLabel, isJsonLabel}), (CheckResultSourceInterface)stepMeta));
                } else if (prev.indexOfValue(this.getJsonField()) < 0) {
                    remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"ElasticSearchBulkMeta.CheckResult.MissingInput", (String[])new String[]{this.getJsonField()}), (CheckResultSourceInterface)stepMeta));
                }
            } else {
                for (String fieldName : this.getFields().keySet()) {
                    if (prev.indexOfValue(fieldName) >= 0) continue;
                    remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"ElasticSearchBulkMeta.CheckResult.MissingInput", (String[])new String[]{fieldName}), (CheckResultSourceInterface)stepMeta));
                }
            }
        } else {
            remarks.add((CheckResultInterface)new CheckResult(4, BaseMessages.getString(PKG, (String)"ElasticSearchBulkMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ElasticSearchBulk(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ElasticSearchBulkData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    private static class Indentation {
        private static String indentUnit = "  ";
        private String indent = "";
        private int indentLevel = 0;

        private Indentation() {
        }

        public Indentation incr() {
            ++this.indentLevel;
            this.indent = this.indent + indentUnit;
            return this;
        }

        public Indentation decr() {
            if (--this.indentLevel >= 0) {
                this.indent = this.indent.substring(0, this.indent.length() - indentUnit.length());
            }
            return this;
        }

        public String toString() {
            return this.indent;
        }
    }

    private static class Dom {
        static final String TAG_GENERAL = "general";
        static final String TAG_INDEX = "index";
        static final String TAG_TYPE = "type";
        static final String TAG_IS_JSON = "isJson";
        static final String TAG_JSON_FIELD = "jsonField";
        static final String TAG_ID_IN_FIELD = "idField";
        static final String TAG_OVERWRITE_IF_EXISTS = "overwriteIfExists";
        static final String TAG_ID_OUT_FIELD = "idOutputField";
        static final String TAG_USE_OUTPUT = "useOutput";
        static final String TAG_STOP_ON_ERROR = "stopOnError";
        static final String TAG_TIMEOUT = "timeout";
        static final String TAG_TIMEOUT_UNIT = "timeoutUnit";
        static final String TAG_BATCH_SIZE = "batchSize";
        static final String TAG_FIELDS = "fields";
        static final String TAG_FIELD = "field";
        static final String TAG_NAME = "columnName";
        static final String TAG_TARGET = "targetName";
        static final String TAG_SERVERS = "servers";
        static final String TAG_SERVER = "server";
        static final String TAG_SERVER_ADDRESS = "address";
        static final String TAG_SERVER_PORT = "port";
        public static final String TAG_SETTINGS = "settings";
        public static final String TAG_SETTING = "setting";
        public static final String TAG_SETTING_NAME = "name";
        public static final String TAG_SETTING_VALUE = "value";
        static final String INDENT = "  ";

        private Dom() {
        }
    }
}

