/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.excelinput.ExcelInput;
import org.pentaho.di.trans.steps.excelinput.ExcelInputData;
import org.pentaho.di.trans.steps.excelinput.ExcelInputField;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMetaInjection;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class ExcelInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ExcelInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] type_trim_code = new String[]{"none", "left", "right", "both"};
    public static final String[] type_trim_desc = new String[]{BaseMessages.getString(PKG, (String)"ExcelInputMeta.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputMeta.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputMeta.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputMeta.TrimType.Both", (String[])new String[0])};
    public static final String STRING_SEPARATOR = " \t --> ";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private String[] fileRequired;
    private String fileField;
    private String[] sheetName;
    private int[] startRow;
    private int[] startColumn;
    private String sheetField;
    private boolean startsWithHeader;
    private boolean stopOnEmpty;
    private boolean ignoreEmptyRows;
    private String rowNumberField;
    private String sheetRowNumberField;
    private long rowLimit;
    private ExcelInputField[] field;
    private boolean strictTypes;
    private boolean errorIgnored;
    private boolean errorLineSkipped;
    private String warningFilesDestinationDirectory;
    private String warningFilesExtension;
    private String errorFilesDestinationDirectory;
    private String errorFilesExtension;
    private String lineNumberFilesDestinationDirectory;
    private String lineNumberFilesExtension;
    private boolean acceptingFilenames;
    private String acceptingField;
    private String acceptingStepName;
    private String[] includeSubFolders;
    private StepMeta acceptingStep;
    private String encoding;
    private boolean isaddresult;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;
    private String sizeFieldName;
    private SpreadSheetType spreadSheetType;

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String getSizeField() {
        return this.sizeFieldName;
    }

    public void setSizeField(String field) {
        this.sizeFieldName = field;
    }

    public ExcelInputField[] getField() {
        return this.field;
    }

    public void setField(ExcelInputField[] fields) {
        this.field = fields;
    }

    public String getFileField() {
        return this.fileField;
    }

    public void setFileField(String fileField) {
        this.fileField = fileField;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        this.includeSubFolders = new String[includeSubFoldersin.length];
        for (int i = 0; i < includeSubFoldersin.length && i < this.includeSubFolders.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public boolean ignoreEmptyRows() {
        return this.ignoreEmptyRows;
    }

    public void setIgnoreEmptyRows(boolean ignoreEmptyRows) {
        this.ignoreEmptyRows = ignoreEmptyRows;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getSheetRowNumberField() {
        return this.sheetRowNumberField;
    }

    public void setSheetRowNumberField(String rowNumberField) {
        this.sheetRowNumberField = rowNumberField;
    }

    public String getSheetField() {
        return this.sheetField;
    }

    public void setSheetField(String sheetField) {
        this.sheetField = sheetField;
    }

    public String[] getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String[] sheetName) {
        this.sheetName = sheetName;
    }

    public int[] getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int[] startColumn) {
        this.startColumn = startColumn;
    }

    public int[] getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int[] startRow) {
        this.startRow = startRow;
    }

    public boolean startsWithHeader() {
        return this.startsWithHeader;
    }

    public void setStartsWithHeader(boolean startsWithHeader) {
        this.startsWithHeader = startsWithHeader;
    }

    public boolean stopOnEmpty() {
        return this.stopOnEmpty;
    }

    public void setStopOnEmpty(boolean stopOnEmpty) {
        this.stopOnEmpty = stopOnEmpty;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        ExcelInputMeta retval = (ExcelInputMeta)super.clone();
        int nrfiles = this.fileName.length;
        int nrsheets = this.sheetName.length;
        int nrfields = this.field.length;
        retval.allocate(nrfiles, nrsheets, nrfields);
        for (i = 0; i < nrfields; ++i) {
            retval.field[i] = (ExcelInputField)this.field[i].clone();
        }
        for (i = 0; i < nrfiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
            retval.excludeFileMask[i] = this.excludeFileMask[i];
            retval.fileRequired[i] = this.fileRequired[i];
            retval.includeSubFolders[i] = this.includeSubFolders[i];
        }
        for (i = 0; i < nrsheets; ++i) {
            retval.sheetName[i] = this.sheetName[i];
            retval.startColumn[i] = this.startColumn[i];
            retval.startRow[i] = this.startRow[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.startsWithHeader = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            String nempty = XMLHandler.getTagValue((Node)stepnode, (String)"noempty");
            this.ignoreEmptyRows = YES.equalsIgnoreCase(nempty) || nempty == null;
            String soempty = XMLHandler.getTagValue((Node)stepnode, (String)"stoponempty");
            this.stopOnEmpty = YES.equalsIgnoreCase(soempty) || nempty == null;
            this.sheetRowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"sheetrownumfield");
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownumfield");
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            String addToResult = XMLHandler.getTagValue((Node)stepnode, (String)"add_to_result_filenames");
            this.isaddresult = Const.isEmpty((String)addToResult) ? true : YES.equalsIgnoreCase(addToResult);
            this.sheetField = XMLHandler.getTagValue((Node)stepnode, (String)"sheetfield");
            this.fileField = XMLHandler.getTagValue((Node)stepnode, (String)"filefield");
            this.acceptingFilenames = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"accept_filenames"));
            this.acceptingField = XMLHandler.getTagValue((Node)stepnode, (String)"accept_field");
            this.acceptingStepName = XMLHandler.getTagValue((Node)stepnode, (String)"accept_stepname");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node sheetsnode = XMLHandler.getSubNode((Node)stepnode, (String)"sheets");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrsheets = XMLHandler.countNodes((Node)sheetsnode, (String)"sheet");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfiles, nrsheets, nrfields);
            for (i = 0; i < nrfiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.field[i] = new ExcelInputField();
                this.field[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.field[i].setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                this.field[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.field[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                String srepeat = XMLHandler.getTagValue((Node)fnode, (String)"repeat");
                this.field[i].setTrimType(ExcelInputMeta.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
                if (srepeat != null) {
                    this.field[i].setRepeated(YES.equalsIgnoreCase(srepeat));
                } else {
                    this.field[i].setRepeated(false);
                }
                this.field[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.field[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.field[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.field[i].setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
            }
            for (i = 0; i < nrsheets; ++i) {
                Node snode = XMLHandler.getSubNodeByNr((Node)sheetsnode, (String)"sheet", (int)i);
                this.sheetName[i] = XMLHandler.getTagValue((Node)snode, (String)"name");
                this.startRow[i] = Const.toInt((String)XMLHandler.getTagValue((Node)snode, (String)"startrow"), (int)0);
                this.startColumn[i] = Const.toInt((String)XMLHandler.getTagValue((Node)snode, (String)"startcol"), (int)0);
            }
            this.strictTypes = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"strict_types"));
            this.errorIgnored = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"error_ignored"));
            this.errorLineSkipped = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"error_line_skipped"));
            this.warningFilesDestinationDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"bad_line_files_destination_directory");
            this.warningFilesExtension = XMLHandler.getTagValue((Node)stepnode, (String)"bad_line_files_extension");
            this.errorFilesDestinationDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"error_line_files_destination_directory");
            this.errorFilesExtension = XMLHandler.getTagValue((Node)stepnode, (String)"error_line_files_extension");
            this.lineNumberFilesDestinationDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"line_number_files_destination_directory");
            this.lineNumberFilesExtension = XMLHandler.getTagValue((Node)stepnode, (String)"line_number_files_extension");
            this.shortFileFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"shortFileFieldName");
            this.pathFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"pathFieldName");
            this.hiddenFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"extensionFieldName");
            this.sizeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"sizeFieldName");
            try {
                this.spreadSheetType = SpreadSheetType.valueOf(XMLHandler.getTagValue((Node)stepnode, (String)"spreadsheet_type"));
            }
            catch (Exception e) {
                this.spreadSheetType = SpreadSheetType.JXL;
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step information from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles, int nrsheets, int nrfields) {
        this.allocateFiles(nrfiles);
        this.sheetName = new String[nrsheets];
        this.startRow = new int[nrsheets];
        this.startColumn = new int[nrsheets];
        this.field = new ExcelInputField[nrfields];
    }

    public void allocateFiles(int nrfiles) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
    }

    @Override
    public void setDefault() {
        int i;
        this.startsWithHeader = true;
        this.ignoreEmptyRows = true;
        this.rowNumberField = "";
        this.sheetRowNumberField = "";
        this.isaddresult = true;
        int nrfiles = 0;
        int nrfields = 0;
        int nrsheets = 0;
        this.allocate(nrfiles, nrsheets, nrfields);
        for (i = 0; i < nrfiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = NO;
            this.includeSubFolders[i] = NO;
        }
        for (i = 0; i < nrfields; ++i) {
            this.field[i] = new ExcelInputField();
            this.field[i].setName("field" + i);
            this.field[i].setType(1);
            this.field[i].setLength(9);
            this.field[i].setPrecision(2);
            this.field[i].setTrimType(0);
            this.field[i].setRepeated(false);
        }
        this.rowLimit = 0L;
        this.strictTypes = false;
        this.errorIgnored = false;
        this.errorLineSkipped = false;
        this.warningFilesDestinationDirectory = null;
        this.warningFilesExtension = "warning";
        this.errorFilesDestinationDirectory = null;
        this.errorFilesExtension = "error";
        this.lineNumberFilesDestinationDirectory = null;
        this.lineNumberFilesExtension = "line";
        this.spreadSheetType = SpreadSheetType.JXL;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.field.length; ++i) {
            int type = this.field[i].getType();
            if (type == 0) {
                type = 2;
            }
            try {
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)this.field[i].getName(), (int)type);
                v.setLength(this.field[i].getLength());
                v.setPrecision(this.field[i].getPrecision());
                v.setOrigin(name);
                v.setConversionMask(this.field[i].getFormat());
                v.setDecimalSymbol(this.field[i].getDecimalSymbol());
                v.setGroupingSymbol(this.field[i].getGroupSymbol());
                v.setCurrencySymbol(this.field[i].getCurrencySymbol());
                row.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.fileField != null && this.fileField.length() > 0) {
            ValueMeta v = new ValueMeta(this.fileField, 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.sheetField != null && this.sheetField.length() > 0) {
            ValueMeta v = new ValueMeta(this.sheetField, 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.sheetRowNumberField != null && this.sheetRowNumberField.length() > 0) {
            ValueMeta v = new ValueMeta(this.sheetRowNumberField, 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.rowNumberField != null && this.rowNumberField.length() > 0) {
            ValueMeta v = new ValueMeta(this.rowNumberField, 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getShortFileNameField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getExtensionField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getPathField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getSizeField() != null && this.getSizeField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getSizeField()), 5);
            v.setOrigin(name);
            v.setLength(9);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.isHiddenField()), 4);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getLastModificationDateField()), 3);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getUriField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getRootUriField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(1024);
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.startsWithHeader));
        retval.append("    ").append(XMLHandler.addTagValue((String)"noempty", (boolean)this.ignoreEmptyRows));
        retval.append("    ").append(XMLHandler.addTagValue((String)"stoponempty", (boolean)this.stopOnEmpty));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filefield", (String)this.fileField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sheetfield", (String)this.sheetField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sheetrownumfield", (String)this.sheetRowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownumfield", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sheetfield", (String)this.sheetField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filefield", (String)this.fileField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.isaddresult));
        retval.append("    ").append(XMLHandler.addTagValue((String)"accept_filenames", (boolean)this.acceptingFilenames));
        retval.append("    ").append(XMLHandler.addTagValue((String)"accept_field", (String)this.acceptingField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"accept_stepname", (String)(this.acceptingStep != null ? this.acceptingStep.getName() : "")));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.field.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.field[i].getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.field[i].getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.field[i].getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.field[i].getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.field[i].getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)this.field[i].isRepeated()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.field[i].getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.field[i].getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.field[i].getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.field[i].getGroupSymbol()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    <sheets>").append(Const.CR);
        for (i = 0; i < this.sheetName.length; ++i) {
            retval.append("      <sheet>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.sheetName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"startrow", (int)this.startRow[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"startcol", (int)this.startColumn[i]));
            retval.append("        </sheet>").append(Const.CR);
        }
        retval.append("    </sheets>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"strict_types", (boolean)this.strictTypes));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_ignored", (boolean)this.errorIgnored));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_line_skipped", (boolean)this.errorLineSkipped));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bad_line_files_destination_directory", (String)this.warningFilesDestinationDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bad_line_files_extension", (String)this.warningFilesExtension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_line_files_destination_directory", (String)this.errorFilesDestinationDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_line_files_extension", (String)this.errorFilesExtension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_number_files_destination_directory", (String)this.lineNumberFilesDestinationDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_number_files_extension", (String)this.lineNumberFilesExtension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sizeFieldName", (String)this.sizeFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"spreadsheet_type", (String)this.spreadSheetType.toString()));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.startsWithHeader = rep.getStepAttributeBoolean(id_step, "header");
            this.ignoreEmptyRows = rep.getStepAttributeBoolean(id_step, "noempty");
            this.stopOnEmpty = rep.getStepAttributeBoolean(id_step, "stoponempty");
            this.fileField = rep.getStepAttributeString(id_step, "filefield");
            this.sheetField = rep.getStepAttributeString(id_step, "sheetfield");
            this.sheetRowNumberField = rep.getStepAttributeString(id_step, "sheetrownumfield");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownumfield");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            String addToResult = rep.getStepAttributeString(id_step, "add_to_result_filenames");
            this.isaddresult = Const.isEmpty((String)addToResult) ? true : rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            this.acceptingFilenames = rep.getStepAttributeBoolean(id_step, "accept_filenames");
            this.acceptingField = rep.getStepAttributeString(id_step, "accept_field");
            this.acceptingStepName = rep.getStepAttributeString(id_step, "accept_stepname");
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrsheets = rep.countNrStepAttributes(id_step, "sheet_name");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfiles, nrsheets, nrfields);
            for (i = 0; i < nrfiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!YES.equalsIgnoreCase(this.fileRequired[i])) {
                    this.fileRequired[i] = NO;
                }
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if (YES.equalsIgnoreCase(this.includeSubFolders[i])) continue;
                this.includeSubFolders[i] = NO;
            }
            for (i = 0; i < nrsheets; ++i) {
                this.sheetName[i] = rep.getStepAttributeString(id_step, i, "sheet_name");
                this.startRow[i] = (int)rep.getStepAttributeInteger(id_step, i, "sheet_startrow");
                this.startColumn[i] = (int)rep.getStepAttributeInteger(id_step, i, "sheet_startcol");
            }
            for (i = 0; i < nrfields; ++i) {
                this.field[i] = new ExcelInputField();
                this.field[i].setName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.field[i].setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                this.field[i].setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                this.field[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                this.field[i].setTrimType(ExcelInputMeta.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                this.field[i].setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.field[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                this.field[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                this.field[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                this.field[i].setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
            }
            this.strictTypes = rep.getStepAttributeBoolean(id_step, 0, "strict_types", false);
            this.errorIgnored = rep.getStepAttributeBoolean(id_step, 0, "error_ignored", false);
            this.errorLineSkipped = rep.getStepAttributeBoolean(id_step, 0, "error_line_skipped", false);
            this.warningFilesDestinationDirectory = rep.getStepAttributeString(id_step, "bad_line_files_dest_dir");
            this.warningFilesExtension = rep.getStepAttributeString(id_step, "bad_line_files_ext");
            this.errorFilesDestinationDirectory = rep.getStepAttributeString(id_step, "error_line_files_dest_dir");
            this.errorFilesExtension = rep.getStepAttributeString(id_step, "error_line_files_ext");
            this.lineNumberFilesDestinationDirectory = rep.getStepAttributeString(id_step, "line_number_files_dest_dir");
            this.lineNumberFilesExtension = rep.getStepAttributeString(id_step, "line_number_files_ext");
            this.shortFileFieldName = rep.getStepAttributeString(id_step, "shortFileFieldName");
            this.pathFieldName = rep.getStepAttributeString(id_step, "pathFieldName");
            this.hiddenFieldName = rep.getStepAttributeString(id_step, "hiddenFieldName");
            this.lastModificationTimeFieldName = rep.getStepAttributeString(id_step, "lastModificationTimeFieldName");
            this.rootUriNameFieldName = rep.getStepAttributeString(id_step, "rootUriNameFieldName");
            this.uriNameFieldName = rep.getStepAttributeString(id_step, "uriNameFieldName");
            this.extensionFieldName = rep.getStepAttributeString(id_step, "extensionFieldName");
            this.sizeFieldName = rep.getStepAttributeString(id_step, "sizeFieldName");
            try {
                this.spreadSheetType = SpreadSheetType.valueOf(rep.getStepAttributeString(id_step, "spreadsheet_type"));
            }
            catch (Exception e) {
                this.spreadSheetType = SpreadSheetType.JXL;
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "header", this.startsWithHeader);
            rep.saveStepAttribute(id_transformation, id_step, "noempty", this.ignoreEmptyRows);
            rep.saveStepAttribute(id_transformation, id_step, "stoponempty", this.stopOnEmpty);
            rep.saveStepAttribute(id_transformation, id_step, "filefield", this.fileField);
            rep.saveStepAttribute(id_transformation, id_step, "sheetfield", this.sheetField);
            rep.saveStepAttribute(id_transformation, id_step, "sheetrownumfield", this.sheetRowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "rownumfield", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, "accept_filenames", this.acceptingFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "accept_field", this.acceptingField);
            rep.saveStepAttribute(id_transformation, id_step, "accept_stepname", this.acceptingStep != null ? this.acceptingStep.getName() : "");
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
            for (i = 0; i < this.sheetName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "sheet_name", this.sheetName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "sheet_startrow", this.startRow[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "sheet_startcol", this.startColumn[i]);
            }
            for (i = 0; i < this.field.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.field[i].getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", this.field[i].getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.field[i].getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.field[i].getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", this.field[i].getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", this.field[i].isRepeated());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.field[i].getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", this.field[i].getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.field[i].getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.field[i].getGroupSymbol());
            }
            rep.saveStepAttribute(id_transformation, id_step, "strict_types", this.strictTypes);
            rep.saveStepAttribute(id_transformation, id_step, "error_ignored", this.errorIgnored);
            rep.saveStepAttribute(id_transformation, id_step, "error_line_skipped", this.errorLineSkipped);
            rep.saveStepAttribute(id_transformation, id_step, "bad_line_files_dest_dir", this.warningFilesDestinationDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "bad_line_files_ext", this.warningFilesExtension);
            rep.saveStepAttribute(id_transformation, id_step, "error_line_files_dest_dir", this.errorFilesDestinationDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "error_line_files_ext", this.errorFilesExtension);
            rep.saveStepAttribute(id_transformation, id_step, "line_number_files_dest_dir", this.lineNumberFilesDestinationDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "line_number_files_ext", this.lineNumberFilesExtension);
            rep.saveStepAttribute(id_transformation, id_step, "shortFileFieldName", this.shortFileFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "pathFieldName", this.pathFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "hiddenFieldName", this.hiddenFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "lastModificationTimeFieldName", this.lastModificationTimeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "uriNameFieldName", this.uriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rootUriNameFieldName", this.rootUriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "extensionFieldName", this.extensionFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "sizeFieldName", this.sizeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "spreadsheet_type", this.spreadSheetType.toString());
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt != null) {
            for (int i = 0; i < type_trim_code.length; ++i) {
                if (!type_trim_code[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt != null) {
            for (int i = 0; i < type_trim_desc.length; ++i) {
                if (!type_trim_desc[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= type_trim_code.length) {
            return type_trim_code[0];
        }
        return type_trim_code[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= type_trim_desc.length) {
            return type_trim_desc[0];
        }
        return type_trim_desc[i];
    }

    public String[] getFilePaths(VariableSpace space) {
        return FileInputList.createFilePathList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    public FileInputList getFileList(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    public String getLookupStepname() {
        if (this.acceptingFilenames && this.acceptingStep != null && !Const.isEmpty((String)this.acceptingStep.getName())) {
            return this.acceptingStep.getName();
        }
        return null;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.acceptingStep = StepMeta.findStep(steps, this.acceptingStepName);
    }

    public String[] getInfoSteps() {
        return null;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.AcceptFilenamesOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.NoInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList fileList = this.getFileList(transMeta);
        if (fileList.nrOfFiles() == 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + fileList.nrOfFiles()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public RowMetaInterface getEmptyFields() {
        RowMeta row = new RowMeta();
        for (int i = 0; i < this.field.length; ++i) {
            ValueMeta v = new ValueMeta(this.field[i].getName(), this.field[i].getType());
            row.addValueMeta((ValueMetaInterface)v);
        }
        return row;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ExcelInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ExcelInputData();
    }

    public String getWarningFilesDestinationDirectory() {
        return this.warningFilesDestinationDirectory;
    }

    public void setWarningFilesDestinationDirectory(String badLineFilesDestinationDirectory) {
        this.warningFilesDestinationDirectory = badLineFilesDestinationDirectory;
    }

    public String getBadLineFilesExtension() {
        return this.warningFilesExtension;
    }

    public void setBadLineFilesExtension(String badLineFilesExtension) {
        this.warningFilesExtension = badLineFilesExtension;
    }

    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    public void setErrorIgnored(boolean errorIgnored) {
        this.errorIgnored = errorIgnored;
    }

    public String getErrorFilesDestinationDirectory() {
        return this.errorFilesDestinationDirectory;
    }

    public void setErrorFilesDestinationDirectory(String errorLineFilesDestinationDirectory) {
        this.errorFilesDestinationDirectory = errorLineFilesDestinationDirectory;
    }

    public String getErrorFilesExtension() {
        return this.errorFilesExtension;
    }

    public void setErrorFilesExtension(String errorLineFilesExtension) {
        this.errorFilesExtension = errorLineFilesExtension;
    }

    public String getLineNumberFilesDestinationDirectory() {
        return this.lineNumberFilesDestinationDirectory;
    }

    public void setLineNumberFilesDestinationDirectory(String lineNumberFilesDestinationDirectory) {
        this.lineNumberFilesDestinationDirectory = lineNumberFilesDestinationDirectory;
    }

    public String getLineNumberFilesExtension() {
        return this.lineNumberFilesExtension;
    }

    public void setLineNumberFilesExtension(String lineNumberFilesExtension) {
        this.lineNumberFilesExtension = lineNumberFilesExtension;
    }

    public boolean isErrorLineSkipped() {
        return this.errorLineSkipped;
    }

    public void setErrorLineSkipped(boolean errorLineSkipped) {
        this.errorLineSkipped = errorLineSkipped;
    }

    public boolean isStrictTypes() {
        return this.strictTypes;
    }

    public void setStrictTypes(boolean strictTypes) {
        this.strictTypes = strictTypes;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        this.fileRequired = new String[fileRequiredin.length];
        for (int i = 0; i < fileRequiredin.length && i < this.fileRequired.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String getAcceptingField() {
        return this.acceptingField;
    }

    public void setAcceptingField(String acceptingField) {
        this.acceptingField = acceptingField;
    }

    public boolean isAcceptingFilenames() {
        return this.acceptingFilenames;
    }

    public void setAcceptingFilenames(boolean acceptingFilenames) {
        this.acceptingFilenames = acceptingFilenames;
    }

    public StepMeta getAcceptingStep() {
        return this.acceptingStep;
    }

    public void setAcceptingStep(StepMeta acceptingStep) {
        this.acceptingStep = acceptingStep;
    }

    public String getAcceptingStepName() {
        return this.acceptingStepName;
    }

    public void setAcceptingStepName(String acceptingStepName) {
        this.acceptingStepName = acceptingStepName;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"jxl.jar"};
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public boolean readAllSheets() {
        return Const.isEmpty((String[])this.sheetName) || this.sheetName.length == 1 && Const.isEmpty((String)this.sheetName[0]);
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.acceptingFilenames) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                    this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Const.isEmpty((String)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public SpreadSheetType getSpreadSheetType() {
        return this.spreadSheetType;
    }

    public void setSpreadSheetType(SpreadSheetType spreadSheetType) {
        this.spreadSheetType = spreadSheetType;
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new ExcelInputMetaInjection(this);
    }
}

