/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.googleanalytics;

import com.google.gdata.client.analytics.AnalyticsService;
import com.google.gdata.client.analytics.DataQuery;
import com.google.gdata.data.analytics.DataEntry;
import com.google.gdata.data.analytics.DataFeed;
import com.google.gdata.data.analytics.DataSource;
import com.google.gdata.data.analytics.Dimension;
import com.google.gdata.data.analytics.Metric;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.googleanalytics.GaInputStepData;
import org.pentaho.di.trans.steps.googleanalytics.GaInputStepMeta;

public class GaInputStep
extends BaseStep
implements StepInterface {
    private GaInputStepData data;
    private GaInputStepMeta meta;

    public GaInputStep(StepMeta s, StepDataInterface stepDataInterface, int c, TransMeta t, Trans dis) {
        super(s, stepDataInterface, c, t, dis);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GaInputStepMeta)smi;
        this.data = (GaInputStepData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.conversionMeta = new ValueMetaInterface[this.meta.getFeedField().length];
            for (int i = 0; i < this.meta.getFeedField().length; ++i) {
                ValueMetaInterface returnMeta = this.data.outputRowMeta.getValueMeta(i);
                ValueMetaInterface conversionMeta = this.meta.getFeedFieldType()[i].equals("Confidence Interval for Metric") ? ValueMetaFactory.cloneValueMeta((ValueMetaInterface)returnMeta, (int)1) : ValueMetaFactory.cloneValueMeta((ValueMetaInterface)returnMeta, (int)2);
                conversionMeta.setConversionMask(this.meta.getConversionMask()[i]);
                conversionMeta.setDecimalSymbol(".");
                conversionMeta.setGroupingSymbol(null);
                this.data.conversionMeta[i] = conversionMeta;
            }
        }
        Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        DataEntry entry = this.getNextDataEntry();
        if (entry != null && (this.meta.getRowLimit() <= 0 || this.getLinesWritten() < (long)this.meta.getRowLimit())) {
            for (int i = 0; i < this.meta.getFeedField().length; ++i) {
                DataSource d;
                Metric metric;
                String value = null;
                String fieldName = this.environmentSubstitute(this.meta.getFeedField()[i]);
                String fieldType = this.meta.getFeedFieldType()[i];
                if (fieldType.equals("Confidence Interval for Metric")) {
                    metric = entry.getMetric(fieldName);
                    Double interval = metric.getConfidenceInterval();
                    outputRow[i] = this.data.outputRowMeta.getValueMeta(i).convertData(this.data.conversionMeta[i], (Object)interval);
                    continue;
                }
                if (fieldType.equals("Dimension")) {
                    Dimension dim = entry.getDimension(fieldName);
                    value = dim.getValue();
                    outputRow[i] = this.data.outputRowMeta.getValueMeta(i).convertData(this.data.conversionMeta[i], (Object)value);
                    continue;
                }
                if (fieldType.equals("Metric")) {
                    metric = entry.getMetric(fieldName);
                    value = metric.getValue();
                    outputRow[i] = this.data.outputRowMeta.getValueMeta(i).convertData(this.data.conversionMeta[i], (Object)value);
                    continue;
                }
                if (fieldType.equals("Data Source Property")) {
                    DataSource dataSource = d = this.data.feed.getDataSources().size() > 0 ? (DataSource)this.data.feed.getDataSources().get(0) : null;
                    if (d == null) continue;
                    value = d.getProperty(fieldName);
                    outputRow[i] = this.data.outputRowMeta.getValueMeta(i).convertData(this.data.conversionMeta[i], (Object)value);
                    continue;
                }
                if (!fieldType.equals("Data Source Field")) continue;
                DataSource dataSource = d = this.data.feed.getDataSources().size() > 0 ? (DataSource)this.data.feed.getDataSources().get(0) : null;
                if (d == null) continue;
                if (fieldName.equalsIgnoreCase("dxp:tableId")) {
                    value = d.getTableId().getValue();
                    outputRow[i] = this.data.outputRowMeta.getValueMeta(i).convertData(this.data.conversionMeta[i], (Object)value);
                    continue;
                }
                if (!fieldName.equalsIgnoreCase("dxp:tableName")) continue;
                value = d.getTableName().getValue();
                outputRow[i] = this.data.outputRowMeta.getValueMeta(i).convertData(this.data.conversionMeta[i], (Object)value);
            }
            this.putRow(this.data.outputRowMeta, outputRow);
            if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
                this.logBasic("Linenr " + this.getLinesWritten());
            }
            return true;
        }
        this.setOutputDone();
        return false;
    }

    protected DataQuery getQuery() {
        DataQuery query = null;
        try {
            query = new DataQuery(new URL("https://www.googleapis.com/analytics/v2.4/data"));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
        query.setIds(this.meta.isUseCustomTableId() ? this.environmentSubstitute(this.meta.getGaCustomTableId()) : this.meta.getGaProfileTableId());
        query.setStartDate(this.environmentSubstitute(this.meta.getStartDate()));
        query.setEndDate(this.environmentSubstitute(this.meta.getEndDate()));
        query.setDimensions(this.environmentSubstitute(this.meta.getDimensions()));
        query.setMetrics(this.environmentSubstitute(this.meta.getMetrics()));
        if (this.meta.isUseSegment()) {
            if (this.meta.isUseCustomSegment()) {
                query.setSegment(this.environmentSubstitute(this.meta.getCustomSegment()));
            } else {
                query.setSegment(this.meta.getSegmentId());
            }
        }
        if (!Const.isEmpty((String)this.meta.getFilters())) {
            query.setFilters(this.environmentSubstitute(this.meta.getFilters()));
        }
        if (!Const.isEmpty((String)this.meta.getSort())) {
            query.setSort(this.environmentSubstitute(this.meta.getSort()));
        }
        if (!Const.isEmpty((String)this.meta.getGaApiKey())) {
            query.setStringCustomParameter("key", Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getGaApiKey())));
        }
        return query;
    }

    private DataEntry getNextDataEntry() throws KettleException {
        List entries;
        String email;
        if (this.data.query == null) {
            this.data.query = this.getQuery();
            if (this.log.isDetailed()) {
                this.logDetailed("querying google analytics: " + this.data.query.getUrl());
            }
            email = this.environmentSubstitute(this.meta.getGaEmail());
            String pass = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getGaPassword()));
            AnalyticsService analyticsService = new AnalyticsService(this.environmentSubstitute(this.meta.getGaAppName()));
            try {
                analyticsService.setUserCredentials(email, pass);
                this.data.feed = (DataFeed)analyticsService.getFeed(this.data.query.getUrl(), DataFeed.class);
                this.data.entryIndex = 0;
            }
            catch (AuthenticationException e1) {
                throw new KettleException((Throwable)e1);
            }
            catch (IOException e2) {
                throw new KettleException((Throwable)e2);
            }
            catch (ServiceException e3) {
                throw new KettleException((Throwable)e3);
            }
        }
        if (this.data.entryIndex >= this.data.feed.getEntries().size() && this.data.feed.getStartIndex() + this.data.entryIndex <= this.data.feed.getTotalResults()) {
            this.data.query.setStartIndex(this.data.feed.getStartIndex() + this.data.entryIndex);
            if (this.log.isDetailed()) {
                this.logDetailed("querying google analytics: " + this.data.query.getUrl());
            }
            email = this.environmentSubstitute(this.meta.getGaEmail());
            String pass = this.environmentSubstitute(this.meta.getGaPassword());
            AnalyticsService analyticsService = new AnalyticsService(this.environmentSubstitute(this.meta.getGaAppName()));
            try {
                analyticsService.setUserCredentials(email, pass);
                this.data.feed = (DataFeed)analyticsService.getFeed(this.data.query.getUrl(), DataFeed.class);
                this.data.entryIndex = 0;
            }
            catch (AuthenticationException e1) {
                throw new KettleException((Throwable)e1);
            }
            catch (IOException e2) {
                throw new KettleException((Throwable)e2);
            }
            catch (ServiceException e3) {
                throw new KettleException((Throwable)e3);
            }
        }
        if (this.data.entryIndex < (entries = this.data.feed.getEntries()).size()) {
            return (DataEntry)entries.get(this.data.entryIndex++);
        }
        return null;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GaInputStepMeta)smi;
        this.data = (GaInputStepData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GaInputStepMeta)smi;
        this.data = (GaInputStepData)sdi;
        super.dispose(smi, sdi);
    }
}

